
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#include <WinUser32.mqh>
//#include <stdlib.mqh>
#import "stdlib.ex4"
   string ErrorDescription(int a0);
   bool CompareDoubles(double a0, double a1);

#import "user32.dll"
   int RegisterWindowMessageA(string a0);
#import

extern int BrickSize = 7;
extern int BrickOffset = 0;
extern int RenkoTimeFrame = 2;
extern bool ShowWicks = TRUE;
extern bool EmulateOnLineChart = TRUE;
extern bool VarSymbol = FALSE;
int gi_100 = -1;
int gi_104 = 0;
int gi_108 = WM_NULL;
string gs_112;
int gi_120 = 0;
double gd_124;
double gd_132;
double gd_140;
double gd_148;
double gd_156;
double gd_164;
double gd_172;
double gd_180;
double gd_188;
double gd_196;
double gd_204;
double gd_212;
int gi_220;

void f0_0() {
   if (gi_120 == 0) {
      gi_120 = WindowHandle(gs_112, RenkoTimeFrame);
      if (gi_120 != 0) Print("Chart window detected");
   }
   if (EmulateOnLineChart && gi_108 == 0) gi_108 = RegisterWindowMessageA("MetaTrader4_Internal_Message");
   if (gi_120 != 0)
      if (PostMessageA(gi_120, WM_COMMAND, 33324, 0) == 0) gi_120 = 0;
   if (gi_120 != 0 && gi_108 != 0) PostMessageA(gi_120, gi_108, 2, 1);
}

int start() {
   int li_4;
   int li_8;
   int lia_12[13];
   int li_20;
   if (gi_100 < 0) {
      if (!IsConnected()) {
         Print("Waiting for connection...");
         return (0);
      }
      if (!IsDllsAllowed()) {
         Print("Error: Dll calls must be allowed!");
         return (-1);
      }
      if (MathAbs(BrickOffset) >= BrickSize) {
         Print("Error: |BrickOffset| should be less then BrickSize!");
         return (-1);
      }
      switch (RenkoTimeFrame) {
      case PERIOD_M1:
      case PERIOD_M5:
      case PERIOD_M15:
      case PERIOD_M30:
      case PERIOD_H1:
      case PERIOD_H4:
      case PERIOD_D1:
      case PERIOD_W1:
      case PERIOD_MN1:
      case 0:
         Print("Error: Invald time frame. use 2min for offline Renko chart !");
         return (-1);
      }
      li_4 = BrickSize;
      li_8 = BrickOffset;
      if (Digits == 5 || (Digits == 3 && StringFind(Symbol(), "JPY") != -1)) {
         li_4 = 10 * li_4;
         li_8 = 10 * li_8;
      }
      if (Digits == 6 || (Digits == 4 && StringFind(Symbol(), "JPY") != -1)) {
         li_4 = 100 * li_4;
         li_8 = 100 * li_8;
      }
      if (VarSymbol) gs_112 = StringSubstr(Symbol(), 0, 6);
      else gs_112 = Symbol();
      gd_124 = NormalizeDouble(li_4 * Point, Digits);
      gd_148 = NormalizeDouble(li_8 * Point + MathFloor((Close[Bars - 1]) / gd_124) * gd_124, Digits);
      gd_140 = gd_148;
      gd_156 = gd_148 + gd_124;
      gd_132 = gd_156;
      gd_164 = gd_148;
      gd_172 = gd_156;
      gd_180 = 1;
      gi_220 = Time[Bars - 1];
      gi_100 = FileOpenHistory(gs_112 + RenkoTimeFrame + ".hst", FILE_BIN|FILE_WRITE);
      if (gi_100 < 0) {
         Print("Error: Can\'t create / open history file: " + ErrorDescription(GetLastError()) + ": " + gs_112 + RenkoTimeFrame + ".hst");
         return (-1);
      }
      FileWriteInteger(gi_100, 400, LONG_VALUE);
      FileWriteString(gi_100, "", 64);
      FileWriteString(gi_100, gs_112, 12);
      FileWriteInteger(gi_100, RenkoTimeFrame, LONG_VALUE);
      FileWriteInteger(gi_100, Digits, LONG_VALUE);
      FileWriteInteger(gi_100, 0, LONG_VALUE);
      FileWriteInteger(gi_100, 0, LONG_VALUE);
      FileWriteArray(gi_100, lia_12, 0, 13);
      for (int li_16 = Bars - 2; li_16 >= 0; li_16--) {
         gd_180 += Volume[li_16];
         gd_132 = MathMax(gd_132, High[li_16]);
         gd_140 = MathMin(gd_140, Low[li_16]);
         li_20 = High[li_16] + Low[li_16] > High[li_16 + 1] + (Low[li_16 + 1]);
         while (li_20 && Low[li_16] < gd_148 - gd_124 || CompareDoubles(Low[li_16], gd_148 - gd_124)) {
            gd_156 -= gd_124;
            gd_148 -= gd_124;
            gd_164 = gd_156;
            gd_172 = gd_148;
            FileWriteInteger(gi_100, gi_220, LONG_VALUE);
            FileWriteDouble(gi_100, gd_164, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_148, DOUBLE_VALUE);
            if (ShowWicks && gd_132 > gd_156) FileWriteDouble(gi_100, gd_132, DOUBLE_VALUE);
            else FileWriteDouble(gi_100, gd_156, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_172, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_180, DOUBLE_VALUE);
            gd_132 = 0;
            gd_140 = EMPTY_VALUE;
            gd_180 = 0;
            gd_196 = gd_148;
            gd_188 = gd_148;
            if (gi_220 < Time[li_16]) gi_220 = Time[li_16];
            else gi_220++;
         }
         while (High[li_16] > gd_156 + gd_124 || CompareDoubles(High[li_16], gd_156 + gd_124)) {
            gd_156 += gd_124;
            gd_148 += gd_124;
            gd_164 = gd_148;
            gd_172 = gd_156;
            FileWriteInteger(gi_100, gi_220, LONG_VALUE);
            FileWriteDouble(gi_100, gd_164, DOUBLE_VALUE);
            if (ShowWicks && gd_140 < gd_148) FileWriteDouble(gi_100, gd_140, DOUBLE_VALUE);
            else FileWriteDouble(gi_100, gd_148, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_156, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_172, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_180, DOUBLE_VALUE);
            gd_132 = 0;
            gd_140 = EMPTY_VALUE;
            gd_180 = 0;
            gd_196 = gd_156;
            gd_188 = gd_156;
            if (gi_220 < Time[li_16]) gi_220 = Time[li_16];
            else gi_220++;
         }
         while (!li_20 && Low[li_16] < gd_148 - gd_124 || CompareDoubles(Low[li_16], gd_148 - gd_124)) {
            gd_156 -= gd_124;
            gd_148 -= gd_124;
            gd_164 = gd_156;
            gd_172 = gd_148;
            FileWriteInteger(gi_100, gi_220, LONG_VALUE);
            FileWriteDouble(gi_100, gd_164, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_148, DOUBLE_VALUE);
            if (ShowWicks && gd_132 > gd_156) FileWriteDouble(gi_100, gd_132, DOUBLE_VALUE);
            else FileWriteDouble(gi_100, gd_156, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_172, DOUBLE_VALUE);
            FileWriteDouble(gi_100, gd_180, DOUBLE_VALUE);
            gd_132 = 0;
            gd_140 = EMPTY_VALUE;
            gd_180 = 0;
            gd_196 = gd_148;
            gd_188 = gd_148;
            if (gi_220 < Time[li_16]) gi_220 = Time[li_16];
            else gi_220++;
         }
      }
      gi_104 = FileTell(gi_100);
      Comment("Brick Size (" + BrickSize + "): To view Renko chart open offline ", gs_112, " M", RenkoTimeFrame);
      if (Close[0] > MathMax(gd_172, gd_164)) gd_204 = MathMax(gd_172, gd_164);
      else {
         if (Close[0] < MathMin(gd_172, gd_164)) gd_204 = MathMin(gd_172, gd_164);
         else gd_204 = Close[0];
      }
      gd_212 = Close[0];
      if (gd_132 > gd_156) gd_196 = gd_132;
      if (gd_140 < gd_148) gd_188 = gd_140;
      FileWriteInteger(gi_100, gi_220, LONG_VALUE);
      FileWriteDouble(gi_100, gd_204, DOUBLE_VALUE);
      FileWriteDouble(gi_100, gd_188, DOUBLE_VALUE);
      FileWriteDouble(gi_100, gd_196, DOUBLE_VALUE);
      FileWriteDouble(gi_100, gd_212, DOUBLE_VALUE);
      FileWriteDouble(gi_100, gd_180, DOUBLE_VALUE);
      FileFlush(gi_100);
      f0_0();
      return (0);
   }
   gd_132 = MathMax(gd_132, Bid);
   gd_140 = MathMin(gd_140, Bid);
   gd_180++;
   FileSeek(gi_100, gi_104, SEEK_SET);
   if (Bid > gd_156 + gd_124 || CompareDoubles(Bid, gd_156 + gd_124)) {
      gd_156 += gd_124;
      gd_148 += gd_124;
      gd_164 = gd_148;
      gd_172 = gd_156;
      FileWriteInteger(gi_100, gi_220, LONG_VALUE);
      FileWriteDouble(gi_100, gd_164, DOUBLE_VALUE);
      if (ShowWicks && gd_140 < gd_148) FileWriteDouble(gi_100, gd_140, DOUBLE_VALUE);
      else FileWriteDouble(gi_100, gd_148, DOUBLE_VALUE);
      FileWriteDouble(gi_100, gd_156, DOUBLE_VALUE);
      FileWriteDouble(gi_100, gd_172, DOUBLE_VALUE);
      FileWriteDouble(gi_100, gd_180, DOUBLE_VALUE);
      FileFlush(gi_100);
      gi_104 = FileTell(gi_100);
      if (gi_220 < TimeCurrent()) gi_220 = TimeCurrent();
      else gi_220++;
      gd_180 = 0;
      gd_196 = gd_156;
      gd_188 = gd_156;
      gd_132 = 0;
      gd_140 = EMPTY_VALUE;
      f0_0();
   } else {
      if (Bid < gd_148 - gd_124 || CompareDoubles(Bid, gd_148 - gd_124)) {
         gd_156 -= gd_124;
         gd_148 -= gd_124;
         gd_164 = gd_156;
         gd_172 = gd_148;
         FileWriteInteger(gi_100, gi_220, LONG_VALUE);
         FileWriteDouble(gi_100, gd_164, DOUBLE_VALUE);
         FileWriteDouble(gi_100, gd_148, DOUBLE_VALUE);
         if (ShowWicks && gd_132 > gd_156) FileWriteDouble(gi_100, gd_132, DOUBLE_VALUE);
         else FileWriteDouble(gi_100, gd_156, DOUBLE_VALUE);
         FileWriteDouble(gi_100, gd_172, DOUBLE_VALUE);
         FileWriteDouble(gi_100, gd_180, DOUBLE_VALUE);
         FileFlush(gi_100);
         gi_104 = FileTell(gi_100);
         if (gi_220 < TimeCurrent()) gi_220 = TimeCurrent();
         else gi_220++;
         gd_180 = 0;
         gd_196 = gd_148;
         gd_188 = gd_148;
         gd_132 = 0;
         gd_140 = EMPTY_VALUE;
         f0_0();
      } else {
         if (Bid > gd_196) gd_196 = Bid;
         if (Bid < gd_188) gd_188 = Bid;
         if (gd_156 <= Bid) gd_204 = gd_156;
         else {
            if (gd_148 >= Bid) gd_204 = gd_148;
            else gd_204 = Bid;
         }
         gd_212 = Bid;
         FileWriteInteger(gi_100, gi_220, LONG_VALUE);
         FileWriteDouble(gi_100, gd_204, DOUBLE_VALUE);
         FileWriteDouble(gi_100, gd_188, DOUBLE_VALUE);
         FileWriteDouble(gi_100, gd_196, DOUBLE_VALUE);
         FileWriteDouble(gi_100, gd_212, DOUBLE_VALUE);
         FileWriteDouble(gi_100, gd_180, DOUBLE_VALUE);
         FileFlush(gi_100);
         f0_0();
      }
   }
   return (0);
}

int deinit() {
   if (gi_100 >= 0) {
      FileClose(gi_100);
      gi_100 = -1;
   }
   Comment("");
   return (0);
}