#property copyright "Roman Rich"
#property link      "http://www.ForeXRays.narod.ru"
#property version   "1.00"

input double        Risk=0.27;
//
input double        L1N1ToL2N1Weight= 1.0, L1N1ToL2N2Weight= 0.2, L1N1ToL2N3Weight=-0.8, L1N1ToL2N4Weight=-0.6;
input double        L1N2ToL2N1Weight= 0.0, L1N2ToL2N2Weight= 0.4, L1N2ToL2N3Weight=-1.0, L1N2ToL2N4Weight=-0.8;
input double        L1N3ToL2N1Weight= 0.4, L1N3ToL2N2Weight= 0.0, L1N3ToL2N3Weight=-0.2, L1N3ToL2N4Weight= 0.6;
input double        L1N4ToL2N1Weight= 0.8, L1N4ToL2N2Weight= 0.4, L1N4ToL2N3Weight= 0.0, L1N4ToL2N4Weight= 0.0;
double              L1N1Input, L1N2Input, L1N3Input, L1N4Input;
double              L2N1Input, L2N2Input, L2N3Input, L2N4Input;
double              NetResult;
//
double              OpenPrice[], ClosePrice[];
datetime            Time[];
MqlTick             Tick;
MqlTradeRequest     Request;
MqlTradeCheckResult Check;
MqlTradeResult      Result;
MqlDateTime         PrevTime, CurTime;
double              CurPosVolume, ReqPosVolume;
bool                Succes;
char                Order;
double              FiveDayRange;
int                 i;

int OnInit()
{
  CopyTime(Symbol(),Period(),0,2,Time);
  ArraySetAsSeries(Time,true);
  TimeToStruct(Time[1],PrevTime);
  TimeToStruct(Time[0],CurTime);
  return(0);
}

void OnDeinit(const int reason)
{
}

void OnTick()
{
  CopyTime(Symbol(),Period(),0,1,Time);
  ArraySetAsSeries(Time,true);
  TimeToStruct(Time[0],CurTime);
  if(PrevTime.day!=CurTime.day)
  {
    Net();
    if(PositionsTotal()!=0) ResetPosition();
    PrevTime=CurTime;
  }
  if(PositionsTotal()==0) SetPosition();
}

void Net()
{
  CopyOpen (Symbol(),Period(),0,21,OpenPrice );
  CopyClose(Symbol(),Period(),0,21,ClosePrice);
  CopyTime (Symbol(),Period(),0,1,Time      );
  ArraySetAsSeries(OpenPrice ,true);
  ArraySetAsSeries(ClosePrice,true);

  if(ClosePrice[1 ]>=OpenPrice[1 ]) L1N1Input=1; else L1N1Input=0;
  if(ClosePrice[2 ]>=OpenPrice[2 ]) L1N2Input=1; else L1N2Input=0;
  if(ClosePrice[5 ]>=OpenPrice[5 ]) L1N3Input=1; else L1N3Input=0;
  if(ClosePrice[20]>=OpenPrice[20]) L1N4Input=1; else L1N4Input=0;

  L2N1Input=L1N1Input*L1N1ToL2N1Weight+L1N2Input*L1N2ToL2N1Weight+L1N3Input*L1N3ToL2N1Weight+L1N4Input*L1N4ToL2N1Weight;
  L2N2Input=L1N1Input*L1N1ToL2N2Weight+L1N2Input*L1N2ToL2N2Weight+L1N3Input*L1N3ToL2N2Weight+L1N4Input*L1N4ToL2N2Weight;
  L2N3Input=L1N1Input*L1N1ToL2N3Weight+L1N2Input*L1N2ToL2N3Weight+L1N3Input*L1N3ToL2N3Weight+L1N4Input*L1N4ToL2N3Weight;
  L2N4Input=L1N1Input*L1N1ToL2N4Weight+L1N2Input*L1N2ToL2N4Weight+L1N3Input*L1N3ToL2N4Weight+L1N4Input*L1N4ToL2N4Weight;
  
  NetResult=L2N1Input+L2N2Input+L2N3Input+L2N4Input;
  
  if(NetResult>=0) Order='B'; else Order='S';
}

void SetPosition()
{
  switch(Order)
  {
    case 'B':
    {
      SymbolInfoTick(Symbol(),Tick);
      CopyOpen (Symbol(),Period(),0,6,OpenPrice );
      CopyClose(Symbol(),Period(),0,6,ClosePrice);
      ArraySetAsSeries(OpenPrice ,true);
      ArraySetAsSeries(ClosePrice,true);
      FiveDayRange=(MathAbs(OpenPrice[5]-ClosePrice[5])+MathAbs(OpenPrice[4]-ClosePrice[4])+MathAbs(OpenPrice[3]-ClosePrice[3])+MathAbs(OpenPrice[2]-ClosePrice[2])+MathAbs(OpenPrice[1]-ClosePrice[1]))/5;
      CurPosVolume=0;
      ReqPosVolume=MathMax(MathMin(MathFloor(AccountInfoDouble(ACCOUNT_EQUITY)*Risk
                  /
                  (FiveDayRange*MathPow(10,SymbolInfoInteger(Symbol(),SYMBOL_DIGITS))*
                                           SymbolInfoDouble(Symbol(),SYMBOL_TRADE_TICK_VALUE_PROFIT)*
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_STEP)))*
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_STEP),
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_LIMIT)),
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN)
                  );
      while(CurPosVolume<ReqPosVolume)
      {
        SymbolInfoTick(Symbol(),Tick);
        Request.action=TRADE_ACTION_DEAL;
        Request.symbol=Symbol();
        Request.volume=MathMin((ReqPosVolume-CurPosVolume),MathMax(MathMin(ReqPosVolume,SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MAX)),SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN)));
        Request.price=Tick.ask;
        Request.sl=0;
        Request.tp=0;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_DIGITS))
        {
          case 2: Request.deviation=5;  break;
          case 3: Request.deviation=50; break;
          case 4: Request.deviation=5;  break;
          case 5: Request.deviation=50; break;
        }
        Request.type=ORDER_TYPE_BUY;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_FILLING_MODE))
        {
          case 1: Request.type_filling=ORDER_FILLING_AON;    break;
          case 2: Request.type_filling=ORDER_FILLING_CANCEL; break;
          case 3: Request.type_filling=ORDER_FILLING_RETURN; break;
        }
        if(OrderCheck(Request,Check)==true) Succes=OrderSend(Request,Result);
        Sleep(5000);
        if(Succes==true) CurPosVolume=CurPosVolume+Request.volume;
      }
      break;
    }
    case 'S':
    {
      SymbolInfoTick(Symbol(),Tick);
      CopyOpen (Symbol(),Period(),0,6,OpenPrice );
      CopyClose(Symbol(),Period(),0,6,ClosePrice);
      ArraySetAsSeries(OpenPrice ,true);
      ArraySetAsSeries(ClosePrice,true);
      FiveDayRange=(MathAbs(OpenPrice[5]-ClosePrice[5])+MathAbs(OpenPrice[4]-ClosePrice[4])+MathAbs(OpenPrice[3]-ClosePrice[3])+MathAbs(OpenPrice[2]-ClosePrice[2])+MathAbs(OpenPrice[1]-ClosePrice[1]))/5;
      CurPosVolume=0;
      ReqPosVolume=MathMax(MathMin(MathFloor(AccountInfoDouble(ACCOUNT_EQUITY)*Risk
                  /
                  (FiveDayRange*MathPow(10,SymbolInfoInteger(Symbol(),SYMBOL_DIGITS))*
                                           SymbolInfoDouble(Symbol(),SYMBOL_TRADE_TICK_VALUE_PROFIT)*
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_STEP)))*
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_STEP),
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_LIMIT)),
                                           SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN)
                  );
      while(CurPosVolume<ReqPosVolume)
      {
        SymbolInfoTick(Symbol(),Tick);
        Request.action=TRADE_ACTION_DEAL;
        Request.symbol=Symbol();
        Request.volume=MathMin((ReqPosVolume-CurPosVolume),MathMax(MathMin(ReqPosVolume,SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MAX)),SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN)));
        Request.price=Tick.bid;
        Request.sl=0;
        Request.tp=0;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_DIGITS))
        {
          case 2: Request.deviation=5;  break;
          case 3: Request.deviation=50; break;
          case 4: Request.deviation=5;  break;
          case 5: Request.deviation=50; break;
        }
        Request.type=ORDER_TYPE_SELL;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_FILLING_MODE))
        {
          case 1: Request.type_filling=ORDER_FILLING_AON;    break;
          case 2: Request.type_filling=ORDER_FILLING_CANCEL; break;
          case 3: Request.type_filling=ORDER_FILLING_RETURN; break;
        }
        if(OrderCheck(Request,Check)==true) Succes=OrderSend(Request,Result);
        Sleep(5000);
        if(Succes==true) CurPosVolume=CurPosVolume+Request.volume;
      }
      break;
    }
  }
}

void ResetPosition()
{
  PositionSelect(Symbol());
  switch(PositionGetInteger(POSITION_TYPE))
  {
    case POSITION_TYPE_SELL:
    {
      SymbolInfoTick(Symbol(),Tick);
      CurPosVolume=PositionGetDouble(POSITION_VOLUME);
      ReqPosVolume=0;
      while(PositionsTotal()!=0)
      {
        SymbolInfoTick(Symbol(),Tick);
        Request.action=TRADE_ACTION_DEAL;
        Request.symbol=Symbol();
        Request.volume=MathMin((CurPosVolume-ReqPosVolume),MathMax(MathMin(CurPosVolume,SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MAX)),SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN)));
        Request.price=Tick.ask;
        Request.sl=0;
        Request.tp=0;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_DIGITS))
        {
          case 2: Request.deviation=5;  break;
          case 3: Request.deviation=50; break;
          case 4: Request.deviation=5;  break;
          case 5: Request.deviation=50; break;
        }
        Request.type=ORDER_TYPE_BUY;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_FILLING_MODE))
        {
          case 1: Request.type_filling=ORDER_FILLING_AON;    break;
          case 2: Request.type_filling=ORDER_FILLING_CANCEL; break;
          case 3: Request.type_filling=ORDER_FILLING_RETURN; break;
        }
        if(OrderCheck(Request,Check)==true) Succes=OrderSend(Request,Result);
        Sleep(5000);
        if(Succes==true) CurPosVolume=CurPosVolume-Request.volume;
      }
      break;
    }
    case POSITION_TYPE_BUY:
    {
      SymbolInfoTick(Symbol(),Tick);
      CurPosVolume=PositionGetDouble(POSITION_VOLUME);
      ReqPosVolume=0;
      while(PositionsTotal()!=0)
      {
        SymbolInfoTick(Symbol(),Tick);
        Request.action=TRADE_ACTION_DEAL;
        Request.symbol=Symbol();
        Request.volume=MathMin((CurPosVolume-ReqPosVolume),MathMax(MathMin(CurPosVolume,SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MAX)),SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN)));
        Request.price=Tick.bid;
        Request.sl=0;
        Request.tp=0;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_DIGITS))
        {
          case 2: Request.deviation=5;  break;
          case 3: Request.deviation=50; break;
          case 4: Request.deviation=5;  break;
          case 5: Request.deviation=50; break;
        }
        Request.type=ORDER_TYPE_SELL;
        switch(SymbolInfoInteger(Symbol(),SYMBOL_FILLING_MODE))
        {
          case 1: Request.type_filling=ORDER_FILLING_AON;    break;
          case 2: Request.type_filling=ORDER_FILLING_CANCEL; break;
          case 3: Request.type_filling=ORDER_FILLING_RETURN; break;
        }
        if(OrderCheck(Request,Check)==true) Succes=OrderSend(Request,Result);
        Sleep(5000);
        if(Succes==true) CurPosVolume=CurPosVolume-Request.volume;
      }
      break;
    }
  }
}