//+------------------------------------------------------------------+
//|                                                          rtr.mq5 |
//|                                                        urachacha |
//+------------------------------------------------------------------+
#property copyright "urachacha"
#property version   "0.10"

//--- include & objects
#include <data.mqh>
#include <prediction.mqh>
#include <TrailingStop.mqh>
#include <lot.mqh>
Data data;
Prediction prediction;
TrailingStop trailing_stop;
Lot lot;

//--- "BASIC" input parameters
input int      PARAM_BASE_PERIOD                =   30;

//--- "Prediction" input parameters
input double   PARAM_ADX_VALUE                  =   35;
input int      PARAM_ADX_AVG_COUNT              =    3;
input double   PARAM_ADX_FALSE_PERMIT_RATIO     =  0.2;

input int      PARAM_StdDev_AVG_COUNT           =    3;
input double   PARAM_StdDev_FALSE_PERMIT_RATIO  = 0.15;

input int      PARAM_StdDev2_AVG_COUNT          =    3;
input int      PARAM_StdDev2_PERIOD             =   50;

input int      PARAM_Predictor_Scale_Factor     =   10;

//--- "Order" input parameters
input double   PARAM_Initial_TP_PRODUCT_AGAINST_MIN_DEVIATION = 5;
input double   PARAM_Initial_SL_PRODUCT_AGAINST_MIN_DEVIATION = 6;

//--- other input parameters
input ulong    PARAM_UNSTABLE_PERIOD_AGAINST_NEWS_TIME = 30 * 60; 
input int      PARAM_POSITION_EXPIRE_PRODUCT_AGAINST_BASE_PERIOD = 5;

input int      PARAM_TRADE_HISTORY_LENGTH = 5;

input double   PARAM_LOT_SCALE_UP_FACTOR = 3.0;
input double   PARAM_LOT_SCALE_DOWN_FACTOR = 0.8;

input bool     PARAM_DIRECTION_REVERSE = true;

// global variables
int            ExtHandle_iADX=0;
int            ExtHandle_iStdDev=0;
int            ExtHandle_iStdDev2=0;
int            ExtHandle_iMA=0;
double         iADX_value[];
double         iStdDev_value[];
double         iStdDev_value2[];
double         iMA_value[];

bool           trade_history[];
bool           did_win_last_trade;
bool           is_there_position;
double         last_lots;
double         last_stop_loss;


//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
{

   //Print("SPREAD = " + data.getSpread(_Symbol, _Point));
   //Print("MIN_DEVIATION = " + data.getMinDeviation(_Symbol, _Point));

   prediction.initialize(PARAM_BASE_PERIOD, 
                         PARAM_ADX_VALUE, PARAM_ADX_AVG_COUNT, PARAM_ADX_FALSE_PERMIT_RATIO, 
                         PARAM_StdDev_AVG_COUNT, PARAM_StdDev_FALSE_PERMIT_RATIO, 
                         PARAM_StdDev2_AVG_COUNT, PARAM_StdDev2_PERIOD, 
                         PARAM_Predictor_Scale_Factor);
   ExtHandle_iADX = iADX(_Symbol,_Period, PARAM_ADX_AVG_COUNT);
   ExtHandle_iStdDev = iStdDev(_Symbol,_Period,PARAM_StdDev_AVG_COUNT,0,MODE_EMA,PRICE_WEIGHTED);
   ExtHandle_iStdDev2 = iStdDev(_Symbol,_Period,PARAM_StdDev2_AVG_COUNT,0,MODE_EMA,PRICE_WEIGHTED);
   ExtHandle_iMA = iMA(_Symbol,_Period,PARAM_StdDev_AVG_COUNT,0,MODE_EMA,PRICE_WEIGHTED);
   
   ArrayResize(iADX_value,PARAM_BASE_PERIOD);
   ArrayResize(iStdDev_value,PARAM_BASE_PERIOD);
   ArrayResize(iStdDev_value2,PARAM_StdDev2_PERIOD);
   ArrayResize(iMA_value,PARAM_BASE_PERIOD);
   
   ArrayResize(trade_history,PARAM_TRADE_HISTORY_LENGTH);
   ArrayInitialize(iADX_value, 0);
   ArrayInitialize(iStdDev_value,0);
   ArrayInitialize(iStdDev_value2,0);
   ArrayInitialize(iMA_value,0);
   ArrayInitialize(trade_history,true);
   
   did_win_last_trade = true; // be optimistic, not an engineer :)
   is_there_position = false;
   last_lots = 0;
   last_stop_loss = 0;
   
   return(0);
}
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{

   
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
{
   update_position_history();
   
   if(check_for_position_open() == true){
       double p_value = prediction.getPredictor(iADX_value, iStdDev_value, iStdDev_value2, iMA_value, PARAM_DIRECTION_REVERSE);
       int order_type = 0;
       double order_price = 0;
       double sl = 0;
       double tp = 0;
       double order_stoplimit_price = 0;
       if(p_value > 0){
         order_type = ORDER_TYPE_BUY;
         order_price = SymbolInfoDouble(_Symbol, SYMBOL_ASK) - data.getMinDeviation(_Symbol, _Point);
         sl = order_price - PARAM_Initial_SL_PRODUCT_AGAINST_MIN_DEVIATION * data.getMinDeviation(_Symbol, _Point);
         tp = order_price + PARAM_Initial_TP_PRODUCT_AGAINST_MIN_DEVIATION * data.getMinDeviation(_Symbol, _Point);
       }else if(p_value <0){
         order_type = ORDER_TYPE_SELL;
         order_price = SymbolInfoDouble(_Symbol, SYMBOL_BID) - data.getMinDeviation(_Symbol, _Point);
         sl = order_price + PARAM_Initial_SL_PRODUCT_AGAINST_MIN_DEVIATION * data.getMinDeviation(_Symbol, _Point);
         tp = order_price - PARAM_Initial_TP_PRODUCT_AGAINST_MIN_DEVIATION * data.getMinDeviation(_Symbol, _Point);
       }
                   
       MqlTradeRequest trade_request;
       trade_request.action = TRADE_ACTION_DEAL;
       trade_request.symbol = _Symbol;
       trade_request.volume = lot.getLots(getWinningRate(), did_win_last_trade, last_lots, data.getMinDeviation(_Symbol, _Point), PARAM_LOT_SCALE_UP_FACTOR, PARAM_LOT_SCALE_DOWN_FACTOR);     
       trade_request.price = order_price;
       trade_request.sl = sl;
       trade_request.tp = tp;
       trade_request.type = order_type;
       trade_request.deviation = data.getMinDeviation(_Symbol, _Point) / _Point;
       trade_request.type_filling = ORDER_FILLING_AON;
       MqlTradeResult  trade_result;

       OrderSend(trade_request,trade_result);
   }


   if(is_there_position == true){
       if(PositionSelect(_Symbol)){
           MqlTradeRequest trade_request;
           double initial_sl_gap = data.getMinDeviation(_Symbol, _Point) * PARAM_Initial_SL_PRODUCT_AGAINST_MIN_DEVIATION;
           double min_sl_gap = data.getMinDeviation(_Symbol, _Point);
           int    position_type = PositionGetInteger(POSITION_TYPE);
           double position_sl = PositionGetDouble(POSITION_SL);
           datetime position_open_time = PositionGetInteger(POSITION_TIME);
           int    base_time_in_sec = data.getTimeframeToSeconds(_Period) * PARAM_BASE_PERIOD;

           double current_market_price = 0;
           if(position_type == POSITION_TYPE_BUY){
               current_market_price = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
           }else{
               current_market_price = SymbolInfoDouble(_Symbol, SYMBOL_BID);
           }
                      
           bool updated = trailing_stop.update_sl(trade_request,
                                          data, current_market_price,  
                                          position_type, position_sl, position_open_time, min_sl_gap, 
                                          initial_sl_gap, base_time_in_sec, PARAM_UNSTABLE_PERIOD_AGAINST_NEWS_TIME, PARAM_POSITION_EXPIRE_PRODUCT_AGAINST_BASE_PERIOD); // update trade_request.sl

           if(updated == true){
               MqlTradeResult  trade_result;
               trade_request.action = TRADE_ACTION_SLTP;
               trade_request.symbol = _Symbol;
               trade_request.tp = PositionGetDouble(POSITION_TP);
               trade_request.deviation = data.getMinDeviation(_Symbol, _Point) / _Point * 2;
               //Print("######## TRAILING STOP ############# ASK:" + SymbolInfoDouble(_Symbol, SYMBOL_ASK) + ", Origial SL:"+ PositionGetDouble(POSITION_SL) + ", Original Open" + PositionGetDouble(POSITION_PRICE_OPEN));               
               OrderSend(trade_request,trade_result);
               
           }else{
               //Print("Stop Limit update failure"); // sl_update failure
           }
       }
   }

}


//+------------------------------------------------------------------+
//| Sub functions                                                    |
//+------------------------------------------------------------------+
void update_position_history(){
   int position_count = PositionsTotal();
   
   if(position_count > 0){
      is_there_position = true;
      PositionSelect(_Symbol);
      last_lots = PositionGetDouble(POSITION_VOLUME);
      last_stop_loss = PositionGetDouble(POSITION_SL);
   }
   
   if(is_there_position == true && position_count == 0){
      is_there_position = false;
      double gap = MathAbs(last_stop_loss - (SymbolInfoDouble(_Symbol, SYMBOL_ASK) + SymbolInfoDouble(_Symbol, SYMBOL_BID))*0.5);
      if(gap < data.getSpread(_Symbol, _Point)){
         did_win_last_trade = false;
         bool trade_history_temp[];
         ArrayInitialize(trade_history_temp,PARAM_TRADE_HISTORY_LENGTH);
         ArrayCopy(trade_history_temp, trade_history, 1, 0, PARAM_TRADE_HISTORY_LENGTH-1);
         trade_history_temp[0] = did_win_last_trade;
         ArrayCopy(trade_history, trade_history_temp, 0, 0, PARAM_TRADE_HISTORY_LENGTH);
      }else{
         did_win_last_trade = true;
         bool trade_history_temp[];
         ArrayInitialize(trade_history_temp,PARAM_TRADE_HISTORY_LENGTH);
         ArrayCopy(trade_history_temp, trade_history, 1, 0, PARAM_TRADE_HISTORY_LENGTH-1);
         trade_history_temp[0] = did_win_last_trade;
         ArrayCopy(trade_history, trade_history_temp, 0, 0, PARAM_TRADE_HISTORY_LENGTH);
      }
   }
}

bool check_for_position_open(){
   copy_prediction_related_indicators();
   double p_value = prediction.getPredictor(iADX_value, iStdDev_value, iStdDev_value2, iMA_value, PARAM_DIRECTION_REVERSE);

   if(PositionsTotal() == 0 && p_value != 0
//      && data.getClosestNewsTimeDistance(_Symbol, TimeCurrent(), PARAM_UNSTABLE_PERIOD_AGAINST_NEWS_TIME) != 0 
//      && data.getMarketSleepTimeDistance(_Symbol, TimeCurrent()) != 0 
      ){
      return true;
   }else{
      return false;
   }
}

void copy_prediction_related_indicators(){
   if(CopyBuffer(ExtHandle_iADX,0,0,PARAM_BASE_PERIOD,iADX_value)!=PARAM_BASE_PERIOD)
   {
      Print("CopyBuffer from iADX failed, not enuogh data");
   }
   if(CopyBuffer(ExtHandle_iStdDev,0,0,PARAM_BASE_PERIOD,iStdDev_value)!= PARAM_BASE_PERIOD)
   {
      Print("CopyBuffer from iStdDev failed, not enuogh data");
   }
   if(CopyBuffer(ExtHandle_iStdDev2,0,0,PARAM_StdDev2_PERIOD,iStdDev_value2)!= PARAM_StdDev2_PERIOD)
   {
      Print("CopyBuffer from iStdDev2 failed, not enuogh data");
   }
   if(CopyBuffer(ExtHandle_iMA,0,0,PARAM_BASE_PERIOD,iMA_value)!=PARAM_BASE_PERIOD)
   {
      Print("CopyBuffer from iMA failed, not enuogh data");
   }
}


double getWinningRate(){
   int count = 0;
   for(int i=0; i<PARAM_TRADE_HISTORY_LENGTH; i++){
      if(trade_history[i] == true){
         count++;
      }
   }
   return count * 1.0 / PARAM_TRADE_HISTORY_LENGTH;
}
