//+------------------------------------------------------------------+
//|                                               LuckyFishM_1_m.mq5 |
//|                                        Copyright Andrei Medvedev |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Andrei medvedev"
#property version   "1.00"

#include <Trade\Trade.mqh>
#include <Trade\SymbolInfo.mqh>
#include <Trade\DealInfo.mqh>

//------------------------------------------------------------------ CExpertAdvisor
class CExpertAdvisor
  {
protected:
   bool              m_bInit;       //   
   ulong             m_magic;       //  
   string            m_smb;         // ,    
   ENUM_TIMEFRAMES   m_tf;          //  
   CSymbolInfo       m_smbinf;      //  
   int               m_timer;       //   

public:
   double            m_pnt;         //    5/3  
   CTrade            m_trade;       //     
   string            m_inf;         //       

public:
   //--- 
   void              CExpertAdvisor();                               // 
   void             ~CExpertAdvisor();                               // 
   virtual bool      Init(long magic,string smb,ENUM_TIMEFRAMES tf); // 

   //---  
   virtual bool      Main();                            //     
   virtual void      OpenPosition(long dir) {};         //   
   virtual void      CheckPosition(long dir) {};        //     
   virtual void      ClosePosition(long dir) {};        //  
   virtual void      BEPosition(long dir,int BE);       //    
   virtual void      TrailingPosition(long dir,int TS); //  
   virtual void      OpenPending(long dir) {};          //    
   virtual void      CheckPending(long dir) {};         //       
   virtual void      TrailingPending(long dir) {};      //   
   virtual void      DeletePending(long dir) {};        //   

   //---   /
   bool              CheckNewBar();                            //    
   bool              CheckTime(datetime start,datetime end);   //    
   virtual long      CheckSignal(bool bEntry) { return(-1); }; //   
   virtual bool      CheckFilter(long dir) { return(false); }; //    
   bool SetTimer(int sec)                                      //  
     { m_timer=sec; return(EventSetTimer(m_timer)); }
   int GetTimer() { return(m_timer); }                         //    
   void KillTimer() { EventKillTimer(); }                      //    

   //---  
   double            CountLotByRisk(int dist,double risk,double lot); //     
   ulong             DealOpen(long dir,double lot,int SL,int TP);     //     
   ulong             GetDealByOrder(ulong order);                     //      
   double            CountProfitByDeal(ulong ticket);                 //      

   //---   
   long              BaseType(long dir);             //       
   long              ReversType(long dir);           //       
   long              StopType(long dir);             //   -   
   long              LimitType(long dir);            //   -   

   //---  
   double            NormalPrice(double d);          //  
   double            NormalDbl(double d, int n=-1);  //    
   double            BasePrice(long dir);            //   Bid/Ask   
   double            ReversPrice(long dir);          //   Bid/Ask   
   double            NormalOpen(int dir,double op,double stop); //     
   double            NormalTP(int dir, double op, double pr, int TP, double stop); //       
   double            NormalSL(int dir, double op, double pr, int SL, double stop); //       
   double            NormalLot(double lot);          //      

   //--- -
   void              AddInfo(string st,bool ini=false);            //    m_inf 
   void              ErrorHandle(int err,ulong ticket,string str); //    
  };
//------------------------------------------------------------------ CExpertAdvisor
void CExpertAdvisor::CExpertAdvisor()
  {
   m_bInit=false;
  }
//------------------------------------------------------------------ ~CExpertAdvisor
void CExpertAdvisor::~CExpertAdvisor()
  {
  }
//------------------------------------------------------------------ Init
bool CExpertAdvisor::Init(long magic,string smb,ENUM_TIMEFRAMES tf)
  {
   m_magic=magic; m_smb=smb; m_tf=tf;     //   
   m_smbinf.Name(m_smb);                  //  
   m_pnt=m_smbinf.Point();                //    5/3 
   if(m_smbinf.Digits()==5 || m_smbinf.Digits()==3) m_pnt*=10; // 
   m_trade.SetExpertMagicNumber(m_magic); //    

   m_bInit=true; return(true);            // " "
  }
//---  
//------------------------------------------------------------------ Main
bool CExpertAdvisor::Main() //  
  {
   if(!m_bInit) return(false);
   if(!MQL5InfoInteger(MQL5_TRADE_ALLOWED) || !TerminalInfoInteger(TERMINAL_CONNECTED))
      return(false);                            //   ,  
   m_inf="";                                    //   

   m_smbinf.Refresh(); m_smbinf.RefreshRates(); //   
   return(true);
  }
//------------------------------------------------------------------ BEPositin
void CExpertAdvisor::BEPosition(long dir,int BE)
  {
   double tp,sl,apr,csl,cop,ctp;
   if(!PositionSelect(m_smb)) return;                       //     ,  
   m_smbinf.Refresh(); m_smbinf.RefreshRates();             //   
   double StopLvl=m_smbinf.StopsLevel()*m_smbinf.Point();   // Stop Level
   double FreezLvl=m_smbinf.FreezeLevel()*m_smbinf.Point(); // Freeze level
   apr=ReversPrice(dir);
   cop=NormalDbl(PositionGetDouble(POSITION_PRICE_OPEN));   //   
   csl=NormalDbl(PositionGetDouble(POSITION_SL));           // 
   ctp=NormalDbl(PositionGetDouble(POSITION_TP));           // 
   if(MathAbs(ctp-apr)<=FreezLvl || MathAbs(csl-apr)<=FreezLvl) return;          //   
   sl=NormalPrice(dir==ORDER_TYPE_BUY ? cop+BE*m_pnt:cop-BE*m_pnt);              //    
   if((dir==ORDER_TYPE_BUY && sl<apr+StopLvl && (sl>csl || csl==NormalPrice(0))) //   
      || (dir==ORDER_TYPE_SELL && sl>apr-StopLvl && (sl<csl || csl==NormalPrice(0))))
     {
      if(!m_trade.PositionModify(m_smb,sl,ctp))             //   
         ErrorHandle(GetLastError(),PositionGetInteger(POSITION_IDENTIFIER),"-BEPosition ");
     }
  }
//------------------------------------------------------------------ TralPos
void CExpertAdvisor::TrailingPosition(long dir,int TS)
  {
   double tp,sl,apr,csl,cop,ctp;
   if(TS<=0) return;
   if(!PositionSelect(m_smb)) return;                       //     ,  
   m_smbinf.Refresh(); m_smbinf.RefreshRates();             //   
   double StopLvl=m_smbinf.StopsLevel()*m_smbinf.Point();   // Stop Level
   double FreezLvl=m_smbinf.FreezeLevel()*m_smbinf.Point(); // Freeze level
   apr=ReversPrice(dir);
   cop=NormalDbl(PositionGetDouble(POSITION_PRICE_OPEN));   //   
   csl=NormalDbl(PositionGetDouble(POSITION_SL));           // 
   ctp=NormalDbl(PositionGetDouble(POSITION_TP));           // 
   if(MathAbs(ctp-apr)<=FreezLvl || MathAbs(csl-apr)<=FreezLvl) return;  //   
   sl=NormalSL(dir,apr,apr,TS,StopLvl);                     //  
   if((dir==ORDER_TYPE_BUY && apr-cop>TS*m_pnt && (sl>cop && (sl>csl || csl==NormalPrice(0)))) //  
      || (dir==ORDER_TYPE_SELL && cop-apr>TS*m_pnt && (sl<cop && (sl<csl || csl==NormalPrice(0)))))
     {
      if(!m_trade.PositionModify(m_smb,sl,ctp))             //     
         ErrorHandle(GetLastError(),PositionGetInteger(POSITION_IDENTIFIER),"-TrailingPosition ");
     }
  }
//---   /
//------------------------------------------------------------------ CheckNewBar
bool CExpertAdvisor::CheckNewBar() //   
  {
   MqlRates rt[2];
   if(CopyRates(m_smb,m_tf,0,2,rt)!=2) //  
     { Print("CopyRates of ",m_smb," failed, no history"); return(false); }
   if(rt[1].tick_volume>1) return(false); //   
   return(true);
  }
//---------------------------------------------------------------   CheckTime
bool CExpertAdvisor::CheckTime(datetime start,datetime end)
  {
   datetime dt=TimeCurrent();                          //  
   if(start<end) if(dt>=start && dt<end) return(true); //    
   if(start>=end) if(dt>=start|| dt<end) return(true);
   return(false);
  }
//---  
//---------------------------------------------------------------   CountLotByRisk
double CExpertAdvisor::CountLotByRisk(int dist,double risk,double lot) //     
  {
   if(dist==0 || risk==0) return(lot);
   m_smbinf.Refresh();
   return(NormalLot(AccountInfoDouble(ACCOUNT_BALANCE)*risk/(dist*10*m_smbinf.TickValue())));
  }
//------------------------------------------------------------------	DealOpen
ulong CExpertAdvisor::DealOpen(long dir,double lot,int SL,int TP)
  {
   double op,sl,tp,apr,StopLvl;
//   
   m_smbinf.RefreshRates(); m_smbinf.Refresh();
   StopLvl=m_smbinf.StopsLevel()*m_smbinf.Point(); //  
   apr=ReversPrice(dir); op=BasePrice(dir);        //  
   sl=NormalSL(dir, op, apr, SL, StopLvl);         // 
   tp=NormalTP(dir, op, apr, TP, StopLvl);         // 

                                                   //  
   m_trade.PositionOpen(m_smb,(ENUM_ORDER_TYPE)dir,lot,op,sl,tp);
   ulong order=m_trade.ResultOrder(); if(order<=0) return(0); //  
   return(GetDealByOrder(order));                  //   
  }
//---------------------------------------------------------------   GetDealByOrder
ulong CExpertAdvisor::GetDealByOrder(ulong order) //      
  {
   PositionSelect(m_smb);
   HistorySelectByPosition(PositionGetInteger(POSITION_IDENTIFIER));
   uint total=HistoryDealsTotal();
   for(uint i=0; i<total; i++)
     {
      ulong deal=HistoryDealGetTicket(i);
      if(order==HistoryDealGetInteger(deal,DEAL_ORDER))
         return(deal);                            //    
     }
   return(0);
  }
//---------------------------------------------------------------   CountProfit
double CExpertAdvisor::CountProfitByDeal(ulong ticket)//     
  {
   CDealInfo deal; deal.Ticket(ticket);               //  
   HistorySelect(deal.Time(),TimeCurrent());          //     
   uint total=HistoryDealsTotal();
   long pos_id=deal.PositionId();                     //   
   double prof=0;
   for(uint i=0; i<total; i++)                        //      
     {
      ticket=HistoryDealGetTicket(i);
      if(HistoryDealGetInteger(ticket,DEAL_POSITION_ID)!=pos_id) continue;
      prof+=HistoryDealGetDouble(ticket,DEAL_PROFIT); //  
     }
   return(prof);                                      //  
  }
//---   
//---------------------------------------------------------------   DIR
long CExpertAdvisor::BaseType(long dir)
  {
   if(dir==ORDER_TYPE_BUY || dir==ORDER_TYPE_BUY_STOP || dir==ORDER_TYPE_BUY_LIMIT) return(ORDER_TYPE_BUY);
   if(dir==ORDER_TYPE_SELL || dir==ORDER_TYPE_SELL_STOP || dir==ORDER_TYPE_SELL_LIMIT) return(ORDER_TYPE_SELL);
   return(-1);
  }
//------------------------------------------------------------------	ADIR
long CExpertAdvisor::ReversType(long dir)
  {
   if(dir==ORDER_TYPE_BUY || dir==ORDER_TYPE_BUY_STOP || dir==ORDER_TYPE_BUY_LIMIT) return(ORDER_TYPE_SELL);
   if(dir==ORDER_TYPE_SELL || dir==ORDER_TYPE_SELL_STOP || dir==ORDER_TYPE_SELL_LIMIT) return(ORDER_TYPE_BUY);
   return(-1);
  }
//---------------------------------------------------------------   SDIR
long CExpertAdvisor::StopType(long dir)
  {
   if(dir==ORDER_TYPE_BUY || dir==ORDER_TYPE_BUY_STOP || dir==ORDER_TYPE_BUY_LIMIT) return(ORDER_TYPE_BUY_STOP);
   if(dir==ORDER_TYPE_SELL || dir==ORDER_TYPE_SELL_STOP || dir==ORDER_TYPE_SELL_LIMIT) return(ORDER_TYPE_SELL_STOP);
   return(-1);
  }
//---------------------------------------------------------------   LDIR
long CExpertAdvisor::LimitType(long dir)
  {
   if(dir==ORDER_TYPE_BUY || dir==ORDER_TYPE_BUY_STOP || dir==ORDER_TYPE_BUY_LIMIT) return(ORDER_TYPE_BUY_LIMIT);
   if(dir==ORDER_TYPE_SELL || dir==ORDER_TYPE_SELL_STOP || dir==ORDER_TYPE_SELL_LIMIT) return(ORDER_TYPE_SELL_LIMIT);
   return(-1);
  }

//---  
//---------------------------------------------------------------   ND
double CExpertAdvisor::NormalDbl(double d,int n=-1) {  if(n<0) return(::NormalizeDouble(d,m_smbinf.Digits())); return(NormalizeDouble(d,n)); }
//---------------------------------------------------------------   NP
double CExpertAdvisor::NormalPrice(double d) { return(NormalDbl(MathRound(d/m_smbinf.TickSize())*m_smbinf.TickSize())); }
//---------------------------------------------------------------   NPR
double CExpertAdvisor::BasePrice(long dir)
  {
   if(dir==(long)ORDER_TYPE_BUY) return(m_smbinf.Ask());
   if(dir==(long)ORDER_TYPE_SELL) return(m_smbinf.Bid());
   return(WRONG_VALUE);
  }
//---------------------------------------------------------------   APR
double CExpertAdvisor::ReversPrice(long dir)
  {
   if(dir==(long)ORDER_TYPE_BUY) return(m_smbinf.Bid());
   if(dir==(long)ORDER_TYPE_SELL) return(m_smbinf.Ask());
   return(WRONG_VALUE);
  }
//---------------------------------------------------------------   NOP
double CExpertAdvisor::NormalOpen(int dir,double op,double stop)
  {
   if(dir==ORDER_TYPE_BUY_LIMIT) return(NormalPrice(MathMin(op,m_smbinf.Ask()-stop)));
   if(dir==ORDER_TYPE_BUY_STOP) return(NormalPrice(MathMax(op,m_smbinf.Ask()+stop)));
   if(dir==ORDER_TYPE_SELL_LIMIT) return(NormalPrice(MathMax(op,m_smbinf.Bid()+stop)));
   if(dir==ORDER_TYPE_SELL_STOP) return(NormalPrice(MathMin(op,m_smbinf.Bid()-stop)));
   return(WRONG_VALUE);
  }
//---------------------------------------------------------------   NTP
double CExpertAdvisor::NormalTP(int dir,double op,double pr,int TP,double stop)
  {
   if(TP==0) return(NormalPrice(0));
   if(dir==ORDER_TYPE_BUY || dir==ORDER_TYPE_BUY_STOP || dir==ORDER_TYPE_BUY_LIMIT) return(NormalPrice(MathMax(op+TP*m_pnt,pr+stop)));
   if(dir==ORDER_TYPE_SELL || dir==ORDER_TYPE_SELL_STOP || dir==ORDER_TYPE_SELL_LIMIT) return(NormalPrice(MathMin(op-TP*m_pnt,pr-stop)));
   return(WRONG_VALUE);
  }
//---------------------------------------------------------------   NSL
double CExpertAdvisor::NormalSL(int dir,double op,double pr,int SL,double stop)
  {
   if(SL==0) return(NormalPrice(0));
   if(dir==ORDER_TYPE_BUY || dir==ORDER_TYPE_BUY_STOP || dir==ORDER_TYPE_BUY_LIMIT) return(NormalPrice(MathMin(op-SL*m_pnt,pr-stop)));
   if(dir==ORDER_TYPE_SELL || dir==ORDER_TYPE_SELL_STOP || dir==ORDER_TYPE_SELL_LIMIT) return(NormalPrice(MathMax(op+SL*m_pnt,pr+stop)));
   return(WRONG_VALUE);
  }
//---------------------------------------------------------------   NL
double CExpertAdvisor::NormalLot(double lot)
  {
   int k=0;
   double ll=lot,ls=m_smbinf.LotsStep();
   if(ls<=0.001) k=3; else if(ls<=0.01) k=2; else if(ls<=0.1) k=1;
   ll=NormalDbl(MathMin(m_smbinf.LotsMax(),MathMax(m_smbinf.LotsMin(),ll)),k);
   return(ll);
  }
//---  
//---------------------------------------------------------------   INF
void CExpertAdvisor::AddInfo(string st,bool ini=false)
  {
   string zn="\n      ",zzn="\n               ";
   if(ini) m_inf=m_inf+zn+st; else m_inf=m_inf+zzn+st;
  }
//---------------------------------------------------------------   ErrorHandle
void CExpertAdvisor::ErrorHandle(int err,ulong ticket,string str)
  {
   Print("-Err(",err,") ",m_magic," #",ticket," | "+str);
   switch(err)
     {
      case TRADE_RETCODE_REJECT:
      case TRADE_RETCODE_TOO_MANY_REQUESTS:
         Sleep(2000);        // wait 2 seconds
         break;

      case TRADE_RETCODE_PRICE_OFF:
      case TRADE_RETCODE_PRICE_CHANGED:
      case TRADE_RETCODE_REQUOTE:
         m_smbinf.Refresh(); // refresh symbol info
         m_smbinf.RefreshRates();
         break;
     }
  }
//+------------------------------------------------------------------+




double LotsEURUSD=0.1;  // 
double LotKoefEURUSD=2.0; //     
input int DistEURUSD=50;     

double LotsGBPUSD=0.1;  // 
double LotKoefGBPUSD=2.0; //     
input int DistGBPUSD=165;      

double LotsUSDCHF=0.1;  // 
double LotKoefUSDCHF=2.0; //     
input int DistUSDCHF=165;     

//double LotsUSDJPY=0.1;  // 
//double LotKoefUSDJPY=2.0; //     
//input int DistUSDJPY=190;      

//double LotsUSDCAD=0.1;  // 
//double LotKoefUSDCAD=2.0; //     
//input int DistUSDCAD=150;   

//double LotsAUDUSD=0.1;  // 
//double LotKoefAUDUSD=2.0; //     
//input int DistAUDUSD=195;      //     

//---
class CMartiEA : public CExpertAdvisor
  {
protected:
   double            m_lots;       // 
   double            m_lotkoef;    //     
   int               m_dist;       //     
   CDealInfo         m_deal;       //  
   bool              m_first;      //    

public:
   void CMartiEA() { }
   void ~CMartiEA() { }
   virtual bool      Init(string smb,ENUM_TIMEFRAMES tf); // 
   virtual void      OpenPosition();
   virtual void      CheckPosition();
  };
//------------------------------------------------------------------	Init
bool CMartiEA::Init(string smb,ENUM_TIMEFRAMES tf)
  {
   if(!CExpertAdvisor::Init(0,smb,tf)) return(false); //   
   
   if (smb == "EURUSD") { m_lots=LotsEURUSD; m_lotkoef=LotKoefEURUSD; m_dist=DistEURUSD;}
   if (smb == "GBPUSD") { m_lots=LotsGBPUSD; m_lotkoef=LotKoefGBPUSD; m_dist=DistGBPUSD;}
   if (smb == "USDCHF") { m_lots=LotsUSDCHF; m_lotkoef=LotKoefUSDCHF; m_dist=DistUSDCHF;}
//   if (smb == "USDJPY") { m_lots=LotsUSDJPY; m_lotkoef=LotKoefUSDJPY; m_dist=DistUSDJPY;}
//   if (smb == "USDCAD") { m_lots=LotsUSDCAD; m_lotkoef=LotKoefUSDCAD; m_dist=DistUSDCAD;}
//   if (smb == "AUDUSD") { m_lots=LotsAUDUSD; m_lotkoef=LotKoefAUDUSD; m_dist=DistAUDUSD;}
   
   m_deal.Ticket(0); m_first=true;
   m_bInit=true; return(true);                        // " "
  }
//------------------------------------------------------------------	OnTrade
void CMartiEA::OpenPosition()
  {
   if(!CExpertAdvisor::Main()) return;                       //   
   if(!m_first) return;                                      //     
   ulong deal=DealOpen(ORDER_TYPE_BUY,m_lots,m_dist,m_dist); //   
   if(deal>0) { m_deal.Ticket(deal); m_first=false; }        //   
  }
//------------------------------------------------------------------	OnTrade
void CMartiEA::CheckPosition()
  {
   if(!CExpertAdvisor::Main()) return; //   
   if(m_first) return;                 //      
   if(PositionSelect(m_smb)) return;   //   

   //    
   double lot=m_lots;                       //  
   long dir=m_deal.Type();                  //  
   if(CountProfitByDeal(m_deal.Ticket())<0) //   
     {
      lot=NormalLot(m_lotkoef*m_deal.Volume()); //  
      dir=ReversType(m_deal.Type());            //  
     }
   ulong deal=DealOpen(dir,lot,m_dist,m_dist); //  
   if(deal>0) m_deal.Ticket(deal);             //  
  }

CMartiEA ea1; //  
CMartiEA ea2; //  
CMartiEA ea3; //  
//CMartiEA ea4; //  
//CMartiEA ea5; //  
//CMartiEA ea6; //  

//------------------------------------------------------------------	OnInit
int OnInit()
  {
   ea1.Init("EURUSD", PERIOD_M15); //     
   ea2.Init("GBPUSD", PERIOD_M15); //     
   ea3.Init("USDCHF", PERIOD_M15); //     
//   ea4.Init("USDJPY", PERIOD_M15); //     
//   ea5.Init("USDCAD", PERIOD_M15); //     
//   ea6.Init("AUDUSD", PERIOD_M15); //     

   return(0);
  }
//------------------------------------------------------------------	OnDeinit
void OnDeinit(const int reason) { }
//------------------------------------------------------------------	OnTick
void OnTick()
  {
   ea1.OpenPosition(); //   -   
   ea2.OpenPosition(); //   -   
   ea3.OpenPosition(); //   -   
//   ea4.OpenPosition(); //   -   
//   ea5.OpenPosition(); //   -   
//   ea6.OpenPosition(); //   -   
  }
//------------------------------------------------------------------	OnTrade
void OnTrade()
  {
   ea1.CheckPosition(); //   
   ea2.CheckPosition(); //   
   ea3.CheckPosition(); //   
//   ea4.CheckPosition(); //   
//   ea5.CheckPosition(); //   
//   ea6.CheckPosition(); //   
  }