//+------------------------------------------------------------------+
//|                                                    VarMovAvg.mq5 |
//|                                      Copyright  2009, EarnForex |
//|                                        http://www.earnforex.com/ |
//|               Based on Var_Mov_Avg3.mq4 by GOODMAN & Mstera  AF |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, EarnForex"
#property link      "http://www.earnforex.com"
#property version   "1.00"
#property description "VarMovAvg - a mathematical superposition on the standard Moving Average approach."
#property description "Green dots signal bullish trend. Red dots signal bearish trend."
      
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_plots   2
#property indicator_type1 DRAW_LINE
#property indicator_type2 DRAW_COLOR_ARROW
#property indicator_color1 Sienna
#property indicator_color2 Green, Red, Gray
#property indicator_style1  STYLE_SOLID
#property indicator_style2  STYLE_SOLID
#property indicator_width1  2
#property indicator_width2  10

//---- input parameters
input int    periodAMA = 50;
input int    nfast     = 15;
input int    nslow     = 10;
input double G         = 1.0;
input double dK        = 0.1; 
input bool   UseSound  = true;
input string SoundFile = "expert.wav"; 

//---- buffers
double kAMAbuffer[];
double kAMAsig[];
double kAMAsigcol[];

//+------------------------------------------------------------------+
double slowSC, fastSC;
bool SoundBuy = true;
bool SoundSell = true;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
{
   IndicatorSetString(INDICATOR_SHORTNAME, "VarMovAvg");
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);

   //---- indicators
   PlotIndexSetInteger(1, PLOT_ARROW, 159);
   
   //SetIndexDrawBegin(0,nslow+nfast);
   SetIndexBuffer(0, kAMAbuffer, INDICATOR_DATA);
   SetIndexBuffer(1, kAMAsig,    INDICATOR_DATA);
   SetIndexBuffer(2, kAMAsigcol, INDICATOR_COLOR_INDEX);
}

//+------------------------------------------------------------------+
//| Data Calculation Function for Indicator                          |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &Close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   int    i, pos = 0, dir = 0, limit;
   double noise, AMA, AMA0, signal, ER;
   double dSC, ERSC, SSC, ddK;
   
   ArraySetAsSeries(Close, true);

   if (prev_calculated == rates_total) return(rates_total);
    
   slowSC = (2.0 / (nslow + 1));
   fastSC = (2.0 / (nfast + 1));

   if (rates_total <= (periodAMA + 2)) return(rates_total);

   if ((rates_total - prev_calculated) < (periodAMA + 2)) limit = periodAMA + 2;
   else limit = rates_total;
   
   pos = limit - periodAMA - 2;
   AMA0 = Close[pos+1];

   while (pos >= 0)
   {
      if (pos == (limit - periodAMA - 2)) AMA0 = Close[pos+1];
      signal = MathAbs(Close[pos] - Close[pos+periodAMA]);
      noise = 0.000000001;
      for (i = 0; i < periodAMA; i++)
      {
         noise = noise + MathAbs(Close[pos+i] - Close[pos+i+1]);
      }
      ER = signal / noise;
      dSC = (fastSC - slowSC);
      ERSC = ER * dSC;
      SSC = ERSC + slowSC;
      AMA = AMA0 + (MathPow(SSC, G) * (Close[pos] - AMA0));
      kAMAbuffer[rates_total - pos - 1] = AMA;

      ddK = (AMA - AMA0);
      kAMAsig[rates_total - pos - 1] = AMA;
      if ((MathAbs(ddK)) > (dK * _Point) && (ddK > 0)) kAMAsigcol[rates_total - pos - 1] = 0;
      else if ((MathAbs(ddK)) > (dK * _Point) && (ddK < 0)) kAMAsigcol[rates_total - pos - 1] = 1;
      else kAMAsigcol[rates_total - pos - 1] = 2;
     
      AMA0 = AMA;
      pos--;
   }

   if ((kAMAsig[rates_total-1] != EMPTY_VALUE) && (kAMAsigcol[rates_total-1] == 0) && (SoundBuy))
   {
      SoundBuy = false;
      if (UseSound) PlaySound(SoundFile);
      Comment(Symbol(), " ", Period(), "hellkkas BUY @ ", SymbolInfoDouble(Symbol(), SYMBOL_ASK));
      Alert(Symbol(), " ", Period(), "hellkkas BUY @ ", SymbolInfoDouble(Symbol(), SYMBOL_ASK));
   } 
   if ((!SoundBuy) && ((kAMAsig[rates_total-1] == EMPTY_VALUE) || (kAMAsigcol[rates_total-1] != 0))) SoundBuy = true;  
  
   if ((kAMAsig[rates_total-1] != EMPTY_VALUE) && (kAMAsigcol[rates_total-1] == 1) && (SoundSell))
   {
      SoundSell = false;
      if (UseSound) PlaySound(SoundFile);
      Comment(Symbol(), " ", Period(), "hellkkas Sell @", SymbolInfoDouble(Symbol(), SYMBOL_BID));
      Alert(Symbol(), " ", Period(), "hellkkas Sell @", SymbolInfoDouble(Symbol(), SYMBOL_BID));
   }
   if ((!SoundSell) && ((kAMAsig[rates_total-1] == EMPTY_VALUE) || (kAMAsigcol[rates_total-1] != 1))) SoundSell = true;  

   return(rates_total);
}

