//+------------------------------------------------------------------+
//|Based on totel_power_indicator.mq4 by Daniel Fernandez            |
//|Asirikuy.com 2011                                                 |
//|                                          TotalPowerIndicator.mq5 |
//|                                  Copyright  2011, EarnForex.com |
//|                                         http://www.earnforex.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, www.EarnForex.com"
#property link      "http://www.earnforex.com/"
#property version   "1.0"

#property description "Displays the concentration of bull power periods, bear power periods"
#property description " and total periods when either bulls or bears had prevailance."

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_plots   3
#property indicator_minimum -20
#property indicator_maximum 120
#property indicator_color1 clrLightSeaGreen
#property indicator_label1 "Total Power"
#property indicator_type1  DRAW_LINE
#property indicator_width1 2
#property indicator_style1 STYLE_SOLID
#property indicator_level1 0
#property indicator_color2 clrCrimson
#property indicator_label2 "Bear Power"
#property indicator_type2  DRAW_LINE
#property indicator_width2 2
#property indicator_style2 STYLE_SOLID
#property indicator_level2 50
#property indicator_color3 clrDarkGreen
#property indicator_label3 "Bull Power"
#property indicator_type3  DRAW_LINE
#property indicator_width3 2
#property indicator_style3 STYLE_SOLID
#property indicator_level3 100

input int LookbackPeriod = 45;
input int PowerPeriod = 10 ;

//---- buffers
double power[];
double bearbuffer[];
double bullbuffer[];

// Buffers for CopyBuffer of the standard indicators
double BearB[], BullB[];

// Global variables
int myBear, myBull;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
{
   IndicatorSetString(INDICATOR_SHORTNAME, "TPI (" + IntegerToString(LookbackPeriod) + ", " + IntegerToString(PowerPeriod) + ")");
   SetIndexBuffer(0, power, INDICATOR_DATA);
   SetIndexBuffer(1, bearbuffer, INDICATOR_DATA);
   SetIndexBuffer(2, bullbuffer, INDICATOR_DATA);
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, EMPTY_VALUE);

   IndicatorSetInteger(INDICATOR_DIGITS, 1);

   myBear = iBearsPower(NULL, 0, PowerPeriod);
   myBull = iBullsPower(NULL, 0, PowerPeriod);
}

//+------------------------------------------------------------------+
//| Total Power Indicator                                            |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tickvolume[],
                const long &volume[],
                const int &spread[])
{
   int i;
   int counted_bars = prev_calculated;

   if (rates_total < (PowerPeriod + LookbackPeriod)) return(0);

   i = counted_bars;
   if (i < (PowerPeriod + LookbackPeriod)) i = PowerPeriod + LookbackPeriod;
 
   // Getting indicators handles
   while (i < rates_total) 
   {
      int bearcount = 0;
      int bullcount = 0;
	   
	   if (CopyBuffer(myBear, 0, rates_total - i - 1, LookbackPeriod, BearB) != LookbackPeriod) return(0);
	   if (CopyBuffer(myBull, 0, rates_total - i - 1, LookbackPeriod, BullB) != LookbackPeriod) return(0);
	
	   for (int k = LookbackPeriod - 1; k >= 0; k--)
	   {
      	if (BearB[k] < 0) bearcount++;
      	if (BullB[k] > 0) bullcount++;
	   }
	
	   power[i] = MathAbs(bullcount - bearcount) * 100 / LookbackPeriod;
	   bearbuffer[i] = bearcount * 100 / LookbackPeriod;
	   bullbuffer[i] = bullcount * 100 / LookbackPeriod;
   
      i++;
   }
 
   return(rates_total);
}
//+------------------------------------------------------------------+