//+------------------------------------------------------------------+
//|	     	                        				           	 QQE.mq5 |
//|                                      Copyright  2010, EarnForex |
//|                                         http://www.earnforex.com |
//|                             Based on version by Tim Hyder (2008) |
//|                         Based on version by Roman Ignatov (2006) |
//+------------------------------------------------------------------+
#property copyright "www.EarnForex.com, 2010"
#property link      "http://www.earnforex.com"
#property version   "1.0"
#property description "QQE - Qualitative Quantitative Estimation."
#property description "Calculated as two indicators:"
#property description "1) MA on RSI"
#property description "2) Difference of MA on RSI and MA of MA of ATR of MA of RSI"
#property description "The signal for buy is when blue line crosses level 50 from below"
#property description "after crossing the yellow line from below."
#property description "The signal for sell is when blue line crosses level 50 from above"
#property description "after crossing the yellow line from above."

#property indicator_separate_window
#property indicator_buffers 6
#property indicator_plots   2
#property indicator_width1 2
#property indicator_color1 DodgerBlue
#property indicator_type1 DRAW_LINE
#property indicator_style1 STYLE_SOLID
#property indicator_width2 1
#property indicator_color2 Yellow
#property indicator_type2 DRAW_LINE
#property indicator_style2 STYLE_DOT
#property indicator_level1 50
#property indicator_levelcolor Aqua
#property indicator_levelstyle STYLE_DOT

// Inputs
input int SF = 5; //Smoothing Factor
input int AlertLevel = 50;
input bool MsgAlerts = true;
input bool SoundAlerts = true;
input string SoundAlertFile = "alert.wav";
input bool eMailAlerts = false;

// Variables
int RSI_Period = 14;
int Wilders_Period;
int StartBar, LastAlertBar;
datetime LastAlertTime;
bool FirstTime = true;

// Buffers
double TrLevelSlow[];
double AtrRsi[];
double MaAtrRsi[];
double Rsi[];
double RsiMa[];
double MaMaAtrRsi[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
{
   Wilders_Period = RSI_Period * 2 - 1;
   
   if (Wilders_Period < SF)
      StartBar = SF;
   else
      StartBar = Wilders_Period;

   SetIndexBuffer(0, RsiMa, INDICATOR_DATA);
   SetIndexBuffer(1, TrLevelSlow, INDICATOR_DATA);
   SetIndexBuffer(2, AtrRsi, INDICATOR_CALCULATIONS);
   SetIndexBuffer(3, MaAtrRsi, INDICATOR_CALCULATIONS);
   SetIndexBuffer(4, Rsi, INDICATOR_CALCULATIONS);
   SetIndexBuffer(5, MaMaAtrRsi, INDICATOR_CALCULATIONS);

   ArraySetAsSeries(RsiMa, true);
   ArraySetAsSeries(TrLevelSlow, true);
   ArraySetAsSeries(AtrRsi, true);
   ArraySetAsSeries(MaAtrRsi, true);
   ArraySetAsSeries(Rsi, true);
	ArraySetAsSeries(MaMaAtrRsi, true);

   PlotIndexSetString(0, PLOT_LABEL, "Fast RSI MA");
   PlotIndexSetString(1, PLOT_LABEL, "Slow RSI MA");
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, StartBar);
   PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, StartBar);

	IndicatorSetString(INDICATOR_SHORTNAME, "QQE(" + IntegerToString(SF) + ")");

   LastAlertBar = Bars(Symbol(), Period()) - 1;
}

//+------------------------------------------------------------------+
//| Custom QQE			                                                |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   int counted, i;
   double rsi0, rsi1, dar, tr, dv;
   
   if (rates_total <= StartBar) return(0);
   
   if (prev_calculated == 0) FirstTime = true;

   counted = prev_calculated;
   if (counted < 1)
      for (i = rates_total - StartBar; i < rates_total; i++)
      {
      	TrLevelSlow[i] = 0.0;
         AtrRsi[i] = 0.0;
         MaAtrRsi[i] = 0.0;
         Rsi[i] = 0.0;
         RsiMa[i] = 0.0;
         MaMaAtrRsi[i] = 0.0;
      }

   counted = rates_total - counted;
	if (counted - 2 >= 0) counted -= 2;
	
   int myRSI = iRSI(NULL, 0, RSI_Period, PRICE_CLOSE);
   if  (CopyBuffer(myRSI, 0, 0, counted + 2, Rsi) != counted + 2) return(0);

	// Fills "counted" cells of RsiMA with EMA of Rsi
	CalculateEMA(counted + 1, SF, Rsi, RsiMa);

   for (i = counted; i >= 0; i--)
		AtrRsi[i] = MathAbs(RsiMa[i + 1] - RsiMa[i]);
   
	// Fills "counted" cells of MaAtrRsi with EMA of AtrRsi
   CalculateEMA(counted, Wilders_Period, AtrRsi, MaAtrRsi);

   i = counted + 1;
   tr = TrLevelSlow[i];
   
   rsi1 = RsiMa[i];

	CalculateEMA(counted, Wilders_Period, MaAtrRsi, MaMaAtrRsi);
   while (i > 0)
   {
      i--;
      rsi0 = RsiMa[i];
      dar = MaMaAtrRsi[i] * 4.236;
      dv = tr;

      if (rsi0 < tr)
      {
      	tr = rsi0 + dar;
         if ((rsi1 < dv) && (tr > dv)) tr = dv;
      }
      else if (rsi0 > tr)
      {
      	tr = rsi0 - dar;
         if ((rsi1 > dv) && (tr < dv)) tr = dv;
      }
      
      TrLevelSlow[i] = tr;
      rsi1 = rsi0;
   }
   
   if (((RsiMa[i + 1] < AlertLevel) && (RsiMa[i] > AlertLevel)) || ((RsiMa[i + 1] > AlertLevel) && (RsiMa[i] < AlertLevel)))
   {
      string base = Symbol() + ", TF: " + TF2Str(Period());
      string Subj = base + ", " + IntegerToString(AlertLevel) + " level Cross Up";
      if ((RsiMa[i + 1] > AlertLevel) && (RsiMa[i] < AlertLevel)) Subj = base + " " +  IntegerToString(AlertLevel) + " level Cross Down";
      string Msg = Subj + " @ " + TimeToString(TimeLocal(), TIME_SECONDS);
      if (rates_total > LastAlertBar)
      {
         LastAlertBar = rates_total;
         DoAlerts(Msg, Subj);
      }
   }

   return(rates_total);
}

//+------------------------------------------------------------------+
//| Sends the alert signals according to user options						|
//+------------------------------------------------------------------+
void DoAlerts(string msgText, string eMailSub)
{
   if (MsgAlerts)   Alert(msgText);
   if (SoundAlerts) PlaySound(SoundAlertFile);
   if (eMailAlerts) SendMail(eMailSub, msgText);
}

//+------------------------------------------------------------------+
//| Converts timeframe period to string                              |
//+------------------------------------------------------------------+
string TF2Str(int period)
{
	switch(period)
   {
      case PERIOD_M1:  return("M1");
      case PERIOD_M5:  return("M5");
      case PERIOD_M15: return("M15");
      case PERIOD_M30: return("M30");
      case PERIOD_H1:  return("H1");
      case PERIOD_H4:  return("H4");
      case PERIOD_D1:  return("D1");
      case PERIOD_W1:  return("W1");
      case PERIOD_MN1: return("MN");
   }
   
   return(IntegerToString(Period()));
}

//+------------------------------------------------------------------+
//|  Exponential Moving Average                                      |
//|  Fills the buffer array with EMA values.									|
//+------------------------------------------------------------------+
void CalculateEMA(int begin, int period, const double &price[], double &result[])
{
   double SmoothFactor = 2.0 / (1.0 + period);
	int start;
	
   //First time
   if (FirstTime)
   {
   	result[begin] = price[begin];
   	start = begin - 1;
   	FirstTime = false;
   }
   else start = begin;
   for(int i = start; i >= 0; i--) result[i] = price[i] * SmoothFactor + result[i + 1] * (1.0 - SmoothFactor);
}
//+------------------------------------------------------------------+