//+--------------------------------------------------------------------------------+
//|                		Float.mq5                                                  |
//|                		Copyright  2005  Barry Stander  Barry_Stander_4@yahoo.com |
//|                		http://www.4Africa.net/4meta/                              |
//| 			       		Copyright  2010  Andriy Moraru  www.EarnForex.com     	  |
//|                		http://www.earnforex.com/         		                    |
//+--------------------------------------------------------------------------------+
#property copyright "Float Converted from MT4 to MT5"
#property link      "http://www.earnforex.com/"
#property description "Float - Trend strength, volume, Fibonacci and DiNapoli levels."

#property indicator_separate_window
#property indicator_buffers 2

#property indicator_plots   2
#property indicator_color1  Blue
#property indicator_type1   DRAW_HISTOGRAM
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
#property indicator_color2  Red
#property indicator_type2   DRAW_LINE
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1

input int Float = 200;
input bool use_fibos = true;
input bool Backtesting = false;

double high_bar, low_bar;
double cumulativeV, FLOATV, swing;
double prevbars;
double fib23, fib38, fib50, fib62, fib76;
double dinap0, dinap1, dinap2, dinap3, dinap4, dinap5;

double Buffer1[];
double Buffer2[];

bool   first = true;

int shift, swing_time, loopbegin1;
int cvstart, cvend, bars_high, bars_low;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
{
   string short_name = "Float";
 	IndicatorSetString(INDICATOR_SHORTNAME, short_name);
   
   SetIndexBuffer(0, Buffer1, INDICATOR_DATA);
   SetIndexBuffer(1, Buffer2, INDICATOR_DATA);
   
   ArraySetAsSeries(Buffer1, true);
   ArraySetAsSeries(Buffer2, true);

   PlotIndexSetString(0, PLOT_LABEL, short_name);
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, 1000);

   PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, 1000);
}
  
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   ObjectDelete(0, "swingtop");
   ObjectDelete(0, "swingbottom"); 
 
   ObjectDelete(0, "fib23");
   ObjectDelete(0, "fib38");
   ObjectDelete(0, "fib50");
   ObjectDelete(0, "fib62");
   ObjectDelete(0, "fib76");

   ObjectDelete(0, "fib23t");
   ObjectDelete(0, "fib38t");
   ObjectDelete(0, "fib50t");
   ObjectDelete(0, "fib62t");
   ObjectDelete(0, "fib76t");

   ObjectDelete(0, "dinap0");
   ObjectDelete(0, "dinap1");
   ObjectDelete(0, "dinap2");
   ObjectDelete(0, "dinap3");
   ObjectDelete(0, "dinap4");
   ObjectDelete(0, "dinap5");

   ObjectDelete(0, "CVSTART");
   ObjectDelete(0, "CVEND");
   ObjectDelete(0, "swingend");
   ObjectDelete(0, "swingend2");
   ObjectDelete(0, "swingend3");
   ObjectDelete(0, "swingend4");
   ObjectDelete(0, "swingend5");
   ObjectDelete(0, "swingend6");
   ObjectDelete(0, "swingend7");
   ObjectDelete(0, "swingend8");
   ObjectDelete(0, "swingend9");
      
	Comment("");
}
  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &Time[],
                const double &open[],
                const double &High[],
                const double &Low[],
                const double &close[],
                const long &Volume[],
                const long &real_volume[],
                const int &spread[])
{
   ArraySetAsSeries(High, true);
   ArraySetAsSeries(Low, true);
   ArraySetAsSeries(Volume, true);
   ArraySetAsSeries(Time, true);
   
   int counted_bars = prev_calculated;
   if (counted_bars < 0) return(-1); // Exit if no data
    
   cumulativeV = 0;

   if ((rates_total < prevbars) || (rates_total - prevbars > 1))
   {
   	first = true;
   	prevbars = rates_total;
   	FLOATV = 0;

		loopbegin1 = rates_total - Float;

		for (shift = loopbegin1; shift >= 0; shift--)
		{
			//Find bar counts
			bars_high = ArrayMaximum(High, 1, Float);
			bars_low  = ArrayMinimum(Low, 1, Float);

			//Find High and Low
			high_bar = High[bars_high]; 
			low_bar  = Low[bars_low]; 
				
			//Find cumulative volume for float period
			if (bars_high < bars_low) //Uptrend
			{
				cvstart = bars_low;
				cvend = bars_high;
			}
			else //Downtrend
			{
				cvstart = bars_high;
				cvend = bars_low;
			}
				
			if ((first) && (FLOATV == 0))
			{
				for (shift = cvstart; shift >= cvend; shift--)
				{
					FLOATV = FLOATV + Volume[shift];
					first = false;
				}
			}
		}	

		//Find swing price differance
		swing = high_bar - low_bar;
		
		//Find float time barcount
		swing_time = MathAbs(bars_low - bars_high);
			

		//Find cumulative volume since last turnover
		for (shift = cvstart; shift >= 0; shift--)         //  for    2
		{
			cumulativeV = cumulativeV + Volume[shift];
			
			if (cumulativeV >= FLOATV) cumulativeV = 0;
			
			Buffer1[shift] = cumulativeV * 0.001; //Blue
			Buffer2[shift] = FLOATV * 0.001;      //Red
			
			Comment(
			"\n", "high was   ", bars_high, "  bars ago",
			"\n", "Low was    ", bars_low, " bars ago","\n",
			"\n", "Float time was  =      ", swing_time," bars",
			"\n", "Float Vol. left    =     ", FLOATV - cumulativeV,
			"\n", "Float Volume    =     ", FLOATV);

			//Comment out anything you're not using it will help with speed.
			if (Backtesting)
			{
				GlobalVariableSet("fib23", fib23);
				GlobalVariableSet("fib38", fib38);
				GlobalVariableSet("fib50", fib50);
				GlobalVariableSet("fib62", fib62);
				GlobalVariableSet("fib76", fib76);
				GlobalVariableSet("dinap0", dinap0);
				GlobalVariableSet("dinap1", dinap1);
				GlobalVariableSet("dinap2", dinap2);
				GlobalVariableSet("dinap3", dinap3);
				GlobalVariableSet("dinap4", dinap4);
				GlobalVariableSet("dinap5", dinap5);
				GlobalVariableSet("swingtop", high_bar);
				GlobalVariableSet("swingbottom", low_bar);
				GlobalVariableSet("CVSTART", cvstart);
				GlobalVariableSet("CVEND", cvend);
				GlobalVariableSet("FLOATV", FLOATV);
				GlobalVariableSet("cumulativeV", cumulativeV);
				GlobalVariableSet("swing_time", swing_time);
				GlobalVariableSet("bars_high", bars_high);
				GlobalVariableSet("bars_low", bars_low);
					
				if (cvend - swing_time > 0) GlobalVariableSet("swingend", cvend - swing_time + 5);
					
				if (cvend - swing_time * 2 > 0) GlobalVariableSet("swingend2", cvend - swing_time * 2 + 5);
					
				if (cvend - swing_time * 3 > 0) GlobalVariableSet("swingend3", cvend - swing_time * 3 + 5);
					
				if (cvend - swing_time * 4 > 0) GlobalVariableSet("swingend4", cvend - swing_time * 4 + 5);
					
				if (cvend - swing_time * 5 > 0) GlobalVariableSet("swingend5", cvend - swing_time * 5 + 5);
					
				if (cvend - swing_time * 6 > 0) GlobalVariableSet("swingend6", cvend - swing_time * 6 + 5);
					
				if (cvend - swing_time * 7 > 0) GlobalVariableSet("swingend7", cvend - swing_time * 7 + 5);
					
				if (cvend - swing_time * 8 > 0) GlobalVariableSet("swingend8", cvend - swing_time * 8 + 5);
				
				if (cvend - swing_time * 9 > 0) GlobalVariableSet("swingend9", cvend - swing_time * 9 + 5);
			} //End of Backtesting
	   }
		 
	 	ObjectDelete(0, "swingtop");
	 	ObjectCreate(0, "swingtop", OBJ_TREND, 0, Time[cvstart], high_bar, Time[1], high_bar);
	 	ObjectSetInteger(0, "swingtop", OBJPROP_STYLE, STYLE_SOLID);
	 	ObjectSetInteger(0, "swingtop", OBJPROP_COLOR , Blue);
	 	ObjectSetInteger(0, "swingtop", OBJPROP_RAY_LEFT, 0);
	 	ObjectSetInteger(0, "swingtop", OBJPROP_WIDTH, 1);
			
	 	ObjectDelete(0, "swingbottom");
	 	ObjectCreate(0, "swingbottom", OBJ_TREND, 0, Time[cvstart], low_bar, Time[1], low_bar);
	 	ObjectSetInteger(0, "swingbottom", OBJPROP_STYLE, STYLE_SOLID);
	 	ObjectSetInteger(0, "swingbottom", OBJPROP_COLOR, Blue);
	 	ObjectSetInteger(0, "swingbottom", OBJPROP_RAY_LEFT, 0);
	 	ObjectSetInteger(0, "swingbottom", OBJPROP_WIDTH, 1);
			 
		//Fibonacci
		if (use_fibos) 
		{
		   ObjectDelete(0, "fib23");
		   ObjectDelete(0, "fib38");
		   ObjectDelete(0, "fib50");
		   ObjectDelete(0, "fib62");
		   ObjectDelete(0, "fib76");
				
		   ObjectDelete(0, "dinap0");
		   ObjectDelete(0, "dinap1");
		   ObjectDelete(0, "dinap2");
		   ObjectDelete(0, "dinap3");
		   ObjectDelete(0, "dinap4");
		   ObjectDelete(0, "dinap5");
				
			fib23 = (swing * 0.236) + low_bar;
			fib38 = (swing * 0.382) + low_bar;
			fib50 = (swing * 0.500) + low_bar;
			fib62 = (swing * 0.618) + low_bar;
			fib76 = (swing * 0.764) + low_bar;
			dinap0 = (low_bar + fib23) / 2;
			dinap1 = (fib23 + fib38) / 2;
			dinap2 = (fib38 + fib50) / 2;
			dinap3 = (fib50 + fib62) / 2;
			dinap4 = (fib62 + fib76) / 2;
			dinap5 = (high_bar + fib76) / 2;
				
		 	ObjectCreate(0, "fib23", OBJ_TREND, 0, Time[cvstart], fib23, Time[1], fib23);
			ObjectSetInteger(0, "fib23", OBJPROP_STYLE, STYLE_DASH);
			ObjectSetInteger(0, "fib23", OBJPROP_COLOR, Green);
			ObjectSetInteger(0, "fib23", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "fib23", OBJPROP_WIDTH, 1);
			ObjectCreate(0, "fib23t", OBJ_TEXT, 0, Time[1], fib23);
			ObjectSetString(0,  "fib23t", OBJPROP_TEXT, "23.6");
			ObjectSetInteger(0, "fib23t", OBJPROP_FONTSIZE, 8);
			ObjectSetString(0,  "fib23t", OBJPROP_FONT, "Arial");
			ObjectSetInteger(0, "fib23t", OBJPROP_COLOR, Green);
				 
		 	ObjectCreate(0, "fib38", OBJ_TREND, 0, Time[cvstart], fib38, Time[1], fib38);
			ObjectSetInteger(0, "fib38", OBJPROP_STYLE, STYLE_DASH);
			ObjectSetInteger(0, "fib38", OBJPROP_COLOR, Green);
			ObjectSetInteger(0, "fib38", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "fib38", OBJPROP_WIDTH, 1);
			ObjectCreate(0, "fib38t", OBJ_TEXT, 0, Time[1], fib38);
			ObjectSetString(0,  "fib38t", OBJPROP_TEXT, "38.2");
			ObjectSetInteger(0, "fib38t", OBJPROP_FONTSIZE, 8);
			ObjectSetString(0,  "fib38t", OBJPROP_FONT, "Arial");
			ObjectSetInteger(0, "fib38t", OBJPROP_COLOR, Green);
		 	ObjectCreate(0, "fib50", OBJ_TREND, 0, Time[cvstart], fib50, Time[1], fib50);
			ObjectSetInteger(0, "fib50", OBJPROP_STYLE, STYLE_SOLID);
			ObjectSetInteger(0, "fib50", OBJPROP_COLOR, Red);
			ObjectSetInteger(0, "fib50", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "fib50", OBJPROP_WIDTH, 2);
			ObjectCreate(0, "fib50t", OBJ_TEXT, 0, Time[1], fib50);
			ObjectSetString(0,  "fib50t", OBJPROP_TEXT, "50.0");
			ObjectSetInteger(0, "fib50t", OBJPROP_FONTSIZE, 8);
			ObjectSetString(0,  "fib50t", OBJPROP_FONT, "Arial");
			ObjectSetInteger(0, "fib50t", OBJPROP_COLOR, Green);

		 	ObjectCreate(0, "fib62", OBJ_TREND, 0, Time[cvstart], fib62, Time[1], fib62);
			ObjectSetInteger(0, "fib62", OBJPROP_STYLE, STYLE_DASH);
			ObjectSetInteger(0, "fib62", OBJPROP_COLOR, Green);
			ObjectSetInteger(0, "fib62", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "fib62", OBJPROP_WIDTH, 1);
			ObjectCreate(0, "fib62t", OBJ_TEXT, 0, Time[1], fib62);
			ObjectSetString(0,  "fib62t", OBJPROP_TEXT, "61.8");
  			ObjectSetInteger(0, "fib62t", OBJPROP_FONTSIZE, 8);
  			ObjectSetString(0,  "fib62t", OBJPROP_FONT, "Arial");
  			ObjectSetInteger(0, "fib62t", OBJPROP_COLOR, Green);
				 
		 	ObjectCreate(0, "fib76", OBJ_TREND, 0, Time[cvstart], fib76, Time[1], fib76);
			ObjectSetInteger(0, "fib76", OBJPROP_STYLE, STYLE_DASH);
			ObjectSetInteger(0, "fib76", OBJPROP_COLOR, Green);
			ObjectSetInteger(0, "fib76", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "fib76", OBJPROP_WIDTH, 1);
			ObjectCreate(0, "fib76t", OBJ_TEXT, 0, Time[1], fib76);
			ObjectSetString(0,  "fib76t", OBJPROP_TEXT, "76.4");
  			ObjectSetInteger(0, "fib76t", OBJPROP_FONTSIZE, 8);
  			ObjectSetString(0,  "fib76t", OBJPROP_FONT, "Arial");
  			ObjectSetInteger(0, "fib76t", OBJPROP_COLOR, Green);

		 	ObjectCreate(0, "dinap0", OBJ_TREND, 0, Time[cvstart], dinap0, Time[1], dinap0);
			ObjectSetInteger(0, "dinap0", OBJPROP_STYLE, STYLE_DOT);
			ObjectSetInteger(0, "dinap0", OBJPROP_COLOR, Red);
			ObjectSetInteger(0, "dinap0", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "dinap0", OBJPROP_WIDTH, 1);
	 
 		 	ObjectCreate(0, "dinap1", OBJ_TREND, 0, Time[cvstart], dinap1, Time[1], dinap1);
			ObjectSetInteger(0, "dinap1", OBJPROP_STYLE, STYLE_DOT);
			ObjectSetInteger(0, "dinap1", OBJPROP_COLOR, Red);
			ObjectSetInteger(0, "dinap1", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "dinap1", OBJPROP_WIDTH, 1);
	 
		 	ObjectCreate(0, "dinap2", OBJ_TREND, 0, Time[cvstart], dinap2, Time[1], dinap2);
			ObjectSetInteger(0, "dinap2", OBJPROP_STYLE, STYLE_DOT);
			ObjectSetInteger(0, "dinap2", OBJPROP_COLOR, Red);
			ObjectSetInteger(0, "dinap2", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "dinap2", OBJPROP_WIDTH, 1);
	 
		 	ObjectCreate(0, "dinap3", OBJ_TREND, 0, Time[cvstart], dinap3, Time[1], dinap3);
			ObjectSetInteger(0, "dinap3", OBJPROP_STYLE, STYLE_DOT);
			ObjectSetInteger(0, "dinap3", OBJPROP_COLOR, Red);
			ObjectSetInteger(0, "dinap3", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "dinap3", OBJPROP_WIDTH, 1);
 
		 	ObjectCreate(0, "dinap4", OBJ_TREND, 0, Time[cvstart], dinap4, Time[1], dinap4);
			ObjectSetInteger(0, "dinap4", OBJPROP_STYLE, STYLE_DOT);
			ObjectSetInteger(0, "dinap4", OBJPROP_COLOR, Red);
			ObjectSetInteger(0, "dinap4", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "dinap4", OBJPROP_WIDTH, 1);
	 
		 	ObjectCreate(0, "dinap5", OBJ_TREND, 0, Time[cvstart], dinap5, Time[1], dinap5);
			ObjectSetInteger(0, "dinap5", OBJPROP_STYLE, STYLE_DOT);
			ObjectSetInteger(0, "dinap5", OBJPROP_COLOR, Red);
			ObjectSetInteger(0, "dinap5", OBJPROP_RAY_LEFT, 0);
			ObjectSetInteger(0, "dinap5", OBJPROP_WIDTH, 1);
		}

		//Vertical float lines. Tthese draw the lines that calculate the float.
		//If you change "trendline" to "Vline" it will draw through oscillators too. Might be fun.
		ObjectDelete(0, "CVSTART");
	 	ObjectCreate(0, "CVSTART", OBJ_TREND, 0, Time[cvstart], high_bar, Time[cvstart], low_bar * _Point);
		ObjectSetInteger(0, "CVSTART", OBJPROP_STYLE, STYLE_SOLID);
		ObjectSetInteger(0, "CVSTART", OBJPROP_COLOR, Blue);
		ObjectSetInteger(0, "CVSTART", OBJPROP_RAY_LEFT, 0);
		ObjectSetInteger(0, "CVSTART", OBJPROP_WIDTH, 1);

		ObjectDelete(0, "CVEND");
		ObjectCreate(0, "CVEND", OBJ_TREND, 0, Time[cvend], high_bar, Time[cvend], low_bar * _Point);
		ObjectSetInteger(0, "CVEND", OBJPROP_STYLE, STYLE_SOLID);
		ObjectSetInteger(0, "CVEND", OBJPROP_COLOR, Blue);
		ObjectSetInteger(0, "CVEND", OBJPROP_RAY_LEFT, 0);
		ObjectSetInteger(0, "CVEND", OBJPROP_WIDTH, 1);

		//Vertical float predictions. These are only time based.
		//See blue histogram for real float values.
		//If you change "trendline" to "Vline" it will draw through oscillators too. Might be fun.
		if (cvend - swing_time > 0)
		{
			ObjectDelete(0, "swingend");
			ObjectCreate(0, "swingend", OBJ_TREND, 0, Time[(cvend - swing_time) + 5], high_bar, Time[cvend - swing_time + 5], low_bar);
		 	ObjectSetInteger(0, "swingend", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend");

		if (cvend - (swing_time * 2) > 0)
		{
			ObjectDelete(0, "swingend2");
			ObjectCreate(0, "swingend2", OBJ_TREND, 0, Time[(cvend - (swing_time * 2)) + 5], high_bar, Time[cvend - (swing_time * 2) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend2", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend2", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend2", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend2", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend2");
			
		if (cvend - (swing_time * 3) > 0)
		{
		 	ObjectDelete(0, "swingend3");
		 	ObjectCreate(0, "swingend3", OBJ_TREND, 0, Time[(cvend - (swing_time * 3)) + 5], high_bar, Time[cvend - (swing_time * 3) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend3", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend3", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend3", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend3", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend3");
			
		if (cvend - (swing_time * 4) > 0)
		{
		 	ObjectDelete(0, "swingend4");
		 	ObjectCreate(0, "swingend4", OBJ_TREND, 0, Time[(cvend - (swing_time * 4)) + 5], high_bar, Time[cvend - (swing_time * 4) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend4", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend4", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend4", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend4", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend4");
		
		if (cvend - (swing_time * 5) > 0)
		{
		 	ObjectDelete(0, "swingend5");
		 	ObjectCreate(0, "swingend5", OBJ_TREND, 0, Time[(cvend - (swing_time * 5)) + 5], high_bar, Time[cvend - (swing_time * 5) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend5", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend5", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend5", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend5", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend5");
				
		if (cvend - (swing_time * 6) > 0)
		{
		 	ObjectDelete(0, "swingend6");
		 	ObjectCreate(0, "swingend6", OBJ_TREND, 0, Time[cvend - (swing_time * 6) + 5], high_bar, Time[cvend - (swing_time * 6) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend6", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend6", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend6", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend6", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend6");
			
		if (cvend - (swing_time * 7) > 0)
		{
		 	ObjectDelete(0, "swingend7");
		 	ObjectCreate(0, "swingend7", OBJ_TREND, 0, Time[cvend - (swing_time * 7) + 5], high_bar, Time[cvend - (swing_time * 7) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend7", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend7", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend7", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend7", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend7");
			
		if (cvend - (swing_time * 8) > 0)
		{
		 	ObjectDelete(0, "swingend8");
		 	ObjectCreate(0, "swingend8", OBJ_TREND, 0, Time[cvend - (swing_time * 8) + 5], high_bar, Time[cvend - (swing_time * 8) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend8", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend8", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend8", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend8", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend8");
			
		if (cvend - (swing_time * 9) > 0)
		{
		 	ObjectDelete(0, "swingend9");
		 	ObjectCreate(0, "swingend9", OBJ_TREND, 0, Time[cvend - (swing_time * 9) + 5], high_bar, Time[cvend - (swing_time * 9) + 5], low_bar);
		 	ObjectSetInteger(0, "swingend9", OBJPROP_STYLE, STYLE_DOT);
		 	ObjectSetInteger(0, "swingend9", OBJPROP_COLOR, Red);
		 	ObjectSetInteger(0, "swingend9", OBJPROP_RAY_LEFT, 0);
		 	ObjectSetInteger(0, "swingend9", OBJPROP_WIDTH, 1);
		}
		else ObjectDelete(0, "swingend9");
 	}
 	return(rates_total);
}
  

