//+------------------------------------------------------------------+
//|                                            Easy Trend Visualizer |
//|                                 Copyright  2009-2011, EarnForex |
//|                                        http://www.earnforex.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009-2011, EarnForex"
#property link      "http://www.earnforex.com"
#property version   "1.06"

#property description "Easy Trend Visualizer - displays trend strength, direction and"
#property description "support and resistance levels."
#property description "Alerts (set UseAlert = true):"
#property description " * ERV-HL - Horizontal line"
#property description " * ERV-AU - Arrow up"
#property description " * ERV-AD - Arrow down"

#define Alvl 35.0
#define Alvl2 30.0

#property indicator_chart_window
#property indicator_buffers 9
#property indicator_plots   4
#property indicator_color1 Red, SteelBlue
#property indicator_width1 2
#property indicator_color2 Lime
#property indicator_color3 Lime
#property indicator_color4 Indigo
#property indicator_width2 2
#property indicator_width3 2
#property indicator_width4 1
#property indicator_type1   DRAW_COLOR_HISTOGRAM2
#property indicator_style1  STYLE_SOLID
#property indicator_type2   DRAW_ARROW
#property indicator_style2  STYLE_SOLID
#property indicator_type3   DRAW_ARROW
#property indicator_style3  STYLE_SOLID
#property indicator_type4   DRAW_LINE
#property indicator_style4  STYLE_SOLID

//---- indicator parameters
input int ADXperiod1 = 10;
input int ADXperiod2 = 14;
input int ADXperiod3 = 20;
input bool UseAlertHorizontalLine = false;
input bool UseAlertUpDownArrows = false;

//--
int MxP, MnP, MdP;

//---- buffers
double To[];
double Tc[];
double Color[];
double Up[];
double Dn[];
double Ex[];

double ADX1[];
double ADX2[];
double ADX3[];

double was_alert_hl = EMPTY_VALUE; // Horizontal line
double was_alert_au = EMPTY_VALUE; // Arrow up
double was_alert_ad = EMPTY_VALUE; // Arrow down

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
{
	MxP = MathMax(MathMax(ADXperiod1, ADXperiod2), ADXperiod3);
	MnP = MathMin(MathMin(ADXperiod1, ADXperiod2), ADXperiod3);
	if (MxP == ADXperiod1) MdP = MathMax(ADXperiod2, ADXperiod3);
	else if (MxP == ADXperiod2) MdP = MathMax(ADXperiod1, ADXperiod3);	
	else MdP = MathMax(ADXperiod2, ADXperiod1);
	
	IndicatorSetString(INDICATOR_SHORTNAME, "ETV(" + IntegerToString(MnP) + "/" + IntegerToString(MdP) + "/" + IntegerToString(MxP) + ")");
	
	SetIndexBuffer(0, To, INDICATOR_DATA);
	SetIndexBuffer(1, Tc, INDICATOR_DATA);
	SetIndexBuffer(2, Color, INDICATOR_COLOR_INDEX);
	SetIndexBuffer(3, Up, INDICATOR_DATA);
	SetIndexBuffer(4, Dn, INDICATOR_DATA);
	SetIndexBuffer(5, Ex, INDICATOR_DATA);
	SetIndexBuffer(6, ADX1, INDICATOR_CALCULATIONS);
	SetIndexBuffer(7, ADX2, INDICATOR_CALCULATIONS);
	SetIndexBuffer(8, ADX3, INDICATOR_CALCULATIONS);
	
	ArraySetAsSeries(To, true);
	ArraySetAsSeries(Tc, true);
	ArraySetAsSeries(Color, true);
	ArraySetAsSeries(Up, true);
	ArraySetAsSeries(Dn, true);
	ArraySetAsSeries(Ex, true);
   ArraySetAsSeries(ADX1, true);
   ArraySetAsSeries(ADX2, true);
   ArraySetAsSeries(ADX3, true);

   PlotIndexSetInteger(1, PLOT_ARROW, 225);
   PlotIndexSetInteger(2, PLOT_ARROW, 226);
   
   PlotIndexSetString(1, PLOT_LABEL, "Up");
   PlotIndexSetString(2, PLOT_LABEL, "Down");
   PlotIndexSetString(3, PLOT_LABEL, "End");
}

//+------------------------------------------------------------------+
//| Custom Easy Trend Visualizer                                     |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &Open[],
                const double &high[],
                const double &low[],
                const double &Close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   ArraySetAsSeries(Open, true);
   ArraySetAsSeries(Close, true);

   int limit = rates_total;	

	double ADXBuffer1[], ADXBuffer2[], ADXBuffer3[], ADXBuffer1_1[], ADXBuffer1_2[];
   int myADX = iADX(NULL, 0, MnP);
   if (CopyBuffer(myADX, MAIN_LINE, 0, rates_total, ADXBuffer1) != rates_total) return(0);
   if (CopyBuffer(myADX, PLUSDI_LINE, 0, rates_total, ADXBuffer1_1) != rates_total) return(0);
   if (CopyBuffer(myADX, MINUSDI_LINE, 0, rates_total, ADXBuffer1_2) != rates_total) return(0);
   myADX = iADX(NULL, 0, MdP);
   if (CopyBuffer(myADX, MAIN_LINE, 0, rates_total, ADXBuffer2) != rates_total) return(0);
   myADX = iADX(NULL, 0, MxP);
   if (CopyBuffer(myADX, MAIN_LINE, 0, rates_total, ADXBuffer3) != rates_total) return(0);

   for (int i = limit - 1; i >= 0; i--)
	{
		ADX1[i] = ADXBuffer1[rates_total - i - 1];
		ADX2[i] = ADXBuffer2[rates_total - i - 1];
		ADX3[i] = ADXBuffer3[rates_total - i - 1];
	}

	for (int i = limit - 1; i >= 0; i--)
	{
		bool f1 = false, f2 = false, f3 = false;

		To[i] = 0; Tc[i] = 0;
		Up[i] = 0; Dn[i] = 0; Ex[i] = EMPTY_VALUE;
		
		int j = i + 1;
		if (j > (limit - 1)) j = limit - 1;
		
		if (ADX1[j] < ADX1[i]) f1 = true;
		if (ADX2[j] < ADX2[i]) f2 = true;
		if (ADX3[j] < ADX3[i]) f3 = true;
		
		if ((f1) && (f2) && (f3)&& (ADX1[i] > Alvl) && (ADX2[i] > Alvl2))
		{
			double di = ADXBuffer1_1[rates_total - i - 1] - ADXBuffer1_2[rates_total - i - 1];
			double hi = MathMax(Open[i], Close[i]);
			double lo = MathMin(Open[i], Close[i]);
			double op = Open[i];
			if (di > 0)
			{
				To[i] = lo; Tc[i] = hi;
				if (To[j] == 0) Up[i] = op;
				Color[i] = 1;
				
			}
			else
			{
				To[i] = hi; Tc[i] = lo;
				if (To[j] == 0) Dn[i] = op;
				Color[i] = 0;
			}
		}
		else
		{
			if (To[j] != 0)
			{
			   Ex[i] = Close[i + 1];
			}
		   else Ex[i] = Ex[j];
		}
	}

   if (UseAlertHorizontalLine)
   {
      if ((Ex[1] != EMPTY_VALUE) && (Ex[1] != was_alert_hl) && (Ex[1] != Ex[2]))
      {
         Alert("ETV-HL");
         was_alert_hl = Ex[1];
      }
   }
   if (UseAlertUpDownArrows)
   {
      if ((Up[0] != 0) && (Up[0] != was_alert_au))
      {
         Alert("ETV-AU");
         was_alert_au = Up[0];
      }
      if ((Dn[0] != 0) && (Dn[0] != was_alert_ad))
      {
         Alert("ETV-AD");
         was_alert_ad = Dn[0];
      }
   }
			      
	return(rates_total);
}
//+------------------------------------------------------------------+