//+------------------------------------------------------------------+
//|                                                3rd Generation MA |
//|                                      Copyright  2011, EarnForex |
//|                                        http://www.earnforex.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, EarnForex"
#property link      "http://www.earnforex.com"
#property version   "1.01"

#property description "3rd Generation MA based on research paper by Dr. Manfred"
#property description "Durschner: http://www.vtad.de/node/1441 (in German)."
#property description "Offers least possible lag but still provides price smoothing."

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots 1
#property indicator_color1 clrRed
#property indicator_style1 STYLE_SOLID
#property indicator_type1 DRAW_LINE
#property indicator_width1  1

//---- indicator parameters
input int MA_Period = 50;
input ENUM_MA_METHOD MA_Method = MODE_EMA;
input ENUM_APPLIED_PRICE MA_Applied_Price = PRICE_TYPICAL;

//---- indicator buffers
double MA3G[];
double MA[];

//----
double MA2[];
double Lambda, Alpha;
int handle, MA_Sampling_Period = 2 * MA_Period;
bool FirstRun = true;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
{
   string short_name;

   SetIndexBuffer(0, MA3G, INDICATOR_DATA);
   SetIndexBuffer(1, MA, INDICATOR_CALCULATIONS);
   
   ArraySetAsSeries(MA3G, true);
   ArraySetAsSeries(MA, true);
   ArraySetAsSeries(MA2, true);
   
   //---- indicator short name
   switch(MA_Method)
   {
      case MODE_EMA:
         short_name = "3GEMA(";  
         break;
      case MODE_SMMA:
         short_name = "3GSMMA(";
         break;
      case MODE_LWMA:
         short_name = "3GLWMA(";
         break;
      default:
         short_name = "3GSMA(";
   }

   IndicatorSetString(INDICATOR_SHORTNAME, short_name + IntegerToString(MA_Period) + ")");
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits);

   handle = iMA(NULL, 0, MA_Sampling_Period, 0, MA_Method, MA_Applied_Price);
   if (handle == INVALID_HANDLE)
   {
      Print("Failed to initialize Moving Average.");
      return;
   }

   Lambda = 1.0 * MA_Sampling_Period / (1.0 * MA_Period);
   Alpha = Lambda * (MA_Sampling_Period - 1) / (MA_Sampling_Period - Lambda);

   Print("Lambda = ", Lambda, "; Alpha = ", Alpha);
}

//+------------------------------------------------------------------+
//| 3rd Generation Moving Average Custom Indicator                   |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tickvolume[],
                const long &volume[],
                const int &spread[])
{
   int i;
   int TotalPeriod = MA_Sampling_Period + MA_Period;
   
   if (rates_total <= TotalPeriod) return(0); // Not enough bars
   
   int ExtCountedBars;
   
   if (FirstRun) ExtCountedBars = 0;
   else
   {
      ExtCountedBars = prev_calculated;
      if (ExtCountedBars < 0) return(-1);
      if ((rates_total - ExtCountedBars < TotalPeriod) || (ExtCountedBars == 0)) ExtCountedBars = rates_total - TotalPeriod;
   }

   // +2 to use in iMAOnArrayMQL4()
   // + MA_Period because we need that amount more to calculate the components of the resulting indicator
   int MABars = rates_total - ExtCountedBars + MA_Period + 2;
   if (MABars > rates_total) MABars = rates_total;
   if (CopyBuffer(handle, 0, 0, MABars, MA) != MABars) return(0);
   
   int MAonMABars = rates_total - ExtCountedBars + MA_Period;
   if (MAonMABars > rates_total) MAonMABars = rates_total;
   iMAOnArrayMQL4(MA, MAonMABars, MA_Period, 0, MA_Method, 0, MA2);
   
   for (i = rates_total - ExtCountedBars - 1; i >= 0; i--)
      MA3G[i] = (Alpha + 1) * MA[i] - Alpha * MA2[i];

   FirstRun = false;
   return(rates_total);
}


//+------------------------------------------------------------------+
//| http://www.mql5.com/en/articles/81                               |
//+------------------------------------------------------------------+
double iMAOnArrayMQL4(double &array[],
                      int total,
                      int period,
                      int ma_shift,
                      int ma_method,
                      int shift,
                      double &buf[])
  {
   double arr[];
   if(total==0) total=ArraySize(array);
   if(total>0 && total<=period) return(0);
   if(shift>total-period-ma_shift) return(0);
   switch(ma_method)
     {
      case MODE_SMA :
        {
         total=ArrayCopy(arr,array,0,shift+ma_shift,period);
         if(ArrayResize(buf,total)<0) return(0);
         double sum=0;
         int    i,pos=total-1;
         for(i=1;i<period;i++,pos--)
            sum+=arr[pos];
         while(pos>=0)
           {
            sum+=arr[pos];
            buf[pos]=sum/period;
            sum-=arr[pos+period-1];
            pos--;
           }
         return(buf[0]);
        }
      case MODE_EMA :
        {
         if(ArrayResize(buf,total)<0) return(0);
         double pr=2.0/(period+1);
         int    pos=total-2;
         while(pos>=0)
           {
            if(pos==total-2) buf[pos+1]=array[pos+1];
            buf[pos]=array[pos]*pr+buf[pos+1]*(1-pr);
            pos--;
           }
         return(buf[shift+ma_shift]);
        }
      case MODE_SMMA :
        {
         if(ArrayResize(buf,total)<0) return(0);
         double sum=0;
         int    i,k,pos;
         pos=total-period;
         while(pos>=0)
           {
            if(pos==total-period)
              {
               for(i=0,k=pos;i<period;i++,k++)
                 {
                  sum+=array[k];
                  buf[k]=0;
                 }
              }
            else sum=buf[pos+1]*(period-1)+array[pos];
            buf[pos]=sum/period;
            pos--;
           }
         return(buf[shift+ma_shift]);
        }
      case MODE_LWMA :
        {
         if(ArrayResize(buf,total)<0) return(0);
         double sum=0.0,lsum=0.0;
         double price;
         int    i,weight=0,pos=total-1;
         for(i=1;i<=period;i++,pos--)
           {
            price=array[pos];
            sum+=price*i;
            lsum+=price;
            weight+=i;
           }
         pos++;
         i=pos+period;
         while(pos>=0)
           {
            buf[pos]=sum/weight;
            if(pos==0) break;
            pos--;
            i--;
            price=array[pos];
            sum=sum-lsum+price*period;
            lsum-=array[i];
            lsum+=price;
           }
         return(buf[shift+ma_shift]);
        }
      default: return(0);
     }
   return(0);
  }
//+------------------------------------------------------------------+

