//+------------------------------------------------------------------+
//|                                             Floor_Pivots_MTF.mq4 |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|                            Modified by Kris, kris.pivo@gmail.com |                                      
//+------------------------------------------------------------------+
#property indicator_chart_window
//#property indicator_buffers   4
//#property indicator_color1    C'Yellow' // Pivot
//#property indicator_color2    C'Gainsboro' // Pivot Range
//#property indicator_color3    C'Blue' // Resistance
//#property indicator_color4    C'Red' // Support
//#property indicator_color5    C'DimGray' // Mid-Resistance
//#property indicator_color6    C'DimGray' // Mid-Support

extern int     CountPeriods   = 10;
extern string  Time_Period     = "D1";  //H1, H4, D1, W1, MN
extern bool    Plot_Pivots    = true;
extern bool    Plot_Middle    = false;
extern bool    Plot_Range     = false;
//      
extern color Pivot_color=Yellow;       extern int Pivot_style=0;       extern int Pivot_width=1; 
extern color R_color=Red;              extern int R_style=0;           extern int R_width=1; 
extern color S_color=Blue;             extern int S_style=0;           extern int S_width=1;
extern color Plot_Middle_color=DimGray;extern int Plot_Middle_style=2; extern int Plot_Middle_width=1;
extern color Plot_Range_color=Gainsboro; extern int Plot_Range_style=0;  extern int Plot_Range_width=1;

   datetime time1;
   datetime time2;
   double open,close,high,low;
   double PP,R1,R2,R3,R4,S1,S2,S3,S4,M0,M1,M2,M3,M4,M5,M6,M7;
   double PD, PRH, PRL;
//  double pstyle, rstyle, mstyle; //
   int shift, num, period;
   string period_key; //         
   void ObjDel()
   {
      for (;num<=CountPeriods;num++)
      {
      ObjectDelete("PP["+num+"]"+period_key);
      ObjectDelete("R1["+num+"]"+period_key);
      ObjectDelete("R2["+num+"]"+period_key);
      ObjectDelete("R3["+num+"]"+period_key);
      ObjectDelete("R4["+num+"]"+period_key);
      ObjectDelete("S1["+num+"]"+period_key);
      ObjectDelete("S2["+num+"]"+period_key);
      ObjectDelete("S3["+num+"]"+period_key);
      ObjectDelete("S4["+num+"]"+period_key);
      
      ObjectDelete("M0["+num+"]"+period_key);
      ObjectDelete("M1["+num+"]"+period_key);
      ObjectDelete("M2["+num+"]"+period_key);
      ObjectDelete("M3["+num+"]"+period_key);
      ObjectDelete("M4["+num+"]"+period_key);
      ObjectDelete("M5["+num+"]"+period_key);
      ObjectDelete("M6["+num+"]"+period_key);
      ObjectDelete("M7["+num+"]"+period_key);
      
      ObjectDelete("PRH["+num+"]"+period_key);
      ObjectDelete("PRL["+num+"]"+period_key);
      }
   }

   void PlotLine(string name,double value,double line_color,double style,double width) // ,double width
   {
   ObjectCreate(name,OBJ_TREND,0,time1,value,time2,value);
   ObjectSet(name, OBJPROP_WIDTH, width); // width  1
   ObjectSet(name, OBJPROP_STYLE, style);
   ObjectSet(name, OBJPROP_RAY, false);
   ObjectSet(name, OBJPROP_BACK, true);
   ObjectSet(name, OBJPROP_COLOR, line_color);
    }        
int init()
  {
   if (Time_Period=="H1" || Time_Period=="60") {period=PERIOD_H1; period_key="H1";}
   else
   if (Time_Period=="H4" || Time_Period=="240") {period=PERIOD_H4; period_key="H4";}
   else
   if (Time_Period=="D1" || Time_Period=="1440") {period=PERIOD_D1; period_key="D1";}
   else
   if (Time_Period=="W1" || Time_Period=="10080") {period=PERIOD_W1; period_key="W1";}
   else
   if (Time_Period=="MN" || Time_Period=="43200") {period=PERIOD_MN1; period_key="MN";}
   else
   {
   Comment("Wrong TimePeriod. Must be H1, H4, D1, W1 or MN"); 
   return(0);
   }
  return(0);
  }
   
   
int deinit()
  {
   ObjDel();
   Comment("");
   return(0);
  }

int start()
  {
  int i;
     
  ObjDel();
  num=0;
  
  for (shift=CountPeriods-1;shift>=0;shift--)
  {
  time1=iTime(NULL,period,shift);
             
  high  = iHigh(NULL,period,shift+1);
  low   = iLow(NULL,period,shift+1);
  open  = iOpen(NULL,period,shift+1);
  close = iClose(NULL,period,shift+1);
  
  PP  = (high+low+close)/3;

  R1 = 2*PP-low;
  R2 = PP+(high - low);
  R3 = (2*PP)+(high-(2*low));
  R4 = PP+(2*high-2*low);  
        
  S1 = 2*PP-high;
  S2 = PP-(high - low);
  S3 = (2*PP)-((2*high)-low);
  S4 = PP-(2*high-2*low);
  
  M0 = 0.5*(S3+S4);       
  M1 = 0.5*(S2+S3);
  M2 = 0.5*(S1+S2);
  M3 = 0.5*(PP+S1);
  M4 = 0.5*(PP+R1);
  M5 = 0.5*(R1+R2);
  M6 = 0.5*(R2+R3);
  M7 = 0.5*(R3+R4);
  
  PD = MathAbs(((high + low)/2) - PP);      
  PRH = PP + PD;
  PRL = PP - PD;

  time2=time1+period*60;
         
//  pstyle=0; //
//  mstyle=3; //
//  rstyle=1; //
  num=shift;
       
  PlotLine("PP["+num+"]"+period_key,PP,Pivot_color,Pivot_style,Pivot_width); //indicator_color1,pstyle
  if(Plot_Pivots)
  {
   PlotLine("R1["+num+"]"+period_key,R1,R_color,R_style,R_width); //indicator_color3,pstyle
   PlotLine("R2["+num+"]"+period_key,R2,R_color,R_style,R_width); //indicator_color3,pstyle
   PlotLine("R3["+num+"]"+period_key,R3,R_color,R_style,R_width); //indicator_color3,pstyle
   PlotLine("R4["+num+"]"+period_key,R4,R_color,R_style,R_width); //indicator_color3,pstyle
               
   PlotLine("S1["+num+"]"+period_key,S1,S_color,S_style,S_width); //indicator_color4,pstyle
   PlotLine("S2["+num+"]"+period_key,S2,S_color,S_style,S_width); //indicator_color4,pstyle
   PlotLine("S3["+num+"]"+period_key,S3,S_color,S_style,S_width); //indicator_color4,pstyle
   PlotLine("S4["+num+"]"+period_key,S4,S_color,S_style,S_width); //indicator_color4,pstyle
  }
  
  if(Plot_Middle)
  {
   PlotLine("M0["+num+"]"+period_key,M0,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color6,mstyle
   PlotLine("M1["+num+"]"+period_key,M1,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color6,mstyle
   PlotLine("M2["+num+"]"+period_key,M2,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color6,mstyle
   PlotLine("M3["+num+"]"+period_key,M3,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color6,mstyle
   PlotLine("M4["+num+"]"+period_key,M4,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color5,mstyle
   PlotLine("M5["+num+"]"+period_key,M5,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color5,mstyle
   PlotLine("M6["+num+"]"+period_key,M6,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color5,mstyle
   PlotLine("M7["+num+"]"+period_key,M7,Plot_Middle_color,Plot_Middle_style,Plot_Middle_width); //indicator_color5,mstyle
  }  
  
  if(Plot_Range)
  {
   PlotLine("PRH["+num+"]"+period_key,PRH,Plot_Range_color,Plot_Range_style,Plot_Range_width); //indicator_color2,rstyle
   PlotLine("PRL["+num+"]"+period_key,PRL,Plot_Range_color,Plot_Range_style,Plot_Range_width); //indicator_color2,rstyle
  }
  }
   return(0);
  }
//+---------------------------------------------------------------------------------------+
//|                                        THE END                                        |
//+---------------------------------------------------------------------------------------+