//+------------------------------------------------------------------+
//|                                                       CTimer.mqh |
//|                                        Copyright Dmitry Voronkov |
//|                                                 vdv_2001@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Dmitry Voronkov"
#property link      "vdv_2001@mail.ru"

#include <Object.mqh>
#include <ChartObjects\ChartObjectsTxtControls.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CTimer :public CObject
  {
private:
   ENUM_TIMEFRAMES   _TimePeriod;
   //     | For an output of value of the timer
   CChartObjectLabel *TimerText;
   //     | For an output of a substrate of the timer
   CChartObjectLabel *TimerSubstrate;
   color             _Color,_Substrate;
   ENUM_BASE_CORNER  _Corner;
   bool              InitTimer;
public:
                     CTimer();
                    ~CTimer();
   //---    / method of creation of object
   bool              Create(long chart_id,string name,int window,int X,int Y);
   //---     / method of change of colour of the text
   bool              Color(color col);
   color             Color(){return(_Color);}
   //---     / method of change of colour of a background
   bool              ColorBackground(color col);
   color             ColorBackground(){return(_Substrate);}
   //---     / method of change of a corner of a binding
   bool              Corner(ENUM_BASE_CORNER corner);
   ENUM_BASE_CORNER  Corner();
   
   //---    OnTimer() / method of processing of event OnTimer()
   void              OnTimer();
   //---     / method of change of the period of the timer
   void              TimePeriod(ENUM_TIMEFRAMES period){_TimePeriod=period; OnTimer();}
   ENUM_TIMEFRAMES   TimePeriod(){return(_TimePeriod);}
private:
   datetime          TimeEndOfPeriod();
  };
//+------------------------------------------------------------------+
//|  / onstructor                                        |
//+------------------------------------------------------------------+
CTimer::CTimer()
  {
   TimerSubstrate=NULL;
   TimerText=NULL;
   _TimePeriod=_Period;
   _Color=White;
   _Substrate=Green;
   _Corner=CORNER_RIGHT_LOWER;
   InitTimer=false;
  }
//+------------------------------------------------------------------+
//|  / Destructor                                          |
//+------------------------------------------------------------------+
CTimer::~CTimer()
  {
   InitTimer=false;
   if(TimerSubstrate!=NULL) delete TimerSubstrate;
   if(TimerText!=NULL) delete TimerText;
  }
//+------------------------------------------------------------------+
//|    / Method of creation of object            |
//+------------------------------------------------------------------+
bool CTimer::Create(long chart_id,string name,int window,int X,int Y)
  {
   bool result;
   if(_TimePeriod>PERIOD_D1) return(false);
   TimerSubstrate=new CChartObjectLabel();
   result=TimerSubstrate.Create(0,name+"Substrate",0,X,Y);
   result&=TimerSubstrate.Anchor(ANCHOR_CENTER);
   result&=TimerSubstrate.Font("Webdings");
   result&=TimerSubstrate.FontSize(13);
   result&=TimerSubstrate.Color(_Substrate);
   result&=TimerSubstrate.Corner(_Corner);
   result&=TimerSubstrate.Description("gggg");
   TimerText=new CChartObjectLabel();
   result&=TimerText.Create(0,name,0,X,Y);
   result&=TimerText.Anchor(ANCHOR_CENTER);
   result&=TimerText.Font("Arial Black");
   result&=TimerText.FontSize(10);
   result&=TimerText.Color(_Color);
   result&=TimerText.Corner(_Corner);
   result&=TimerText.Description(TimeToString(TimeEndOfPeriod(),TIME_SECONDS));
   if(result) InitTimer=true;
   return(result);
  }
//+-----------------------------------------------------------------------------+
//|    OnTimer() / Method of processing of event OnTimer() |
//+-----------------------------------------------------------------------------+
void CTimer::OnTimer()
  {
   static bool BlinkFlag=true;
   if(InitTimer)
     {
      if(_TimePeriod>PERIOD_D1) return;
      datetime tmpTime=TimeEndOfPeriod();
      TimerText.Description(TimeToString(tmpTime,TIME_SECONDS));
      if(tmpTime<=20)
        {
         if(BlinkFlag)
           {
            TimerSubstrate.Color(Red);
            BlinkFlag=false;
           }
         else
           {
            TimerSubstrate.Color(_Substrate);
            BlinkFlag=true;
           }
        }
      else
         TimerSubstrate.Color(_Substrate);
      ChartRedraw();
     }
  }
//+-------------------------------------------------------------------+
//|                        |
//| Time reception remained before period closing                     |
//+-------------------------------------------------------------------+
datetime CTimer::TimeEndOfPeriod()
  {
   datetime tmpDateTime;
   int tmp;
   MqlDateTime last_time;
   TimeToStruct(TimeTradeServer(),last_time);
   last_time.sec=0;
   if(Period()<=PERIOD_H1)
     {
      tmp=(PeriodSeconds(_TimePeriod)/PeriodSeconds(PERIOD_M1));
      tmp=last_time.min/tmp;
      last_time.min=(tmp+1)*PeriodSeconds(_TimePeriod)/PeriodSeconds(PERIOD_M1);
     }
   else
   if(Period()>PERIOD_H1 && Period()<=PERIOD_D1)
     {
      tmp=(PeriodSeconds(_TimePeriod)/PeriodSeconds(PERIOD_H1));
      tmp=last_time.hour/tmp;
      last_time.hour=(tmp+1)*PeriodSeconds(_TimePeriod)/PeriodSeconds(PERIOD_H1);
      last_time.min=0;
     }
   tmpDateTime=StructToTime(last_time);
   tmpDateTime=tmpDateTime-TimeTradeServer();
   return(tmpDateTime);
  }
//+------------------------------------------------------------------------+
//|     / Method of change of colour of the text  |
//+------------------------------------------------------------------------+
bool CTimer::Color(color col)
  {
   _Color=col;
   if(TimerText!=NULL)
      return(TimerText.Color(col));
   else
      return(false);
  }
//+-------------------------------------------------------------------------+
//|     / Method of change of colour of a background |
//+-------------------------------------------------------------------------+
bool CTimer::ColorBackground(color col)
  {
   _Substrate=col;
   if(TimerSubstrate!=NULL)
      return(TimerSubstrate.Color(col));
   else
      return(false);
  }
//+---------------------------------------------------------------------------+
//|     / Method of change of a corner of a binding |
//+---------------------------------------------------------------------------+
bool CTimer::Corner(ENUM_BASE_CORNER corner)
{
   bool result;
   _Corner=corner;
   result=TimerText.Corner(_Corner);
   result&=TimerSubstrate.Corner(_Corner);
   OnTimer();
   return(result);
}
//+------------------------------------------------------------------+
