//+------------------------------------------------------------------+
//|                                                      CrossMa.mq5 |
//+------------------------------------------------------------------+
#property copyright "TheXpert"
#property link      "theforexpert@gmail.com"
#property version   "1.00"
#property indicator_chart_window

#property indicator_buffers 2
#property indicator_plots   1

#property indicator_type1   DRAW_FILLING
#property indicator_color1  Red, Blue

input int MaFast = 5;
input int MaSlow = 20;

double Fast[];
double Slow[];

int FastHandle;
int SlowHandle;

void OnInit()
{
   SetIndexBuffer(0, Fast, INDICATOR_DATA);
   SetIndexBuffer(1, Slow, INDICATOR_DATA);

   FastHandle = iMA(NULL, 0, MaFast, 0, MODE_EMA, PRICE_CLOSE);
   SlowHandle = iMA(NULL, 0, MaSlow, 0, MODE_EMA, PRICE_CLOSE);
}

int OnCalculate(
      const int         bars,
      const int         counted,
      const datetime&   time[],
      const double&     open[],
      const double&     high[],
      const double&     low[],
      const double&     close[],
      const long&       tick_volume[],
      const long&       volume[],
      const int&        spread[])
{
   CopyBuffer(FastHandle, 0, 0, bars, Fast);
   CopyBuffer(SlowHandle, 0, 0, bars, Slow);
   
   return(bars);
}