//+------------------------------------------------------------------+
//|                                                    FiboBands.mq5 | 
//|                                             Copyright  2013,    | 
//|                                                                  | 
//+------------------------------------------------------------------+
#property copyright ""
#property link ""
#property description ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 7 
//----     
#property indicator_plots   7
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       Gray 
#property indicator_color1 clrGray
//----   -  
#property indicator_style1  STYLE_DASHDOTDOT
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "X2MA"

//+--------------------------------------------+
//|     BB  |
//+--------------------------------------------+
//----      
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
#property indicator_type4   DRAW_LINE
#property indicator_type5   DRAW_LINE
#property indicator_type6   DRAW_LINE
#property indicator_type7   DRAW_LINE
//----    
#property indicator_color2  clrDodgerBlue
#property indicator_color3  clrLime
#property indicator_color4  clrMagenta
#property indicator_color5  clrMagenta
#property indicator_color6  clrLime
#property indicator_color7  clrDodgerBlue
//----   -  
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
#property indicator_style4 STYLE_SOLID
#property indicator_style5 STYLE_SOLID
#property indicator_style6 STYLE_SOLID
#property indicator_style7 STYLE_SOLID
//----     2
#property indicator_width2  2
#property indicator_width3  2
#property indicator_width4  2
#property indicator_width5  2
#property indicator_width6  2
#property indicator_width7  2
//----    
#property indicator_label2  "+4.236 level"
#property indicator_label3  "+2.618 level"
#property indicator_label4  "+1.618 level"
#property indicator_label5  "-1.618 level"
#property indicator_label6  "-2.618 level"
#property indicator_label7  "-4.236 level"

//+-----------------------------------+ 
//|                 |
//+-----------------------------------+
#define RESET  0   //        
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method MA_Method1=MODE_SMA; //  
input uint Length1=100; //                       
input int Phase1=15; //  ,
                     // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    

input Smooth_Method MA_Method2=MODE_JJMA; //  
input uint Length2=20; //    
input int Phase2=100;  //  ,
                       // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    

input uint ATRPeriod=100; //ATR 
input double Deviation=1.0; //

input Applied_price_ IPC=PRICE_CLOSE;// 
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
input int PriceShift=0; // c     
//+-----------------------------------+

//----   ,    
//      
double X2MA[];

//----   ,    
//        
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[];
double ExtLineBuffer4[],ExtLineBuffer5[],ExtLineBuffer6[];

//----      
double dPriceShift;
//----      
int ATR_Handle;
//----      
int min_rates_,min_rates_total;
//----     
double Deviation1,Deviation2,Deviation3;
//+------------------------------------------------------------------+   
//| X2MA FiboBands indicator initialization function                 | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_=XMA1.GetStartBars(MA_Method1,Length1,Phase1)+1;
   min_rates_total=min_rates_+XMA2.GetStartBars(MA_Method2, Length2, Phase2);
   min_rates_total=int(MathMax(min_rates_total,ATRPeriod));
//----
   Deviation1=Deviation*1.618;
   Deviation2=Deviation*2.618;
   Deviation3=Deviation*4.236;

//----       
   XMA1.XMALengthCheck("Length1", Length1);
   XMA2.XMALengthCheck("Length2", Length2);
//----       
   XMA1.XMAPhaseCheck("Phase1", Phase1, MA_Method1);
   XMA2.XMAPhaseCheck("Phase2", Phase2, MA_Method2);

//----    
   dPriceShift=_Point*PriceShift;

//----    ATR
   ATR_Handle=iATR(NULL,PERIOD_CURRENT,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE) Print("      ATR");

//----      
   SetIndexBuffer(0,X2MA,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(1,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer2,INDICATOR_DATA);
   SetIndexBuffer(3,ExtLineBuffer3,INDICATOR_DATA);
   SetIndexBuffer(4,ExtLineBuffer4,INDICATOR_DATA);
   SetIndexBuffer(5,ExtLineBuffer5,INDICATOR_DATA);
   SetIndexBuffer(6,ExtLineBuffer6,INDICATOR_DATA);
//----  ,      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(6,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(5,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(6,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"FiboBands(",Smooth1,", ",Smooth2,", ",Length1,", ",Length2,", ",ATRPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| X2MA FiboBands iteration function                                | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----       
   double price,x1xma,x2xma,dev1,dev2,dev3,ATR[1];
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price_
      price=PriceSeries(IPC,bar,open,low,high,close);

      //----    XMASeries. 
      //    begin   min_rates_ . .   XMA   
      x1xma=XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      x2xma=XMA2.XMASeries(min_rates_,prev_calculated,rates_total,MA_Method2,Phase2,Length2,x1xma,bar,false);
      X2MA[bar]=x2xma+dPriceShift;

      //----       ATR[]
      if(CopyBuffer(ATR_Handle,0,rates_total-1-bar,1,ATR)<=0) return(RESET);

      //----  

      dev1=Deviation1*ATR[0];
      dev2=Deviation2*ATR[0];
      dev3=Deviation3*ATR[0];

      ExtLineBuffer1[bar]=X2MA[bar]+dev3;
      ExtLineBuffer2[bar]=X2MA[bar]+dev2;
      ExtLineBuffer3[bar]=X2MA[bar]+dev1;
      ExtLineBuffer4[bar]=X2MA[bar]-dev1;
      ExtLineBuffer5[bar]=X2MA[bar]-dev2;
      ExtLineBuffer6[bar]=X2MA[bar]-dev3;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
