//+---------------------------------------------------------------------+
//|                                            Cronex_T_DeMarker_GF.mq5 | 
//|                                            Copyright  2009, Cronex | 
//|                                          http://www.metaquotes.net/ | 
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2009, Cronex"
#property link "http://www.metaquotes.net/" 
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    7
#property indicator_buffers 7 
//----     
#property indicator_plots   5
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrIndianRed,clrTeal
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "Divergence move Down";"Divergence move Up"

//----     
#property indicator_type2 DRAW_LINE
//----     
#property indicator_color2 clrBlue
//----   -  
#property indicator_style2 STYLE_SOLID
//----     1
#property indicator_width2 1
//----    
#property indicator_label2  "DeMarker Smoothed"

//----      
#property indicator_type3 DRAW_COLOR_LINE
//----      
#property indicator_color3 clrRed,clrLime
//----   -  
#property indicator_style3 STYLE_DASHDOTDOT
//----     2
#property indicator_width3 2
//----    
#property indicator_label3  "DeMarker Smoothed move Down";"DeMarker Smoothed move Up"

//----     
#property indicator_type4 DRAW_ARROW
//----     
#property indicator_color4 clrLime
//----     1
#property indicator_width4 1
//----    
#property indicator_label4  "Cross Up"

//----     
#property indicator_type5 DRAW_ARROW
//----     
#property indicator_color5 clrRed
//----     1
#property indicator_width5 1
//----    
#property indicator_label5  "Cross Down"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CT3   SmoothAlgorithms.mqh
CT3 T3;
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint DeMarker=24;
input uint  DeMStep=4;
input double b_=61.8; //k x100
//+-----------------------------------+
//----      
int min_rates_,min_rates_total;
//----   ,    
//      
double DiverTBuffer[];
double ColorDiverTBuffer[];
double DeMarkerBuffer[];
double DeMarkerTBuffer[];
double ColorDeMarkerTBuffer[];
double CrossUpTBuffer[];
double CrossDnTBuffer[];
//----       
int Ind_Handle[4];
//+------------------------------------------------------------------+    
//| Cronex_T_DeMarker_GF indicator initialization function           | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_=int(DeMarker+DeMStep*3);
   min_rates_total=min_rates_+1;

//----    iDeMarker 1
   Ind_Handle[0]=iDeMarker(Symbol(),PERIOD_CURRENT,DeMarker+DeMStep*0);
   if(Ind_Handle[0]==INVALID_HANDLE)Print("      iDeMarker 1");
//----    iDeMarker 2
   Ind_Handle[1]=iDeMarker(Symbol(),PERIOD_CURRENT,DeMarker+DeMStep*1);
   if(Ind_Handle[1]==INVALID_HANDLE)Print("      iDeMarker 2");
//----    iDeMarker 3
   Ind_Handle[2]=iDeMarker(Symbol(),PERIOD_CURRENT,DeMarker+DeMStep*2);
   if(Ind_Handle[2]==INVALID_HANDLE)Print("      iDeMarker 3");
//----    iDeMarker 4
   Ind_Handle[3]=iDeMarker(Symbol(),PERIOD_CURRENT,DeMarker+DeMStep*3);
   if(Ind_Handle[3]==INVALID_HANDLE)Print("      iDeMarker 4");

//----      
   SetIndexBuffer(0,DiverTBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----       ,  
   SetIndexBuffer(0,DiverTBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ColorDiverTBuffer,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(2,DeMarkerBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,DeMarkerTBuffer,INDICATOR_DATA);
   SetIndexBuffer(4,ColorDeMarkerTBuffer,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(5,CrossUpTBuffer,INDICATOR_DATA);
   SetIndexBuffer(6,CrossDnTBuffer,INDICATOR_DATA);

//----       
   ArraySetAsSeries(DiverTBuffer,true);
   ArraySetAsSeries(ColorDiverTBuffer,true);
   ArraySetAsSeries(DeMarkerBuffer,true);
   ArraySetAsSeries(DeMarkerTBuffer,true);
   ArraySetAsSeries(ColorDeMarkerTBuffer,true);
   ArraySetAsSeries(CrossUpTBuffer,true);
   ArraySetAsSeries(CrossDnTBuffer,true);

//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);

//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----   
   PlotIndexSetInteger(3,PLOT_ARROW,108);
   PlotIndexSetInteger(4,PLOT_ARROW,108);

//----      
   string shortname="Cronex_T_DeMarker_GF("+string(DeMarker)+", "+string(DeMStep)+", "+string(b_)+")";

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+  
//| Cronex_T_DeMarker_GF iteration function                          | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total
      || BarsCalculated(Ind_Handle[0])<rates_total
      || BarsCalculated(Ind_Handle[1])<rates_total
      || BarsCalculated(Ind_Handle[2])<rates_total
      || BarsCalculated(Ind_Handle[3])<rates_total) return(RESET);

//----    
   int to_copy,limit,bar,maxbar;
//----       
   double DeMark1[],DeMark2[],DeMark3[],DeMark4[];

//----         
   ArraySetAsSeries(DeMark1,true);
   ArraySetAsSeries(DeMark2,true);
   ArraySetAsSeries(DeMark3,true);
   ArraySetAsSeries(DeMark4,true);

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-2; //      
     }
   else limit=rates_total-prev_calculated; //      
//----   
   to_copy=limit+1;
   
//----      
   if(CopyBuffer(Ind_Handle[0],0,0,to_copy,DeMark1)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle[1],0,0,to_copy,DeMark2)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle[2],0,0,to_copy,DeMark3)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle[3],0,0,to_copy,DeMark4)<=0) return(RESET);
   
   maxbar=rates_total-min_rates_total-2;
   
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      DeMarkerBuffer[bar]=(DeMark1[bar]+DeMark2[bar]+DeMark3[bar]+DeMark4[bar])*100/4-50;
      DeMarkerTBuffer[bar]=T3.T3Series(maxbar,prev_calculated,rates_total,0,b_,DeMarker,DeMarkerBuffer[bar],bar,true);
      CrossUpTBuffer[bar]=EMPTY_VALUE;
      CrossDnTBuffer[bar]=EMPTY_VALUE;

      if(DeMarkerBuffer[bar+1]<=DeMarkerTBuffer[bar+1] && DeMarkerBuffer[bar]>DeMarkerTBuffer[bar])
         CrossUpTBuffer[bar]=DeMarkerTBuffer[bar];

      if(DeMarkerBuffer[bar+1]>=DeMarkerTBuffer[bar+1] && DeMarkerBuffer[bar]<DeMarkerTBuffer[bar])
         CrossDnTBuffer[bar]=DeMarkerTBuffer[bar];
         
      if(DeMarkerBuffer[bar]<DeMarkerTBuffer[bar]) ColorDeMarkerTBuffer[bar]=0;
      else ColorDeMarkerTBuffer[bar]=1;
      
      DiverTBuffer[bar]=DeMarkerBuffer[bar]-DeMarkerTBuffer[bar];
      if (DeMarkerBuffer[bar]-DeMarkerTBuffer[bar]<DeMarkerBuffer[bar+1]-DeMarkerTBuffer[bar+1]) ColorDiverTBuffer[bar]=0;
      else ColorDiverTBuffer[bar]=1;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
