//+------------------------------------------------------------------+
//|                                            YURAZ_CLOSEPRC_V1.mq5 |
//|                        Copyright 2009, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+

//
//  %  
//         %  
//      1%   , 24    24%  
//  
// 1        -  
// 2      ,    % 
// 


//
//           
//  

#property copyright "2009, YURAZ"
#property link      "http://www.masterforex-v.org"
#property version   "1.00"

input string gpsPrcClose="10"; // 10%   
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// MT5 
//
class CYurazTrade
  {
public:
   int               AllCloseMonitor;
   double            PrcClose;

   void CYurazTrade()
     {
      AllCloseMonitor=0; //      
      LastCloseCode=0;
      LastCodePS=0;

      PrcClose=100000000000;

     } // 
   void              CloseAll();
private:
   int               LastCloseCode;
   int               LastCodePS;

   string            sCodeError(int code);
   void              ClosePosition(string sSymbol,int ip);
  };
//
//     
//
string CYurazTrade::sCodeError(int retcode)
  {
   string sRetCode;
   switch(retcode)
     {
      case TRADE_RETCODE_REQUOTE: sRetCode=(string)retcode+" "; break;// 10004
      case TRADE_RETCODE_REJECT: sRetCode=(string)retcode+"  ";  break;
      case TRADE_RETCODE_CANCEL: sRetCode = (string)retcode+"   "; break;
      case TRADE_RETCODE_PLACED: sRetCode = (string)retcode+"  "; break;
      case TRADE_RETCODE_DONE: sRetCode=(string)retcode+"  "; break;
      case TRADE_RETCODE_DONE_PARTIAL: sRetCode=(string)retcode+"   "; break;
      case TRADE_RETCODE_ERROR: sRetCode=(string)retcode+"   "; break;
      case TRADE_RETCODE_TIMEOUT: sRetCode = (string)retcode+"     "; break;
      case TRADE_RETCODE_INVALID: sRetCode = (string)retcode+"  "; break;
      case TRADE_RETCODE_INVALID_VOLUME: sRetCode=(string)retcode+"    "; break;
      case TRADE_RETCODE_INVALID_PRICE: sRetCode = (string)retcode+"    "; break;
      case TRADE_RETCODE_INVALID_STOPS: sRetCode = (string)retcode+"    "; break;
      case TRADE_RETCODE_TRADE_DISABLED: sRetCode=(string)retcode+"  "; break;
      case TRADE_RETCODE_MARKET_CLOSED: sRetCode =(string)retcode+"  "; break;
      case TRADE_RETCODE_NO_MONEY: sRetCode=(string)retcode+"       "; break;
      case TRADE_RETCODE_PRICE_CHANGED: sRetCode=(string)retcode+"  "; break;
      case TRADE_RETCODE_PRICE_OFF: sRetCode=(string)retcode+"     "; break;
      case TRADE_RETCODE_INVALID_EXPIRATION: sRetCode=(string)retcode+"      "; break;
      case TRADE_RETCODE_ORDER_CHANGED: sRetCode=(string)retcode+"   "; break;
      case TRADE_RETCODE_TOO_MANY_REQUESTS: sRetCode=(string)retcode+"   "; break;
      default:   sRetCode=(string)retcode+"  "; break;
     }
   return(sRetCode);
  }
// 
//    
// 
void CYurazTrade::CloseAll()
  {
   int pos=PositionsTotal(); //    
   for(int ip=0;ip<pos;ip++)
     {
      string sSymbol=PositionGetSymbol(ip);
      if(PositionSelect(sSymbol)==true)
         ClosePosition(sSymbol,ip);
      else
         LastCodePS=GetLastError(); //     ,      
     }
   if(PositionsTotal()==0)
     {
      AllCloseMonitor=0;    //        
     }

   printf(" %s ",sCodeError(LastCloseCode)); //    

   if(LastCloseCode==TRADE_RETCODE_MARKET_CLOSED) //  
     {
      AllCloseMonitor=0;    //         
      LastCloseCode=0;
     }

   if(LastCloseCode==TRADE_RETCODE_TRADE_DISABLED) //  
     {
      AllCloseMonitor=0;    //         
      LastCloseCode=0;
     }
   if(AllCloseMonitor==0)
     {
      if(ObjectGetInteger(0,buttonID,OBJPROP_STATE)==true)
        {

         //---    ""
         EventChartCustom(0,CHARTEVENT_CUSTOM+999-CHARTEVENT_CUSTOM,0,0,"");
         //---     
         BroadcastEvent(ChartID(),0,"Broadcast Message");
         ObjectSetInteger(0,buttonID,OBJPROP_STATE,false);
         ChartRedraw();//      
        }
     }

  }
//
// MT5 -  
//
void CYurazTrade::ClosePosition(string sSymbol,int ip)
  {
   MqlTradeRequest request={0}; //  
   MqlTradeResult result={0}; //  



   request.symbol = sSymbol;
   request.volume = PositionGetDouble( POSITION_VOLUME );
   request.action= TRADE_ACTION_DEAL; //(ENUM_TRADE_REQUEST_ACTIONS)0; //TRADE_ACTION_MARKET ; //   
   request.tp=0;
   request.sl=0;
   request.deviation=(ulong) ((SymbolInfoDouble(sSymbol,SYMBOL_ASK)-SymbolInfoDouble(sSymbol,SYMBOL_BID))/SymbolInfoDouble(sSymbol,SYMBOL_POINT)) ; //   
   request.type_filling=ORDER_FILLING_CANCEL;

if (request.volume > 9) //       request
   request.volume=9;


   if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
     {
      request.type=ORDER_TYPE_SELL;
      request.price=SymbolInfoDouble(sSymbol,SYMBOL_BID);
     }
   if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
     {
      request.type=ORDER_TYPE_BUY;
      request.price=SymbolInfoDouble(sSymbol,SYMBOL_ASK);
     }
   OrderSend(request,result);
   LastCloseCode=result.retcode;

  }
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//   (    )
//
class CYurazMonitor
  {
public:
   void              Monitor();

  };
// 
// 
// 
void CYurazMonitor::Monitor(void)
  {
  yzTrade.PrcClose = StringToDouble(ObjectGetString(0,editID,OBJPROP_TEXT));
 ObjectSetString(0,labelID1,OBJPROP_TEXT,
  DoubleToString( AccountInfoDouble(ACCOUNT_PROFIT),2) 
  + " "
  +DoubleToString( AccountInfoDouble(ACCOUNT_BALANCE)/100,2)
  + " "
  +DoubleToString( yzTrade.PrcClose,4)
  
  );
   if(yzTrade.AllCloseMonitor!=0) //   ,     
     {
      yzTrade.CloseAll();

     }
   if(AccountInfoDouble(ACCOUNT_PROFIT)>AccountInfoDouble(ACCOUNT_BALANCE)/100 *yzTrade.PrcClose)
     {
      yzTrade.AllCloseMonitor=2; //    
      yzTrade.CloseAll();
     }
  }
//  
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// 
// 
CYurazTrade   yzTrade;    //     
CYurazMonitor yzMonitor;  //  
                          //
// 

string buttonID="Button";
//string labelID="Info";
string editID="Edit";
string labelID1="Info1";

int broadcastEventID=5000;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit()
  {

   yzTrade.AllCloseMonitor=0;

//---  ,    
   ObjectCreate(0,buttonID,OBJ_BUTTON,0,100,100);
   ObjectSetInteger(0,buttonID,OBJPROP_COLOR,White);
   ObjectSetInteger(0,buttonID,OBJPROP_BGCOLOR,Gray);
   ObjectSetInteger(0,buttonID,OBJPROP_XDISTANCE,10);
   ObjectSetInteger(0,buttonID,OBJPROP_YDISTANCE,60);
   ObjectSetInteger(0,buttonID,OBJPROP_XSIZE,250);
   ObjectSetInteger(0,buttonID,OBJPROP_YSIZE,50);
   ObjectSetString(0,buttonID,OBJPROP_FONT,"Arial");
   ObjectSetString(0,buttonID,OBJPROP_TEXT,"    ");
   ObjectSetInteger(0,buttonID,OBJPROP_FONTSIZE,10);
   ObjectSetInteger(0,buttonID,OBJPROP_SELECTABLE,false); //     

//---     
//ObjectCreate(0,labelID,OBJ_LABEL,0,100,100);
//ObjectSetInteger(0,labelID,OBJPROP_COLOR,Red);
//ObjectSetInteger(0,labelID,OBJPROP_XDISTANCE,10);
//ObjectSetInteger(0,labelID,OBJPROP_YDISTANCE,100);
//ObjectSetString(0,labelID,OBJPROP_FONT,"Trebuchet MS");
//ObjectSetString(0,labelID,OBJPROP_TEXT," ");
//ObjectSetInteger(0,labelID,OBJPROP_FONTSIZE,20);
//ObjectSetInteger(0,labelID,OBJPROP_SELECTABLE,0);


   ObjectCreate(0,labelID1,OBJ_LABEL,0,100,100);
   ObjectSetInteger(0,labelID1,OBJPROP_COLOR,Red);
   ObjectSetInteger(0,labelID1,OBJPROP_XDISTANCE,10);
   ObjectSetInteger(0,labelID1,OBJPROP_YDISTANCE,20);
   ObjectSetString(0,labelID1,OBJPROP_FONT,"Trebuchet MS");
   ObjectSetString(0,labelID1,OBJPROP_TEXT,"      ");
   ObjectSetInteger(0,labelID1,OBJPROP_FONTSIZE,10);
   ObjectSetInteger(0,labelID1,OBJPROP_SELECTABLE,true);

   ObjectCreate(0,editID,OBJ_EDIT,0,100,100);
   ObjectSetInteger(0,editID,OBJPROP_XDISTANCE,370);
   ObjectSetInteger(0,editID,OBJPROP_YDISTANCE,20);
   ObjectSetInteger(0,editID,OBJPROP_COLOR,Red);

   ObjectSetInteger(0,editID,OBJPROP_XSIZE,50);
   ObjectSetInteger(0,editID,OBJPROP_YSIZE,50);
   ObjectSetString(0,editID,OBJPROP_TEXT,gpsPrcClose); // 3%
   ObjectSetInteger(0,editID,OBJPROP_FONTSIZE,20);
   ObjectSetInteger(0,editID,OBJPROP_SELECTABLE,false); //     

   yzTrade.PrcClose=StringToDouble(gpsPrcClose); //     %      

                                                 //   int customEventID; //     
//   string message;    //     
//   bool selected=ObjectGetInteger(0,buttonID,OBJPROP_STATE);
//   if(selected==true)
//     {
//      message=" ";
//      customEventID=CHARTEVENT_CUSTOM+1;
//     }
//   else //   
//     {
//      message=" ";
//      customEventID=CHARTEVENT_CUSTOM+999;
//     }
//
//   EventChartCustom(0,CHARTEVENT_CUSTOM+999-CHARTEVENT_CUSTOM,0,0,message);

   EventSetTimer(1); //    OnTimer
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnDeinit()
  {
   ObjectDelete(0,buttonID);
//ObjectDelete(0,labelID);
   ObjectDelete(0,editID);
   EventKillTimer();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnTick()
  {

  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnTimer()
  {
   yzMonitor.Monitor(); //   
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
//---      
   if(id==CHARTEVENT_OBJECT_CLICK)
     {
      string clickedChartObject=sparam;
      //---       buttonID
      if(clickedChartObject==buttonID)
        {
         //---   -    
         bool selected=ObjectGetInteger(0,buttonID,OBJPROP_STATE);

         //---     
         // printf("  =%f ",selected);
         int customEventID; //     
         string message;    //     
         //---   
         if(selected)
           {
            message=" ";
            customEventID=CHARTEVENT_CUSTOM+1;

           }
         else //   
           {
            message=" ";
            customEventID=CHARTEVENT_CUSTOM+999;
           }
         //---    ""
         EventChartCustom(0,customEventID-CHARTEVENT_CUSTOM,0,0,message);
         //---     
         BroadcastEvent(ChartID(),0,"Broadcast Message");
         //---  
         // printf("   ID =%d",customEventID);
        }
      ChartRedraw();//      
     }

//---       
   if(id>CHARTEVENT_CUSTOM)
     {
      if(id==broadcastEventID)
        {
         // printf("       id= %d",lparam);
        }
      else
        {
         //---     
         string info=sparam;
         // printf("    ID =%d",id);

         if(id==1001)
           {
            yzTrade.AllCloseMonitor=1; //        
           }

         //---    
         // ObjectSetString(0,labelID,OBJPROP_TEXT,sparam);
         ChartRedraw();//      
        }
     }
  }
//+------------------------------------------------------------------+
//|              |
//+------------------------------------------------------------------+
void BroadcastEvent(long lparam,double dparam,string sparam)
  {
   int limit=100;//      100  
   int eventID=broadcastEventID-CHARTEVENT_CUSTOM;
   long currChart,prevChart=ChartFirst();
   int i=0;
   while(i<limit)
     {
      currChart=ChartNext(prevChart); //      
      if(currChart==0) break;         //    
      EventChartCustom(currChart,eventID,lparam,dparam,sparam);
      prevChart=currChart;//      ChartNext() 
      i++;//    
     }
  }
//+------------------------------------------------------------------+
