//+------------------------------------------------------------------+
//|                                                       50_100.mq4 |
//|                      Copyright  2009, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
#property indicator_chart_window
extern color u50=Blue;
extern color u100=Green;
extern int   mul=50;
//+------------------------------------------------------------------+
int init() {return(0);}
//+------------------------------------------------------------------+
int deinit() {DelLine(); return(0);}
//+------------------------------------------------------------------+
int start()
{int d=1,k=10.0;
 while(MathFloor(mul/k)>1.0) {d++;k=k*10;}
 double l=NormalizeDouble(WindowPriceMin(0),Digits-d)-mul*2*Point;
 double h=WindowPriceMax(0)+mul*2*Point;
 DelLine();
 while(l<h)
   {DrawLine(l,u100,2,STYLE_SOLID);
    l=l+mul*Point;
    DrawLine(l,u50,1,STYLE_DASH);
    l=l+mul*Point;}
return(0);}
//+------------------------------------------------------------------+
void DelLine()
{for(int i=ObjectsTotal()-1;i>=0;i--)
   if(StringFind(ObjectName(i),"u_"+mul+"_")>=0)
     ObjectDelete(ObjectName(i));
return;}
//+------------------------------------------------------------------+
void DrawLine(double p,color c,int w,int s)
{string name="u_"+mul+"_"+DoubleToStr(p,Digits);
 ObjectCreate(name,OBJ_HLINE,0,0,p);
 ObjectSet(name,OBJPROP_COLOR,c);
 ObjectSet(name,OBJPROP_WIDTH,w);
 ObjectSet(name,OBJPROP_STYLE,s);
return;}
//+------------------------------------------------------------------+

