//+------------------------------------------------------------------+
//|                                            b-Profitunity_MT4.mq4 |
//|                          Copyright  2010, D. Zhebrak aka Necron |
//|                                                  www.mqlcoder.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, D. Zhebrak aka Necron"
#property link      "www.mqlcoder.ru"
#property link      "mailto: mqlcoder@yandex.ru"
#define   b.version "1.0.0.1"

extern int     BarsToProcess=1000;   //     (-1 )
//+------------------------------------------------------------------+
//|                                                        |
//+------------------------------------------------------------------+
bool bull_dish(int shift)
 {
  if(AO(shift)>AO(shift+1) && AO(shift+2)>AO(shift+1) && AO(shift)>0 && AO(shift+1)>0 && AO(shift+2)>0)
  return(true);else return(false);     
 } 
//+------------------------------------------------------------------+
//|                                                    |
//+------------------------------------------------------------------+  
bool bear_dish(int shift)
 {
  if(AO(shift)<AO(shift+1) && AO(shift+2)<AO(shift+1) && AO(shift)<0 && AO(shift+1)<0 && AO(shift+2)<0)
  return(true);else return (false);
 }
//+------------------------------------------------------------------+
//|                                      |
//+------------------------------------------------------------------+   
bool bull_cross(int Shift)
 {
  if(AO(Shift+1)<0 && AO(Shift)>0)
  return(true);else return(false);
 }
//+------------------------------------------------------------------+
//|                                   |
//+------------------------------------------------------------------+   
bool bear_cross(int Shift)
 {
  if(AO(Shift+1)>0 && AO(Shift)<0)
  return(true);else return(false);
 }
//+------------------------------------------------------------------+
//|       AO    |
//|mode   MODE_UPPER  MODE_LOWER                   |                                                                        
//+------------------------------------------------------------------+
int GetPeak(int shift_start, int mode, int BarsToProcess)
 {
  int shift;
  double ao0,ao1,ao2;
  int retn_shift;
   
  for(shift=shift_start;shift<BarsToProcess;shift++)
   {
    ao0=iAO(NULL,0,shift);
    ao1=iAO(NULL,0,shift+1);
    ao2=iAO(NULL,0,shift+2);
  
    if(mode==MODE_UPPER)
     {
      if(ao0>0 && ao2>0 && ao0<ao1 && ao1>ao2)
       {
        retn_shift=shift;
        break;
       }
     }
    else if(mode==MODE_LOWER)
     {
      if(ao0<0 && ao2<0 && ao0>ao1 && ao1<ao2)
       {
        retn_shift=shift;
        break;
       }
     } 
   }
  return(retn_shift+1);
 }
//+------------------------------------------------------------------------+
//|         |
//|mode   MODE_UPPER  MODE_LOWER                         |                                                                        
//+------------------------------------------------------------------------+
int Get0CrossShift(int shift_start,int mode,int BarsToProcess) 
 {
  int    shift=0,
         retn_shift=0;
  double ao0=0,
         ao1=0;
  
  for(shift=shift_start;shift<BarsToProcess;shift++)
   {
    ao0=iAO(NULL,0,shift);
    ao1=iAO(NULL,0,shift+1);
   
    if(mode==MODE_UPPER)
     {
      if(ao0>0 && ao1<0)
       {
        retn_shift=shift;
        break;
       }
     }
    if(mode==MODE_LOWER)
     {  
      if(ao0<0 && ao1>0)
       {
        retn_shift=shift;
        break;
       }
     } 
   }
  return(retn_shift+1);
 }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
bool two_high_peaks(int Shift,int BarsToProcess)
 {
  int high_peak1=GetPeak(Shift, MODE_UPPER,BarsToProcess);
  int high_peak2=GetPeak(high_peak1,MODE_UPPER,BarsToProcess);
  if(iAO(Symbol(),Period(),high_peak1)<iAO(Symbol(),Period(),high_peak2))

  return(true);else return(false);
 } 
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+ 
bool two_low_peaks(int Shift,int BarsToProcess)
 {
  int low_peak1=GetPeak(Shift,MODE_LOWER,BarsToProcess);
  int low_peak2=GetPeak(low_peak1,MODE_LOWER,BarsToProcess);
  if(iAO(Symbol(),Period(),low_peak1)>iAO(Symbol(),Period(),low_peak2))
 
  return(true);else return(false);
 }     
//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+   
bool bull_second_wisdom(int shift)
 {
  double ao=iAO(Symbol(),Period(),shift),
         ao1=iAO(Symbol(),Period(),shift+1),
         ao2=iAO(Symbol(),Period(),shift+2),
         ao3=iAO(Symbol(),Period(),shift+3),
         ao4=iAO(Symbol(),Period(),shift+4);
  
  if(ao>ao1 && ao1>ao2 && ao2>ao3 && ao3<ao4)
  
  return(true);else return(false);  
 }
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+  
bool bear_second_wisdom(int shift)
 {
  double ao=iAO(Symbol(),Period(),shift),
         ao1=iAO(Symbol(),Period(),shift+1),
         ao2=iAO(Symbol(),Period(),shift+2),
         ao3=iAO(Symbol(),Period(),shift+3),
         ao4=iAO(Symbol(),Period(),shift+4);

  if(ao<ao1 && ao1<ao2 && ao2<ao3 && ao3>ao4)

  return(true);else return(false);  
 }
//+------------------------------------------------------------------+
//|     AO   shift          |
//+------------------------------------------------------------------+ 
double AO(int Shift)
 {
  return(NormalizeDouble(iAO(NULL, 0, Shift), Digits + 2));
 }
//+------------------------------------------------------------------+
//|     AC   shift          |
//+------------------------------------------------------------------+   
double AC(int Shift)
 {
  return(NormalizeDouble(iAC(NULL, 0, Shift), Digits + 2));
 }
//+------------------------------------------------------------------+
//| 2                                            |
//+------------------------------------------------------------------+
bool bull_double_bar_above(int Shift)
 {
  if(AC(Shift)>AC(Shift+1) && AC(Shift+1)>AC(Shift+2) && AC(Shift+2) < AC(Shift+3) && AC(Shift+2) > 0)
  return(true);else return(false);
 }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+ 
bool bull_triple_bar_below(int Shift)
 {
  if(AC(Shift) > AC(Shift+1) && AC(Shift+1)>AC(Shift+2) && AC(Shift+2)>AC(Shift+3) 
      && AC(Shift+3)<AC(Shift+4) && AC(Shift) < 0 /*) ||(AC(Shift) > 0 && AC(Shift+1) < 0))*/)
  return(true); else return(false);
 }
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+ 
bool bull_cross_and_double_bar(int Shift)
 {
  if(AC(Shift)>AC(Shift+1) && AC(Shift+1)>AC(Shift+2) && AC(Shift+2)<AC(Shift+3) && AC(Shift)>0 && AC(Shift+1)<0)
  return(true); else return(false);
 }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+ 
bool bear_double_bar_below(int Shift)
 { 
  if(AC(Shift)<AC(Shift+1) && AC(Shift+1)<AC(Shift+2) && AC(Shift+2)>AC(Shift+3) && AC(Shift+2)<0)
  return(true); else return(false);
 }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+ 
bool bear_triple_bar_above(int Shift)
 {
  if(AC(Shift)<AC(Shift+1) && AC(Shift+1)<AC(Shift+2) && AC(Shift+2)<AC(Shift+3)
     && AC(Shift+3)>AC(Shift+4) && ((AC(Shift)>0) || (AC(Shift)<0 && AC(Shift+2)>0 && AC(Shift+1)<0 )))
  return(true); else return(false);
 }
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+ 
bool bear_cross_and_double_bar(int Shift)
 {
  if(AC(Shift)<AC(Shift+1) && AC(Shift+1)<AC(Shift+2) && AC(Shift+2)>AC(Shift+3) && AC(Shift)<0 && AC(Shift+1)>0)
  return(true); else return(false);
 }
//+---------------------------------------------------------------------+
//|    /.    |
//+---------------------------------------------------------------------+ 
int GetSecond(int shift,int mode)
 {
  int res=0;
  double high,high1,low,low1;
   for(int j=shift;j<Bars-1;j++)
    {
     if(mode==MODE_UPPER)
      {
       if(High[j]>High[shift])
        {
         res=j;
         break;
        }
      }
     else if(mode==MODE_LOWER)
      {
       if(Low[j]<Low[shift])
        {
         res=j;
         break;
        }
      } 
    }
   return(res);
 }
//+------------------------------------------------------------------+
//| 1       -1            |
//+------------------------------------------------------------------+  
int Zone(int shift)
 {
  int res;
  if     (AO(shift)>AO(shift+1) && AC(shift)>AC(shift+1)) res=1;
  else if(AO(shift)<AO(shift+1) && AC(shift)<AC(shift+1)) res=-1;
  
  return(res);
 }         
//+------------------------------------------------------------------+
//|                                                    |
//+------------------------------------------------------------------+ 
bool consbars(int mode,int shift)
 {
  bool result=false;
  if(mode==MODE_UPPER)
   {
    if(Zone(shift)==1 && Zone(shift+1)==1 && Zone(shift+2)==1 && Zone(shift+3)==1 && Zone(shift+4)==1 && Zone(shift+5)!=1)
         result=true;
   }
  if(mode==MODE_LOWER)
   {
     if(Zone(shift)==-1 && Zone(shift+1)==-1 && Zone(shift+2)==-1 && Zone(shift+3)==-1 && Zone(shift+4)==-1 && Zone(shift+5)!=-1)
         result=true;
   }
  return(result);       
 }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+  
void Create.Arrow(string name,datetime t1,double pr,int code,color clr,int width)
 {
  if (ObjectFind(name)<0) ObjectCreate(name, OBJ_ARROW, 0, 0,0);
  ObjectSet(name, OBJPROP_TIME1, t1);
  ObjectSet(name, OBJPROP_PRICE1, pr);
  ObjectSet(name, OBJPROP_ARROWCODE, code);
  ObjectSet(name, OBJPROP_COLOR, clr);
  ObjectSet(name, OBJPROP_WIDTH, width);
 } 
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+ 
void Create.TL(string name,datetime t1,double p1,datetime t2,double p2,int width,int stl,color clr,bool ray)
 { 
  if (ObjectFind(name)<0) ObjectCreate(name, OBJ_TREND, 0, 0,0, 0,0);
  ObjectSet(name, OBJPROP_TIME1 , t1);
  ObjectSet(name, OBJPROP_PRICE1, p1);
  ObjectSet(name, OBJPROP_TIME2 , t2);
  ObjectSet(name, OBJPROP_PRICE2, p2);
  ObjectSet(name, OBJPROP_COLOR , clr);
  ObjectSet(name, OBJPROP_RAY   , ray);
  ObjectSet(name, OBJPROP_STYLE , stl);
  ObjectSet(name, OBJPROP_WIDTH , width);
 }

double Get.Teeth(string sym,int tf,int bar)
 {
  double _return=-1;
  int dg=MarketInfo(sym,MODE_DIGITS);
  
  _return=iAlligator(sym,tf,13,8,8,5,5,3,MODE_SMMA,PRICE_MEDIAN,MODE_GATORTEETH,bar);
  return(NormalizeDouble(_return,dg));
 } 

void Create.Text(string nm, string txt, int wnd,datetime t1, double pr1,int fs,color clr)
 {
  if(ObjectFind(nm)<0) ObjectCreate(nm,OBJ_TEXT,wnd,0,0);
  ObjectSet(nm, OBJPROP_TIME1, t1);
  ObjectSet(nm,OBJPROP_PRICE1,pr1);
  ObjectSet(nm, OBJPROP_COLOR, clr);
  ObjectSetText(nm, txt,fs,"Times New Roman",clr);
 }
double PointX(string Sym)
 {
   double   _return=0,
            po=MarketInfo(Sym,MODE_POINT);
   int      dg=MarketInfo(Sym,MODE_DIGITS);
   
   if(dg == 5 || dg == 3) 
     {
      _return = po * 10;
     }
   if(dg == 4 || dg == 2) 
     {
      _return = po;
     }
   return(_return);
 }      