//+----------------------------------------------------------------------------+
//|                                                       e-CloseByProfit.mq4  |
//|                                                      . aka KimIV  |
//|                                                       http://www.kimiv.ru  |
//|                                                                            |
//|  22.10.2006               |
//|                .                                       |
//|  20.06.2008       .                  |
//|  18.08.2008    StopLoss.                                   |
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"
#define   MAGIC     20061022

//-------    ------------------------------------------
extern string _P_Expert = "----------  ";
extern bool   CurSymbolOnly   = False;            //   
extern int    StopLoss        = 100;              // Stop
extern int    TakeProfit      = 10;              // 
extern bool   ShowComment     = True;            //  
extern int    NumberAccount   = 0;               //   
extern bool   UseSound        = False;           //   
extern string NameFileSound   = "profit.wav";    //   
extern int    Slippage        = 3;               //  
extern int    NumberOfTry     = 5;               //  

//-------    --------------------------------------
color clCloseBuy  = Blue;         //    
color clCloseSell = Red;          //    
int   CurProfit;

//-------    -------------------------------------------
#include <stdlib.mqh>


//+----------------------------------------------------------------------------+
//|  expert initialization function                                            |
//+----------------------------------------------------------------------------+
void init() { if (!IsTesting()) Comment(""); }

//+----------------------------------------------------------------------------+
//|  expert deinitialization function                                          |
//+----------------------------------------------------------------------------+
void deinit() { if (!IsTesting()) Comment(""); }

//+----------------------------------------------------------------------------+
//|  expert start function                                                     |
//+----------------------------------------------------------------------------+
void start() {
  if (!IsTesting()) {
    if (NumberAccount>0 && NumberAccount!=AccountNumber()) {
      Message("    "+AccountNumber());
      return;
    } else Comment("");
  }

  CloseByProfit();
  if (ShowComment) {
    Comment(IIFs(CurSymbolOnly, "CurSymbolOnly  ","")
           ," =",CurProfit," ."
           ,"   =",StopLoss," ."
           ,"   =",TakeProfit," ."
           );
  }
}


//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|    : 19.02.2008                                                      |
//|  :                      |
//+----------------------------------------------------------------------------+
void ClosePosBySelect() {
  bool   fc;
  color  clClose;
  double ll, pa, pb, pp;
  int    err, it;

  if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
    for (it=1; it<=NumberOfTry; it++) {
      if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
      while (!IsTradeAllowed()) Sleep(5000);
      RefreshRates();
      pa=MarketInfo(OrderSymbol(), MODE_ASK);
      pb=MarketInfo(OrderSymbol(), MODE_BID);
      if (OrderType()==OP_BUY) {
        pp=pb; clClose=clCloseBuy;
      } else {
        pp=pa; clClose=clCloseSell;
      }
      ll=OrderLots();
      fc=OrderClose(OrderTicket(), ll, pp, Slippage, clClose);
      if (fc) {
        if (UseSound) PlaySound(NameFileSound); break;
      } else {
        err=GetLastError();
        if (err==146) while (IsTradeContextBusy()) Sleep(1000*11);
        Print("Error(",err,") Close ",GetNameOP(OrderType())," ",
              ErrorDescription(err),", try ",it);
        Print(OrderTicket(),"  Ask=",pa,"  Bid=",pb,"  pp=",pp);
        Print("sy=",OrderSymbol(),"  ll=",ll,"  sl=",OrderStopLoss(),
              "  tp=",OrderTakeProfit(),"  mn=",OrderMagicNumber());
        Sleep(1000*5);
      }
    }
  } else Print("  . Close ",GetNameOP(OrderType()));
}

//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 19.02.2008                                                     |
//|   :                  |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
void ClosePosFirstProfit(string sy="", int op=-1, int mn=-1) {
  int i, k=OrdersTotal();
  if (sy=="0") sy=Symbol();

  //    
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (mn<0 || OrderMagicNumber()==mn) {
            if (OrderProfit()+OrderSwap()>0) ClosePosBySelect();
          }
        }
      }
    }
  }
  //   
  k=OrdersTotal();
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (mn<0 || OrderMagicNumber()==mn) ClosePosBySelect();
        }
      }
    }
  }
}

//+----------------------------------------------------------------------------+
//|      .                                         |
//+----------------------------------------------------------------------------+
void CloseByProfit() {
  double pa, pb, pp;
  int    i, k=OrdersTotal(), pr=0;

  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (!CurSymbolOnly || OrderSymbol()==Symbol()) {
        pa=MarketInfo(OrderSymbol(), MODE_ASK);
        pb=MarketInfo(OrderSymbol(), MODE_BID);
        pp=MarketInfo(OrderSymbol(), MODE_POINT);
        if (pp==0) if (StringFind(OrderSymbol(), "JPY")<0) pp=0.0001; else pp=0.01;
        if (OrderType()==OP_BUY) {
          pr+=NormalizeDouble((pb-OrderOpenPrice())/pp, 0);
        }
        if (OrderType()==OP_SELL) {
          pr+=NormalizeDouble((OrderOpenPrice()-pa)/pp, 0);
        }
      }
    }
  }
  CurProfit=pr;
  if (CurProfit<=-StopLoss || CurProfit>=TakeProfit) ClosePosFirstProfit();
}

//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.09.2005                                                     |
//|   :                          |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    op -                                       |
//+----------------------------------------------------------------------------+
string GetNameOP(int op) {
  switch (op) {
    case OP_BUY      : return("Buy");
    case OP_SELL     : return("Sell");
    case OP_BUYLIMIT : return("BuyLimit");
    case OP_SELLLIMIT: return("SellLimit");
    case OP_BUYSTOP  : return("BuyStop");
    case OP_SELLSTOP : return("SellStop");
    default          : return("Unknown Operation");
  }
}

//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.02.2008                                                     |
//|   :        .      |
//+----------------------------------------------------------------------------+
string IIFs(bool condition, string ifTrue, string ifFalse) {
  if (condition) return(ifTrue); else return(ifFalse);
}

//+----------------------------------------------------------------------------+
//|                                              |
//+----------------------------------------------------------------------------+
void Message(string m) {
  Comment(m);
  if (StringLen(m)>0) Print(m);
}
//+----------------------------------------------------------------------------+

