//+----------------------------------------------------------------------------+
//|                                                e-CloseByPercentProfit.mq4  |
//|                                                                            |
//|        : $anto$,  http://www.community.finlist.org/member.php?u=152    |
//|        http://www.community.finlist.org/showpost.php?p=80058&postcount=96  |
//|  :   . aka KimIV,  http://www.kimiv.ru                  |
//|                                                                            |
//|  08.11.2007                                     |
//|                  .                    |
//|  21.11.2007         .  |
//|  19.12.2007       .               |
//|               Legge.                                              |
//|           http://forex.kbpauk.ru/showprofile.php?Cat=0&User=10595&what=login
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"

//-------    ------------------------------------------
extern string _P_Expert = "----------  ";
extern double PercentProfit   = 1.00;            //  
extern double PercentLoss     = 5.00;            //  
extern bool   DeleteOrders    = False;           //  
extern bool   CloseTerminal   = False;           //  
extern bool   ShowComment     = True;            //  
extern int    NumberAccount   = 0;               //   
extern bool   UseSound        = False;           //   
extern string NameFileSound   = "expert.wav";    //   
extern int    Slippage        = 3;               //  
extern int    NumberOfTry     = 5;               //  
extern int    PauseAfterError = 75;              //     

//-------    --------------------------------------
bool  gbDisabled  = False;        //   
color clCloseBuy  = Blue;         //    
color clCloseSell = Red;          //    
color clDelete    = Yellow;       //    

//-------    -------------------------------------------
#include <stdlib.mqh>
#include <WinUser32.mqh>


//+----------------------------------------------------------------------------+
//|                                                                            |
//|  ˨                                                   |
//|                                                                            |
//+----------------------------------------------------------------------------+
//|  expert initialization function                                            |
//+----------------------------------------------------------------------------+
void init() {
  gbDisabled=False;
  if (!IsTradeAllowed()) {
    Message("    \n"+
            "  ");
    gbDisabled=True; return;
  }
  if (!IsDllsAllowed()) {
    Message("    \n"+
            "    DLL");
    gbDisabled=True; return;
  }
  if (!IsLibrariesAllowed()) {
    Message("    \n"+
            "    ");
    gbDisabled=True; return;
  }
  if (!IsTesting()) {
    if (IsExpertEnabled()) Message("    ");
    else Message("  \"  \"");
  }
}

//+----------------------------------------------------------------------------+
//|  expert deinitialization function                                          |
//+----------------------------------------------------------------------------+
void deinit() { if (!IsTesting()) Comment(""); }

//+----------------------------------------------------------------------------+
//|  expert start function                                                     |
//+----------------------------------------------------------------------------+
void start() {
  if (gbDisabled) {
    Message("   !"); return;
  }
  if (!IsTesting()) {
    if (NumberAccount>0 && NumberAccount!=AccountNumber()) {
      Comment("  : "+AccountNumber()+" !");
      return;
    } else Comment("");
    if (ShowComment) {
      string st="PercentProfit="+DoubleToStr(PercentProfit, 2)
               +"  PercentLoss="+DoubleToStr(PercentLoss, 2)+"\n"
               +": ="+DoubleToStr(AccountBalance(), 2)
               +"  ="+DoubleToStr(AccountEquity(), 2)
               +"  ="+DoubleToStr((AccountEquity()/AccountBalance()-1)*100, 2)+" %"
               ;
      Comment(st);
    } else Comment("");
  }

  if (AccountEquity()>=AccountBalance()*(1+PercentProfit/100)
  ||  AccountEquity()<=AccountBalance()*(1-PercentLoss  /100)) {
    ClosePosFirstProfit();
    DeleteOrders();
  }
}


//+----------------------------------------------------------------------------+
//|                                                                            |
//|                                                     |
//|                                                                            |
//+----------------------------------------------------------------------------+
//|                                 |
//+----------------------------------------------------------------------------+
void ClosePosBySelect() {
  bool   fc;
  color  clClose;
  double ll, pAsk, pBid, pp;
  int    err, it;

  if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
    for (it=1; it<=NumberOfTry; it++) {
      if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
      while (!IsTradeAllowed()) Sleep(5000);
      RefreshRates();
      pAsk=MarketInfo(OrderSymbol(), MODE_ASK);
      pBid=MarketInfo(OrderSymbol(), MODE_BID);
      if (OrderType()==OP_BUY) {
        pp=pBid; clClose=clCloseBuy;
      } else {
        pp=pAsk; clClose=clCloseSell;
      }
      ll=OrderLots();
      fc=OrderClose(OrderTicket(), ll, pp, Slippage, clClose);
      if (fc) {
        if (UseSound) PlaySound(NameFileSound); break;
      } else {
        err=GetLastError();
        if (err==146) while (IsTradeContextBusy()) Sleep(1000*PauseAfterError);
        Print("Error(",err,") Close ",GetNameOP(OrderType())," ",
              ErrorDescription(err),", try ",it);
        Print(OrderTicket(),"  Ask=",pAsk,"  Bid=",pBid,"  pp=",pp);
        Print("sy=",OrderSymbol(),"  ll=",ll,"  sl=",OrderStopLoss(),
              "  tp=",OrderTakeProfit(),"  mn=",OrderMagicNumber());
        Sleep(1000*PauseAfterError);
      }
    }
  } else Print("  . Close ",GetNameOP(OrderType()));
}

//+----------------------------------------------------------------------------+
//|                              |
//+----------------------------------------------------------------------------+
void ClosePosFirstProfit() {
  int i, k=OrdersTotal();

  //    
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
        if (OrderProfit()+OrderSwap()>0) ClosePosBySelect();
      }
    }
  }
  //   
  k=OrdersTotal();
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderType()==OP_BUY || OrderType()==OP_SELL) ClosePosBySelect();
    }
  }
  if (CloseTerminal && !ExistPositions()) CloseTerminal();
}

//+----------------------------------------------------------------------------+
//|    .                                              |
//+----------------------------------------------------------------------------+
void CloseTerminal() {
Print("  CloseTerminal()");
  int hwnd=WindowHandle(Symbol(), Period());
  int hwnd_parent=0;

  while(!IsStopped()) {
    hwnd=GetParent(hwnd);
    if (hwnd==0) break;
    hwnd_parent=hwnd;
  }
  if (hwnd_parent!=0) PostMessageA(hwnd_parent, WM_CLOSE, 0, 0);
}

//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 28.11.2006                                                     |
//|   :                                                 |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                    |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
void DeleteOrders(string sy="", int op=-1, int mn=-1) {
  bool fd;
  int  err, i, it, k=OrdersTotal(), ot;

  if (sy=="0") sy=Symbol();
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      ot=OrderType();
      if (ot>1 && ot<6) {
        if ((OrderSymbol()==sy || sy=="") && (op<0 || ot==op)) {
          if (mn<0 || OrderMagicNumber()==mn) {
            for (it=1; it<=NumberOfTry; it++) {
              if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
              while (!IsTradeAllowed()) Sleep(5000);
              fd=OrderDelete(OrderTicket(), clDelete);
              if (fd) {
                if (UseSound) PlaySound(NameFileSound); break;
              } else {
                err=GetLastError();
                Print("Error(",err,") delete order ",GetNameOP(ot),": ",ErrorDescription(err),", try ",it);
                Sleep(1000*5);
              }
            }
          }
        }
      }
    }
  }
}

//+----------------------------------------------------------------------------+
//|                                          |
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
bool ExistPositions(string sy="", int op=-1, int mn=-1) {
  int i, k=OrdersTotal();

  if (StringLen(sy)==1 && StringGetChar(sy, 0)==48) sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==sy || sy=="") {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (op<0 || OrderType()==op) {
            if (mn<0 || OrderMagicNumber()==mn) return(True);
          }
        }
      }
    }
  }
  return(False);
}

//+----------------------------------------------------------------------------+
//|                                              |
//+----------------------------------------------------------------------------+
string GetNameOP(int op) {
	switch (op) {
		case OP_BUY      : return("Buy");
		case OP_SELL     : return("Sell");
		case OP_BUYLIMIT : return("Buy Limit");
		case OP_SELLLIMIT: return("Sell Limit");
		case OP_BUYSTOP  : return("Buy Stop");
		case OP_SELLSTOP : return("Sell Stop");
		default          : return("Unknown Operation");
	}
}

//+----------------------------------------------------------------------------+
//|                                              |
//+----------------------------------------------------------------------------+
void Message(string m) {
  Comment(m);
  if (StringLen(m)>0) Print(m);
}
//+----------------------------------------------------------------------------+

