//+------------------------------------------------------------------+
//|                                                    Ilan_mql5.mq5 |
//|                         Copyright  2010, Tarakan Software Corp. |
//+------------------------------------------------------------------+

#property copyright "Copyright  2010, Tarakan Software Corp."
#property version   "1.00"

//---

input     double  TakeProfit       = 10;          // TakeProfit  
input     double  PipStep          = 30;          //    
input     double  Lots             = 0.10;        //   
input     int     LotDecimal       = 1;           //       
input     double  LotExponent      = 1.70;        //    
input     int     MagicNumber      = 70707;       //   
input     int     MaxTrades        = 8;           //    
input     int     Slip             = 3;           // 

/*input*/ bool    UseEquityStop    = false;       //    
/*input*/ double  TotalEquityRisk  = 50.0;        //       
                                                  //    

/*input*/ bool    UseTimeOut       = false;       //      
/*input*/ double  MaxTradeOpenHours = 48;         //      

//+------------------------------------------------------------------+

double     Spread;
string     ExpertName = "Ilan_mql5";
datetime   Expiration;
double     LotSize;
int        i = 0, Total;
bool       TradeNow = false, LongTrade = false, ShortTrade = false;
int        Ticket = 0;
bool       NewOrdersPlaced = false;
double     LastBuyPrice, LastSellPrice;
double     iTakeProfit, iPipStep;
long       PositionID = 0;     //   

bool       Position = false;   // true -   , false - 
double     OpenPrice;          //   

double     OldOpenPrice = 0;   //    

MqlTick          LastPrices;   //      
MqlTradeRequest  Request;      //      OrderSend()
MqlTradeResult   Result;       //      

//+------------------------------------------------------------------+

int OnInit()
  {
    Spread = NormalizeDouble(SymbolInfoDouble(Symbol(), SYMBOL_ASK)
                           - SymbolInfoDouble(Symbol(), SYMBOL_BID), _Digits);
    
    iTakeProfit = TakeProfit;
    iPipStep = PipStep;
    
    //      - 
    if (_Digits == 5 || _Digits == 3)
      {
        iTakeProfit = TakeProfit * 10;
        iPipStep = PipStep * 10;
      }
    
    return(0);
  }
  
//+------------------------------------------------------------------+

void OnDeinit(const int reason)
  {
    return;
  }
  
//+------------------------------------------------------------------+

void OnTick()
  {
    //       
    
    if (UseTimeOut && TimeCurrent() >= Expiration)
      {
        Print("   ,   ");
        ClosePosition();  //  
      }
   
    //---------------------------------
    
    //       
    //            
    
    // long TickVolume[1];  //      
    
    //      
    // if (CopyTickVolume(_Symbol, _Period, 0, 1, TickVolume) != 1)
    //  {
    //    Print("       ");
    //    return;
    //  }
    
    //        - 
    // if (TickVolume[0] > 1) return;
    
    //---------------------------------
    
    //     

    if (UseEquityStop)
      {
        //   TotalEquityRisk ( )   -  
        double AccountEquity = AccountInfoDouble(ACCOUNT_EQUITY);
        double AccountBalance = AccountInfoDouble(ACCOUNT_BALANCE);
        
        if (AccountEquity <= AccountBalance * (1 - TotalEquityRisk / 100))
          {
            Print(" ", TotalEquityRisk, "% ,   ");
            ClosePosition();
          }
      }
   
    //---------------------------------
    
    //       
    
    if (!PositionSelect(_Symbol))    //   
      {
        Position = false;
      }
    else  //   
      {
        Position = true;
        PositionID = PositionGetInteger(POSITION_IDENTIFIER); //  
      }
    
    //---------------------------------
    
    //    
    
    if (Position)  //    
      {
        if (PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_BUY)  //  Buy
          {
            LongTrade = true;
            ShortTrade = false;
          }
        if (PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_SELL)  //  Sell
          {
            LongTrade = false;
            ShortTrade = true;
          }
      }
     
    //---------------------------------------
    
    //      
    
    if (Position) Total = CountTrades(PositionID);
    else Total = 0;
    
    //---------------------------------------
    
    //    PipStep    -   
    
    if (Position && (Total > 0 && Total <= MaxTrades))
      {
        //      Buy    Sell
        LastBuyPrice = FindLastBuyPrice(PositionID);
        LastSellPrice = FindLastSellPrice(PositionID);
        
        if (SymbolInfoTick(_Symbol, LastPrices))  //   LastPrices  
          {
            if (LongTrade && LastBuyPrice - LastPrices.ask >= iPipStep * _Point)  //   
              TradeNow = true;
          
            if (ShortTrade && LastPrices.bid - LastSellPrice >= iPipStep * _Point) //   
              TradeNow = true;
          }
      }  // if (Total > 0 && Total <= MaxTrades)
      
    //---------------------------------------
    
    //     -   
      
    if (!Position)
      {
        ShortTrade = false;
        LongTrade = false;
        TradeNow = true;
        //StartEquity = AccountEquity();
      }
      
    //-----------------------------------
    
    //   
      
    if (Position && TradeNow)
      {
        //    
        LotSize = NormalizeDouble(Lots * MathPow(LotExponent, Total), LotDecimal);
          
        //   Request   
        //      Request.price  Request.type
        Request.action       = TRADE_ACTION_DEAL;  //   
        Request.symbol       = _Symbol;            //  
        Request.volume       = LotSize;            //  
        Request.sl           = 0;                  // StopLoss
        Request.tp           = 0;                  // TakeProfit
        Request.deviation    = Slip;               // 
        Request.type_filling = ORDER_FILLING_AON;  //    
        Request.magic        = MagicNumber;        //  
        
        //   LastPrices  
        if (!SymbolInfoTick(_Symbol, LastPrices))
          {
            Print("     ");
            return;
          }
        
        //-----------
        
        if (ShortTrade)  // Sell - 
          {
            Request.price = ND(LastPrices.bid);      //  
            Request.type = ORDER_TYPE_SELL;          //  
            
            //  
            if (!OrderSend(Request, Result))
              {
                Print("    Sell,   ", Result.retcode);
                return;
              }
                
            TradeNow = false;
            NewOrdersPlaced = true;  //   
          }
        else if (LongTrade)  // Buy - 
          {
            Request.price = ND(LastPrices.ask);     //  
            Request.type = ORDER_TYPE_BUY;          //  
            
            //  
            if (!OrderSend(Request, Result))
              {
                Print("   ,   ", Result.retcode);
                return;
              }
                
            TradeNow = false;
            NewOrdersPlaced = true;  //   
          }
      }  // if (TradeNow)
    
    //-------------------------------
    
    //    
     
   if (!Position && TradeNow)  //    
      {
        //         
        //         
        MqlRates Rates[1];
        
        //     (   1)
        if (CopyRates(_Symbol, _Period, 1, 1, Rates) != 1)
          {
            Print("       ");
            return;
          }
        
        if (!ShortTrade && !LongTrade)
          {
            //    
            LotSize = NormalizeDouble(Lots * MathPow(LotExponent, Total), LotDecimal);
          
            //   Request   
            //      Request.price  Request.type
            Request.action       = TRADE_ACTION_DEAL;  //   
            Request.symbol       = _Symbol;            //  
            Request.volume       = LotSize;            //  
            Request.sl           = 0;                  // StopLoss
            Request.tp           = 0;                  // TakeProfit
            Request.deviation    = Slip;               // 
            Request.type_filling = ORDER_FILLING_AON;  //    
            Request.magic        = MagicNumber;        //  
            
            //   LastPrices  
            if (!SymbolInfoTick(_Symbol, LastPrices))
              {
                Print("     ");
                return;
              }
            
            //------------
            
            if (Rates[0].open > Rates[0].close)  //     - 
              {
                //     Request
                Request.price = ND(LastPrices.bid);      //  
                Request.type = ORDER_TYPE_SELL;          //  
                
                //  
                if (!OrderSend(Request, Result))
                  {
                    Print("   ,   ", Result.retcode);
                    return;
                  }
                    
                NewOrdersPlaced = true;  //   
              }
            else  //     - 
              {
                //     Request
                Request.price = ND(LastPrices.ask);     //  
                Request.type = ORDER_TYPE_BUY;          //  
                
                //       
                if (!OrderSend(Request, Result))
                  {
                    Print("   ,   ", Result.retcode);
                    return;
                  }
                  
                NewOrdersPlaced = true;  //   
              }
          }  // if (!ShortTrade && !LongTrade)
        
        if (NewOrdersPlaced)
          Expiration = (datetime)(TimeCurrent() + PeriodSeconds(PERIOD_H1) * MaxTradeOpenHours);
          
        TradeNow = false;
      }  // if (!Position && TradeNow)
     
    //----------------------------
    
    //  TakeProfit   
    
    if (NewOrdersPlaced)
      {
        //   
        if (!PositionSelect(_Symbol)) return;  //   
      
        OpenPrice = PositionGetDouble(POSITION_PRICE_OPEN);  //   
        
        //       - 
        if (OpenPrice == OldOpenPrice) return;
    
        //        Request
        Request.symbol    = _Symbol;            //  
        Request.action    = TRADE_ACTION_SLTP;  //  
        Request.sl        = 0;                  // StopLoss
        Request.deviation = Slip;               // 
    
        if (PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_BUY)  //   Buy
          Request.tp = ND(OpenPrice + iTakeProfit * _Point);  //   TakeProfit
      
        if (PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_SELL)  //   Sell
          Request.tp = ND(OpenPrice - iTakeProfit * _Point);  //   TakeProfit
    
        //  TakeProfit
        if (!OrderSend(Request, Result))
          {
            Print("   TakeProfit,   ", Result.retcode);
            return;
          }
          
        // TakeProfit   -     
        //          
        OldOpenPrice = OpenPrice;
        
        NewOrdersPlaced = false;
      }
        
    return; 
  }  // --- Exit OnTick() function ---
  
  
//+------------------------------------------------------------------+

//    ,   PositionID

int CountTrades(long PositionID)
  {
    int  Total;       //    
    long Ticket;      //     
    long PosID;       //  ,     
    long Magic;       //  
    int  Count = 0;   //   
  
    //     ,   
    HistorySelect(0, TimeCurrent());
    
    //       ,      
    Total = HistoryOrdersTotal(); //    
    
    for (i = 0; i < Total; i++)
      {
        Ticket = HistoryOrderGetTicket(i);  //    
        PosID  = HistoryOrderGetInteger(Ticket, ORDER_POSITION_ID);  //   
        Magic  = HistoryOrderGetInteger(Ticket, ORDER_MAGIC);        //   
        if (PosID == PositionID && Magic == MagicNumber) //     
          Count++;                                       //    
      }
      
    return(Count);
  }
  
//+------------------------------------------------------------------+

//      

void ClosePosition()
  {
    int i;
  
    if (!PositionSelect(_Symbol)) return; //   
  
    double LotSize = PositionGetDouble(POSITION_VOLUME);  //  
    long Type = PositionGetInteger(POSITION_TYPE);        //  
    
    //     Request   
    Request.action       = TRADE_ACTION_DEAL;  //   
    Request.symbol       = _Symbol;            //  
    Request.volume       = LotSize;            //  
    Request.sl           = 0;                  // StopLoss
    Request.tp           = 0;                  // TakeProfit
    Request.deviation    = Slip;               // 
    Request.type_filling = ORDER_FILLING_AON;  //    
    
    //   LastPrices  
    if (!SymbolInfoTick(_Symbol, LastPrices)) 
      {
        Print("     ");
        return;
      }
    
    //    
    if (Type == POSITION_TYPE_BUY)  // Buy   Bid
      {
        Request.price = LastPrices.bid;    //  
        Request.type = ORDER_TYPE_SELL;  //  
      }
    else if (Type == POSITION_TYPE_SELL)  // Sell   Ask
      {
        Request.price = LastPrices.ask;    //  
        Request.type = ORDER_TYPE_BUY;   //  
      }
    
    for (i = 0; i < 5; i++) //    
      {
        if (!OrderSend(Request, Result))
          {
            Sleep(1000);  // 
            if (!SymbolInfoTick(_Symbol, LastPrices)) //   
              {
                Print("     ");
                return;
              }
            
            //     Request  
            if (Type == POSITION_TYPE_BUY) Request.price = LastPrices.bid;
            else if (Type == POSITION_TYPE_SELL) Request.price = LastPrices.ask;
          }
        else
          {
            break;
          }
      }
        
    if (i == 5) Print("   ,   ", Result.retcode);
  }
  
//+------------------------------------------------------------------+

//      Buy
//     PositionID

double FindLastBuyPrice(long PositionID)
  {
    int  Total;              //    
    long Ticket;             //     
    long OldTicket = 0;      //    
    long PosID;              //  ,     
    long Magic;              //  
    long Type;               //    (Buy  Sell)
    double OrderPrice = 0;   //  
    
    //     ,   
    HistorySelect(0, TimeCurrent());
    
    Total = HistoryOrdersTotal(); //    
    
    //       ,      
    for (i = 0; i < Total; i++)
      {
        Ticket = HistoryOrderGetTicket(i);  //    
        PosID  = HistoryOrderGetInteger(Ticket, ORDER_POSITION_ID);  //  
        Magic  = HistoryOrderGetInteger(Ticket, ORDER_MAGIC);        //   
        Type   = HistoryOrderGetInteger(Ticket, ORDER_TYPE);         //  
            
        //          Buy
        if ((PosID == PositionID) && (Magic == MagicNumber) && (Type == ORDER_TYPE_BUY))
          {
            if (Ticket > OldTicket)  //        
              {
                OrderPrice = HistoryOrderGetDouble(Ticket, ORDER_PRICE_OPEN); //   
                OldTicket = Ticket; //  
              }
          }
      }
      
    return(OrderPrice);
  }
  
//+------------------------------------------------------------------+

//      Sell
//     PositionID

double FindLastSellPrice(long PositionID)
  {
    int  Total;             //    
    long Ticket;            //     
    long OldTicket = 0;     //    
    long PosID;             //  ,     
    long Magic;             //  
    long Type;              //    (Buy  Sell)
    double OrderPrice = 0;  //  
    
    //     ,   
    HistorySelect(0, TimeCurrent());
    
    Total = HistoryOrdersTotal(); //    
    
    //       ,      
    for (i = 0; i < Total; i++)
      {
        Ticket = HistoryOrderGetTicket(i);  //    
        PosID  = HistoryOrderGetInteger(Ticket, ORDER_POSITION_ID);  //  
        Magic  = HistoryOrderGetInteger(Ticket, ORDER_MAGIC);        //   
        Type   = HistoryOrderGetInteger(Ticket, ORDER_TYPE);         //  
        
        if ((PosID == PositionID) && (Magic == MagicNumber) && (Type == ORDER_TYPE_SELL)) 
          {
            if (Ticket > OldTicket)  //       
              {
                OrderPrice = HistoryOrderGetDouble(Ticket, ORDER_PRICE_OPEN); //   
                OldTicket = Ticket; //  
              }
          }
      }
      
    return(OrderPrice);
  }
  
//+------------------------------------------------------------------+

//    

double ND(double price)
  {
    return(NormalizeDouble(price, _Digits));
  }

//-------------------------------------------------------------------+