
//+------------------------------------------------------------------+
//|                                                      T3_TRIX.mq4 |
//|                          Copyright c 2006, Gordago Software Ltd. |
//|                                           http://www.gordago.com |
//+------------------------------------------------------------------+
#property copyright "Copyright c 2006, Gordago Software Ltd."
#property link      "http://www.gordago.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 DeepSkyBlue 
#property indicator_color2 Blue

extern int AT3Period = 18;
extern int BT3PeriodAC = 10;
extern double Hot=0.7;

int _countBars = 350;

double ExtMapBuffer1[];
double ExtMapBuffer2[];

int init() {
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,ExtMapBuffer2);
   return(0);
}

int deinit() {
   return(0);
}

int start() {

   int  shift=0;
   double A_t3=0, A_t3_1=0, max_per=0;
   double B_t3=0,B_t3_1=0;
   double e1=0,e2=0,e3=0,e4=0,e5=0,e6=0,c1=0,c2=0,c3=0,c4=0;
   double e1x=0,e2x=0,e3x=0,e4x=0,e5x=0,e6x=0;
   double d1=0,d2=0,d3=0,d4=0,d5=0,d6=0;
   double d1x=0,d2x=0,d3x=0,d4x=0,d5x=0,d6x=0;
   double n=0,A_w1=0,A_w2=0,B_w1=0,B_w2=0,b2=0,b3=0;
   bool init=true;
   double bar=0, prevbars=0, start=0, cs=0, prevcs=0,frame=0; 
   int    counted_bars=IndicatorCounted();

   cs = _countBars + AT3Period + BT3PeriodAC +  Hot;

   if (cs==prevcs && frame==Time[4]-Time[5] && Bars-prevbars<2)
      start=Bars-prevbars;
   else 
      start=-1;   
   
   frame=Time[4]-Time[5];
   prevbars = Bars;
   prevcs = cs;   
   
   if (start==1 || start==0)  
      bar=start; 
   else 
      init=true;

   if (init==true){
      b2=Hot*Hot;
      b3=b2*Hot;
      c1=-b3;
      c2=(3*(b2+b3));
      c3=-3*(2*b2+Hot+b3);
      c4=(1+3*Hot+b3+3*b2);
 
      n=AT3Period;

      if (n<1) n=1;
 
      n = 1 + 0.5*(n-1);
      A_w1 = 2 / (n + 1);
      A_w2 = 1 - A_w1;

      n = BT3PeriodAC;

      if (n<1) n=1;
      n = 1 + 0.5*(n-1);
      B_w1 = 2 / (n + 1);
      B_w2 = 1 - B_w1;

      ExtMapBuffer1[_countBars-1]=0;

      e1x=0;e2x=0;e3x=0;e4x=0;e5x=0;e6x=0;

      ExtMapBuffer2[_countBars-1]=0;

      d1x=0;d2x=0;d3x=0;d4x=0;d5x=0;d6x=0;

      bar=_countBars-2;
      init=false;
   }

   shift=bar;

   while(shift>=0){

      d1 = A_w1*Close[shift] + A_w2*d1x;
         
      d2 = A_w1*d1 + A_w2*d2x;
      d3 = A_w1*d2 + A_w2*d3x;
      d4 = A_w1*d3 + A_w2*d4x;
      d5 = A_w1*d4 + A_w2*d5x;
      d6 = A_w1*d5 + A_w2*d6x;

      A_t3 = c1*d6 + c2*d5 + c3*d4 + c4*d3;
 
      if ((start==1 && shift==1) || start==-1  ){ 
         d1x=d1; d2x=d2; d3x=d3; d4x=d4; d5x=d5; d6x=d6;
      }
      e1 = B_w1*Close[shift] + B_w2*e1x;
      e2 = B_w1*e1 + B_w2*e2x;
      e3 = B_w1*e2 + B_w2*e3x;
      e4 = B_w1*e3 + B_w2*e4x;
      e5 = B_w1*e4 + B_w2*e5x;
      e6 = B_w1*e5 + B_w2*e6x;
      B_t3 = c1*e6 + c2*e5 + c3*e4 + c4*e3;

      if ( B_t3_1 >0 && A_t3_1>0) {
         ExtMapBuffer1[shift]=(A_t3-A_t3_1)/A_t3_1;
         ExtMapBuffer2[shift]=(B_t3-B_t3_1)/B_t3_1;
      }
      if ((start==1 && shift==1) || start==-1) { 
         A_t3_1=A_t3;
         B_t3_1=B_t3;
         e1x=e1; e2x=e2; e3x=e3; e4x=e4; e5x=e5; e6x=e6;
      }
      shift--;
   }
}
	