//+------------------------------------------------------------------+
//|                                                           slavas |
//|                                          http://www.groshi.at.ua |
//+------------------------------------------------------------------+

#property copyright "slavas"
#property link      "http://www.groshi.at.ua"

#define MIN_STOPLOSS_POINT 10 
#define MIN_TAKEPROFIT_POINT 10 
#define MAGIC 2222

extern double StopLoss = 0;
extern double TakeProfit = 0;
extern double TrailingStop = 4;
extern double Lots=0.1;
extern int Slippage = 0;
extern bool lFlagUseHourTrade = False;
extern int nFromHourTrade = 3;
extern int nToHourTrade = 23;
extern bool lFlagUseSound = False;
extern string sSoundFileName = "alert.wav";
extern color colorOpenBuy = Blue;
extern color colorCloseBuy = Aqua;
extern color colorOpenSell = Red;
extern color colorCloseSell = Aqua;

double dLots = 0.10; 

void deinit() {
   Comment("");
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start(){
   
   if (lFlagUseHourTrade){
      if (!(Hour()>=nFromHourTrade && Hour()<=nToHourTrade)) {
         Comment("Time for trade has not come else!");
         return(0);
      }
   }
   
   if(Bars < 100){
      Print("bars less than 100");
      return(0);
   }
   
   
   if((StopLoss > 0 && StopLoss < MIN_STOPLOSS_POINT)){
      Print("StopLoss less than " + MIN_STOPLOSS_POINT);
      return(0);
   }
   if((TakeProfit > 0 && TakeProfit < MIN_TAKEPROFIT_POINT)){
      Print("TakeProfit less than " + MIN_TAKEPROFIT_POINT);
      return(0);
   }

   double diCustom0=iCustom(NULL, 1, "RFTL", Close, 0, 0);
double diSAR1=iSAR(NULL,1,0.001,0.02,0);
double diSAR2=iSAR(NULL,1,0.001,0.02,0);
double diCustom3=iCustom(NULL, 1, "RFTL", Close, 0, 0);


   if(AccountFreeMargin() < (1000*Lots)){
      Print("We have no money. Free Margin = " + AccountFreeMargin());
      return(0);
   }
   
   bool lFlagBuyOpen = false, lFlagSellOpen = false, lFlagBuyClose = false, lFlagSellClose = false;
   
   lFlagBuyOpen = (diCustom0>diSAR1);
   lFlagSellOpen = (diSAR2>diCustom3);
   lFlagBuyClose = False;
   lFlagSellClose = False;
   
   if (!ExistPositions()){

      if (lFlagBuyOpen){
         OpenBuy();
         return(0);
      }

      if (lFlagSellOpen){
         OpenSell();
         return(0);
      }
   }
   if (ExistPositions()){
      if(OrderType()==OP_BUY){
         if (lFlagBuyClose){
            bool flagCloseBuy = OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, colorCloseBuy); 
            if (flagCloseBuy && lFlagUseSound) 
               PlaySound(sSoundFileName); 
            return(0);
         }
      }
      if(OrderType()==OP_SELL){
         if (lFlagSellClose){
            bool flagCloseSell = OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, colorCloseSell); 
            if (flagCloseSell && lFlagUseSound) 
               PlaySound(sSoundFileName); 
            return(0);
         }
      }
   }
   
   if (TrailingStop > 0 ){
      
      for (int i=0; i<OrdersTotal(); i++) { 
         if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) { 
            bool lMagic = true;
            if (MAGIC > 0 && OrderMagicNumber() != MAGIC)
               lMagic = false;
            
            if (OrderSymbol()==Symbol() && lMagic) { 
               if (OrderType()==OP_BUY && TrailingStop > 0) { 
                  if (Bid-OrderOpenPrice() > TrailingStop*Point) { 
                     if (OrderStopLoss()<Bid-TrailingStop*Point) 
                        ModifyStopLoss(Bid-TrailingStop*Point); 
                  } 
               } 
               if (OrderType()==OP_SELL) { 
                  if (OrderOpenPrice()-Ask>TrailingStop*Point) { 
                     if (OrderStopLoss()>Ask+TrailingStop*Point || OrderStopLoss()==0)  
                        ModifyStopLoss(Ask+TrailingStop*Point); 
                  } 
               } 
            } 
         } 
      } 
   }
   return (0);
}

bool ExistPositions() {
	for (int i=0; i<OrdersTotal(); i++) {
		if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
         bool lMagic = true;
         
         if (MAGIC > 0 && OrderMagicNumber() != MAGIC)
            lMagic = false;

			if (OrderSymbol()==Symbol() && lMagic) {
				return(True);
			}
		} 
	} 
	return(false);
}

void ModifyStopLoss(double ldStopLoss) { 
   bool lFlagModify = OrderModify(OrderTicket(), OrderOpenPrice(), ldStopLoss, OrderTakeProfit(), 0, CLR_NONE); 
   if (lFlagModify && lFlagUseSound) 
      PlaySound(sSoundFileName); 
} 

void OpenBuy() { 
   double dStopLoss = 0, dTakeProfit = 0;

   if (StopLoss > 0)
      dStopLoss = Bid-StopLoss*Point;
   
   if (TakeProfit > 0)
     dTakeProfit = Ask + TakeProfit * Point; 
 
   
   int numorder = OrderSend(Symbol(), OP_BUY, Lots, Ask, Slippage, StopLoss, TakeProfit, "ParabolRFTL", MAGIC, 0, colorOpenBuy); 
   
   if (numorder > -1 && lFlagUseSound) 
      PlaySound(sSoundFileName);
} 

void OpenSell() { 
   double dStopLoss = 0, dTakeProfit = 0;
   
   if (StopLoss > 0)
      StopLoss = Ask+StopLoss*Point;
   
   if (TakeProfit > 0)
      TakeProfit = Bid-TakeProfit*Point;
   
   int numorder = OrderSend(Symbol(),OP_SELL, Lots, Bid, Slippage, StopLoss, TakeProfit, "ParabolRFTL", MAGIC, 0, colorOpenSell); 
   
   if (numorder > -1 && lFlagUseSound) 
      PlaySound(sSoundFileName); 
} 

