//+------------------------------------------------------------------+
//|                                                           slavas |
//|                                         http://www.groshi.at.ua/ |
//+------------------------------------------------------------------+

#property copyright "slavas"
#property link      "http://www.groshi.at.ua"

#define MIN_STOPLOSS_POINT 10
#define MIN_TAKEPROFIT_POINT 10 
#define MAGIC 111

extern double StopLoss = 0;
extern double TakeProfit = 0;
extern double TrailingStop = 5;
extern double Lots = 0.10; 
extern int Slippage = 0;
extern bool lFlagUseHourTrade = False;
extern bool lFlagUseSound = True;
extern string sSoundFileName = "alert.wav";
extern color colorOpenBuy = Blue;
extern color colorCloseBuy = Aqua;
extern color colorOpenSell = Red;
extern color colorCloseSell = Aqua;


void deinit() {
   Comment("");
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start(){
   
   if(Bars < 100){
      Print("bars less than 100");
      return(0);
   }
   
   
   if((StopLoss > 0 && StopLoss < MIN_STOPLOSS_POINT)){
      Print("StopLoss less than " + MIN_STOPLOSS_POINT);
      return(0);
   }
   if((TakeProfit > 0 && TakeProfit < MIN_TAKEPROFIT_POINT)){
      Print("TakeProfit less than " + MIN_TAKEPROFIT_POINT);
      return(0);
   }

   double diMFI0=iMFI(NULL,1,13,0);
double diMFI1=iMFI(NULL,1,13,0);


   if(AccountFreeMargin() < (1000*Lots)){
      Print("We have no money. Free Margin = " + AccountFreeMargin());
      return(0);
   }
   
   bool lFlagBuyOpen = false, lFlagSellOpen = false, lFlagBuyClose = false, lFlagSellClose = false;
   
   lFlagBuyOpen = (diMFI0>70 );
   lFlagSellOpen = (diMFI1<20);
   lFlagBuyClose = False;
   lFlagSellClose = False;
   
   if (!ExistPositions()){

      if (lFlagBuyOpen){
         OpenBuy();
         return(0);
      }

      if (lFlagSellOpen){
         OpenSell();
         return(0);
      }
   }
   if (ExistPositions()){
      if(OrderType()==OP_BUY){
         if (lFlagBuyClose){
            bool flagCloseBuy = OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, colorCloseBuy); 
            if (flagCloseBuy && lFlagUseSound) 
               PlaySound(sSoundFileName); 
            return(0);
         }
      }
      if(OrderType()==OP_SELL){
         if (lFlagSellClose){
            bool flagCloseSell = OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, colorCloseSell); 
            if (flagCloseSell && lFlagUseSound) 
               PlaySound(sSoundFileName); 
            return(0);
         }
      }
   }
   
   if (TrailingStop > 0 || TrailingStop > 0){
      
      for (int i=0; i<OrdersTotal(); i++) { 
         if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) { 
            bool lMagic = true;
            if (MAGIC > 0 && OrderMagicNumber() != MAGIC)
               lMagic = false;
            
            if (OrderSymbol()==Symbol() && lMagic) { 
               if (OrderType()==OP_BUY && TrailingStop > 0) { 
                  if (Bid-OrderOpenPrice() > TrailingStop*Point) { 
                     if (OrderStopLoss()<Bid-TrailingStop*Point) 
                        ModifyStopLoss(Bid-TrailingStop*Point); 
                  } 
               } 
               if (OrderType()==OP_SELL) { 
                  if (OrderOpenPrice()-Ask>TrailingStop*Point) { 
                     if (OrderStopLoss()>Ask+TrailingStop*Point || OrderStopLoss()==0)  
                        ModifyStopLoss(Ask+TrailingStop*Point); 
                  } 
               } 
            } 
         } 
      } 
   }
   return (0);
}

bool ExistPositions() {
	for (int i=0; i<OrdersTotal(); i++) {
		if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
         bool lMagic = true;
         
         if (MAGIC > 0 && OrderMagicNumber() != MAGIC)
            lMagic = false;

			if (OrderSymbol()==Symbol() && lMagic) {
				return(True);
			}
		} 
	} 
	return(false);
}

void ModifyStopLoss(double ldStopLoss) { 
   bool lFlagModify = OrderModify(OrderTicket(), OrderOpenPrice(), ldStopLoss, OrderTakeProfit(), 0, CLR_NONE); 
   if (lFlagModify && lFlagUseSound) 
      PlaySound(sSoundFileName); 
} 

void OpenBuy() { 
   double dStopLoss = 0, dTakeProfit = 0;

   if (StopLoss > 0)
      StopLoss = Bid-StopLoss*Point;
   
   if (TakeProfit > 0)
     TakeProfit = Bid + TakeProfit * Point; 
   
   int numorder = OrderSend(Symbol(), OP_BUY, Lots, Ask, Slippage, StopLoss, TakeProfit, "MFI", MAGIC, 0, colorOpenBuy); 
   
   if (numorder > -1 && lFlagUseSound) 
      PlaySound(sSoundFileName);
} 

void OpenSell() { 
   double StopLoss = 0, TakeProfit = 0;
   
   if (StopLoss > 0)
      StopLoss = Ask+StopLoss*Point;
   
   if (TakeProfit > 0)
      TakeProfit = Ask-TakeProfit*Point;
   
   int numorder = OrderSend(Symbol(),OP_SELL, Lots, Bid, Slippage, StopLoss, TakeProfit, "MFI", MAGIC, 0, colorOpenSell); 
   
   if (numorder > -1 && lFlagUseSound) 
      PlaySound(sSoundFileName); 
} 

