#property copyright " 2009 +"
#property link      "http://www.fxcoder.ru"

//   ,    ,    , 
//           :)


#import "vlib.dll"

//  
int vlib_SmoothHistogram(double& vh[], int hCount, int smooth);

//  
int vlib_GetVolumeHistogram(double& iopen[], double& ihigh[], double& ilow[], double& iclose[], double& ivolume[], 
	int icount, int tickMethod, double point, double hLow, int hCount, double& vh[]);

#import

// +Volume

///       time1   time2 (    time2)
///		volumePeriod -  
/// 	smooth -  (       )
/// :
///		 -    , 0 - 
///		vh - 
///		startPrice -   
int GetVolumeHG(datetime time1, datetime time2, int tickMethod, double& vh[], double& hLow)
{
	//      DLL
	int shift1, shift2;	// shift2 > shift1, time1 > time2
	if (!GetShiftRange(time1, time2, shift1, shift2))
		return(0);

	double iopen[], ihigh[], ilow[], iclose[], ivolume[];
	double hHigh;
	

	//  ( )  
	int iCount = GetM1Data(shift1, shift2, iopen, ihigh, ilow, iclose, ivolume, hLow, hHigh);

	if (iCount != 0)
	{
		//   
		int hCount = hHigh/Point - hLow/Point + 1;
	
		//Print("hLow: " + d2s(hLow) + ", hHigh: " + d2s(hHigh) + ", iCount: " + iCount + ", hCount: " + hCount);
	
		ArrayResize(vh, hCount);
		ArrayInitialize(vh, 0);

		int hc = vlib_GetVolumeHistogram(iopen, ihigh, ilow, iclose, ivolume, iCount, tickMethod, Point, hLow, hCount, vh);

		if (hc == hCount)
			return(hc);
		else
			return(0);
	}
	else
		return(0);
}


// M1

int GetM1Data(int shift1, int shift2, double& iopen[], double& ihigh[], double& ilow[], double& iclose[], double& ivolume[], double& ilowest, double& ihighest)
{
	//  ( )  
	int iCount = shift2 - shift1 + 1;

	ArrayResize(iopen, iCount);
	ArrayResize(ihigh, iCount);
	ArrayResize(ilow, iCount);
	ArrayResize(iclose, iCount);
	ArrayResize(ivolume, iCount);

	//   
	int k = 0;
	double min = 0, max = 0;
	for (int j = shift1; j <= shift2; j++)
	{
		double v = iVolume(Symbol(), PERIOD_M1, j);
	
		if (v != 0)
		{
			ivolume[k] = v;

			iopen[k] = iOpen(Symbol(), PERIOD_M1, j);
			ihigh[k] = iHigh(Symbol(), PERIOD_M1, j);
			ilow[k] = iLow(Symbol(), PERIOD_M1, j);
			iclose[k] = iClose(Symbol(), PERIOD_M1, j);

			if ((min == 0) || (ilow[k] < min))
				min = ilow[k];
		
			if ((max == 0) || (ihigh[k] > max))
				max = ihigh[k];
		
			k++;
		}
		else
		{
			k = 0;
			break;
		}
	
	}
	
	iCount = k;
	ArrayResize(iopen, iCount);
	ArrayResize(ihigh, iCount);
	ArrayResize(ilow, iCount);
	ArrayResize(iclose, iCount);
	ArrayResize(ivolume, iCount);

	ilowest = min;
	ihighest = max;
	
//	Print("min: " + d2s(min) + ", max: " + d2s(max));
	
	return(iCount);
}


// +2D

int DeleteObjectsByPrefix(string prefix)
{
	int obj_total = ObjectsTotal();
	string name;
	
	int count = 0;
	for (int i = obj_total - 1; i >= 0; i--)
	{
		name = ObjectName(i);
		if (StringFind(name, prefix) == 0)
		{
			ObjectDelete(name);
			count++;
		}			
	}
	return(count);
}

void DrawTrend(string name, datetime time1, double price1, datetime time2, double price2, color lineColor = Gray, int width = 1, int style = STYLE_SOLID, bool back = true, bool ray = true, int window = 0)
{
	if (ObjectFind(name) >= 0)
		ObjectDelete(name);
	ObjectCreate(name, OBJ_TREND, window, time1, price1, time2, price2);
	ObjectSet(name, OBJPROP_COLOR, lineColor);
	ObjectSet(name, OBJPROP_BACK, back);
	ObjectSet(name, OBJPROP_STYLE, style);
	ObjectSet(name, OBJPROP_WIDTH, width);
	ObjectSet(name, OBJPROP_RAY, ray);
}

void DrawVLine(string name, datetime time1, color lineColor = Gray, int width = 1, int style = STYLE_SOLID, bool back = true)
{
	if (ObjectFind(name) >= 0)
		ObjectDelete(name);
	ObjectCreate(name, OBJ_VLINE, 0, time1, 0);
	ObjectSet(name, OBJPROP_COLOR, lineColor);
	ObjectSet(name, OBJPROP_BACK, back);
	ObjectSet(name, OBJPROP_STYLE, style);
	ObjectSet(name, OBJPROP_WIDTH, width);
}


void DrawHLine(string name, double price, color lineColor = Gray, int width = 1, int style = STYLE_SOLID, bool back = true)
{
	if (price > 0)
	{
		if (!ObjectSet(name, OBJPROP_PRICE1, price))
		{
			if (ObjectCreate(name, OBJ_HLINE, 0, 0, price))
			{
				ObjectSet(name, OBJPROP_COLOR, lineColor);
				ObjectSet(name, OBJPROP_WIDTH, width);
				ObjectSet(name, OBJPROP_STYLE, style);
				ObjectSet(name, OBJPROP_BACK, back);
			}
		}
		else
		{
			ObjectSet(name, OBJPROP_COLOR, lineColor);
			ObjectSet(name, OBJPROP_WIDTH, width);
			ObjectSet(name, OBJPROP_STYLE, style);
			ObjectSet(name, OBJPROP_BACK, back);
		}
	}
	else
	{
		ObjectDelete(name);
	}	
}

datetime GetObjectTime1(string name)
{
	datetime time = 0;
	int wi = ObjectFind(name);
	if (wi != -1)
		time = ObjectGet(name, OBJPROP_TIME1);

	return(time);
}


void DrawText(string name, string text, datetime time, double price, string font, int fontSize, color textColor, bool back = true, double angle = 0, int window = 0)
{
	if (ObjectFind(name) >= 0)
		ObjectDelete(name);
	ObjectCreate(name, OBJ_TEXT, window, time, price);
	ObjectSetText(name, text, fontSize, font, textColor);
	ObjectSet(name, OBJPROP_BACK, back);
	ObjectSet(name, OBJPROP_ANGLE, angle);
}

void DrawRectangle(string name, datetime time1, double price1, datetime time2, double price2, color lineColor = Gray, int width = 1, int style = STYLE_SOLID, bool back = true)
{
	if (ObjectFind(name) >= 0)
		ObjectDelete(name);
	ObjectCreate(name, OBJ_RECTANGLE, 0, time1, price1, time2, price2);
	ObjectSet(name, OBJPROP_COLOR, lineColor);
	ObjectSet(name, OBJPROP_BACK, back);
	ObjectSet(name, OBJPROP_STYLE, style);
	ObjectSet(name, OBJPROP_WIDTH, width);
}

void DrawTriangle(string name, datetime time1, double price1, datetime time2, double price2, datetime time3, double price3, color lineColor = Gray, int width = 1, int style = STYLE_SOLID, bool back = true)
{
	if (ObjectFind(name) >= 0)
		ObjectDelete(name);
	ObjectCreate(name, OBJ_TRIANGLE, 0, time1, price1, time2, price2, time3, price3);
	ObjectSet(name, OBJPROP_COLOR, lineColor);
	ObjectSet(name, OBJPROP_BACK, back);
	ObjectSet(name, OBJPROP_STYLE, style);
	ObjectSet(name, OBJPROP_WIDTH, width);
}

void DrawHistogram(string prefix, double& h[], double low, datetime time, color lineColor, double zoom, int drawType = 0, int priceScale = 1.0, int width = 1)
{
	datetime time0 = time;
	int bar0 = GetShiftByTime(time0, PERIOD_M1);
	//Print(bar0);
	int digits = Digits;
//	if (digits == 5)
//		digits = 4;
//	if (digits == 3)
//		digits = 2;

	for (int i = 0; i < ArraySize(h) - 1; i++)
	{
		double price0 = NormalizeDouble(low + i*Point*priceScale, digits);
		double price1 = NormalizeDouble(low + (i+1)*Point*priceScale, digits) - Point/100.0;
		
		int bar1 = bar0 - h[i]*zoom / 60 ;
		int bar2 = bar0 - h[i+1]*zoom / 60 ;
		
		datetime time1 = GetTimeByShift(bar1, PERIOD_M1);// time + h[i]*zoom;
		datetime time2 = GetTimeByShift(bar2, PERIOD_M1);//time + h[i+1]*zoom;
		
		if (drawType == 0)
		{
			DrawTrend(prefix + price0, time0, price0, time1, price0, lineColor, width, STYLE_SOLID, true, false);
		}
		else
		{
			if (time1 > time2)
			{
				DrawTriangle(prefix + i + "_t", time1, price0, time2, price1, time1, price1, lineColor, 1, STYLE_SOLID, true);
			}
			else
			{
				DrawTriangle(prefix + i + "_t", time1, price0, time1, price1, time2, price1, lineColor, 1, STYLE_SOLID, true);
	///			DrawRectangle(prefix + i + "_r", time2, price0, time0, price1, lineColor, width, STYLE_SOLID, true);
			}

			DrawRectangle(prefix + i + "_r-" + h[i], time1, price0, time0, price1, lineColor, 1, STYLE_SOLID, true);

//		DrawTriangle(prefix + i + "_1", time0, price0, time1, price0, time0, price1, lineColor, width, STYLE_SOLID, true);
//		DrawTriangle(prefix + i + "_2", time1, price0, time2, price1, time0, price1, lineColor, width, STYLE_SOLID, true);
		}
		
	}
}

// +Period

string PeriodToStr(int period)
{
	if (period == PERIOD_M1)
		return("M1");
	else if (period == PERIOD_M5)
		return("M5");
	else if (period == PERIOD_M15)
		return("M15");
	else if (period == PERIOD_M30)
		return("M30");
	else if (period == PERIOD_H1)
		return("H1");
	else if (period == PERIOD_H4)
		return("H4");
	else if (period == PERIOD_D1)
		return("D1");
	else if (period == PERIOD_W1)
		return("W1");
	else if (period == PERIOD_MN1)
		return("MN1");
	else
		return("PERIOD_" + period);
}


datetime GetTimeByShift(int shift, int period = 0)
{
	if (period == 0)
		period = Period();

	if (shift >= 0)
		return(iTime(Symbol(), period, shift));
	else
		return(iTime(Symbol(), period, 0) - shift*period*60);
}

int GetShiftByTime(datetime time, int period = 0)
{
	if (period == 0)
		period = Period();

	int shift = iBarShift(Symbol(), period, time);
	int t = GetTimeByShift(shift, period);
	
	if (t != time) // && shift == 0 ???
		shift = (iTime(Symbol(), period, 0) - time) / 60 / period;

	return(shift);	
}

//   
datetime GetStartTime(int shift, int period = 0)
{
	if (period == 0)
		period = Period();
	
	datetime time = iTime(Symbol(), period, shift);
	datetime m1time = 0;
	
	//    
	for (int i = 0; i < period - 1; i++)
	{
		int m1 = iBarShift(Symbol(), PERIOD_M1, time + i*60, true);
		if (m1 != -1)
		{
			m1time = time + i*60;
			break;
		}
	}
//	Print("start_" + shift + "#" + TimeToStr(m1time));
	return(m1time);
}


//   
datetime GetEndTime(int shift, int period = 0)
{
	if (period == 0)
		period = Period();
	
	datetime m1time = 0;
	if (shift == 0)
	{
		m1time = iTime(Symbol(), PERIOD_M1, 0);
	}
	else
	{
		datetime time = iTime(Symbol(), period, shift);
	
		//    
		for (int i = period - 1; i > 0; i--)
		{
			int m1 = iBarShift(Symbol(), PERIOD_M1, time + i*60, true);
			if (m1 != -1)
			{
				m1time = time + i*60;
				break;
			}
		}
	}
	
	//Print("end_" + shift + "#" + TimeToStr(m1time));
	return(m1time);
}


// +Period

bool GetShiftRange(datetime time1, datetime time2, int& shift1, int& shift2)
{
	if (time1 >= time2)
		return(false);
	
	//    ()
	shift1 = iBarShift(Symbol(), PERIOD_M1, time2 - 60.0, true); //    
	while (shift1 == -1)
	{
		shift1 = iBarShift(Symbol(), PERIOD_M1, time2 - 60.0);
		time2 = iTime(Symbol(), PERIOD_M1, shift1);
	}

	if (time1 >= time2 || shift1 == -1)
		return(false);
		
	//    ()
	shift2 = iBarShift(Symbol(), PERIOD_M1, time1, true);
	while (shift2 == -1)
	{
		shift2 = iBarShift(Symbol(), PERIOD_M1, time1);
		time1 = iTime(Symbol(), PERIOD_M1, shift2);
	}
		
	if (time1 >= time2 || shift2 == -1)
		return(false);
	
	//Print("time1: " + TimeToStr(time1) + ", time2: " + TimeToStr(time2) + ", shift1: " + shift1 + ", shift2: " + shift2);
	
	return(true);
}

// +Series

bool IsMax(int shift, bool weak = false)
{
	double p1 = High[shift + 1];
	double p2 = High[shift];
	double p3 = High[shift - 1];

	if (weak)
		return(p2 >= p1 && p2 >= p3);
	else
		return(p2 > p1 && p2 > p3);
}

bool IsMin(int shift, bool weak = false)
{
	double p1 = Low[shift + 1];
	double p2 = Low[shift];
	double p3 = Low[shift - 1];

	if (weak)
		return(p2 <= p1 && p2 <= p3);
	else
		return(p2 < p1 && p2 < p3);
}


// +HG

void SmoothHistogram(double& h[], int smooth)
{
	if (smooth > 0)
		vlib_SmoothHistogram(h, ArraySize(h), smooth);
}

///        
int GetModesIndexes(double& vh[], double& svh[], int smooth, int& modes[], bool smoothed = false) //, int& maxModeIndex
{
	int mCount = 0;

	int m[];
	ArrayResize(m, 0);

	int count = ArraySize(vh);
	
	//     
	for (int i = 1; i < count - 1; i++)
	{
		int depth = smooth;
		if ((svh[i] >= svh[i+1]) && (svh[i] >= svh[i-1]))
		{
			if (smoothed)
			{
				mCount++;
				ArrayResize(m, mCount);
				m[mCount-1] = i;
			}
			else
			{
				//        
				int k = ArrayMaximum(vh, 2*smooth + 1, i-smooth);
			
				//     modes
				for (int j = i - smooth; j <= i + smooth; j++)
				{
					if (vh[j] == vh[k])
					{
						mCount++;
						ArrayResize(m, mCount);
						m[mCount-1] = j;
					}
				}
			}
		}
	}
	
	ArrayResize(modes, 0);
	int modeCount = 0;	
	
	//  
	for (i = 0; i < mCount; i++)
	{
		bool d = false;
		
		for (j = 0; j < modeCount; j++)
		{
			if (m[i] == modes[j])
			{
				d = true;
				break;
			}
		}
		
		if (!d)
		{
			modeCount++;
			ArrayResize(modes, modeCount);
			modes[modeCount-1] = m[i];
		}
	}
	
	//Print(m[0]);
	//Print(m[1]);
	return(modeCount);
}


