#property copyright "Volume Levels v16.  2009 +"
#property link      "http://www.fxcoder.ru"

#property indicator_chart_window


extern string c1 = "+++   +++";

extern int RangeMode = 0;						//   : 0 -   , 1 -  RangeMinutes , 
												// 2 = RangeMinutes  , 3 -      

extern int RangeMinutes = 1440;					//     (    )

extern int Smooth = 100;						//   ,   2   + 1
int TickMethod = 9;								//   . 0 - Low >> High, 1 - Open > Low(High) > High(Low) > Close, 2 - OHLC
												// +4 -   , +8 -      

int MaxModeCount = 0;							//   , 0 -  
int MaxSmooth = 500;							//    MaxModeCount > 0


extern string c2 = "+++  +++";

extern color HistogramColor = C'32,32,32';		//  
extern int HistogramLineWidth = 1;				//   
extern int HistogramPosition = 1;				// 0 - window left, 1 - window right, 2 - left side, 3 - right side, //TODO: 4 - 

extern double Zoom = 0;							//  , 0 - 
extern int DrawType = 0;						// 0 -  (,  ), 1 -  (,  )
extern bool DrawSmoothed = false;				//  


extern string c3 = "+++  +++";

extern bool ShowModes = true;					//  

extern color ModeColor = C'96,0,0';				//  
extern int ModeWidth = 1;						//  
extern int ModeStyle = STYLE_SOLID;				//  

extern bool ShowSmoothedModes = false;			//    
extern color SmoothedModeColor = C'64,64,64';	//    
extern int SmoothedModeStyle = STYLE_SOLID;		//    

extern bool ShowMaxMode = true;
extern color MaxModeColor = Red;
extern int MaxModeWidth = 1;
extern int MaxModeStyle = STYLE_SOLID;


extern string c4 = "+++  +++";

extern bool ShowMaxModeLevel = true;
extern color MaxModeLevelColor = LimeGreen;
extern int MaxModeLevelWidth = 1;
extern int MaxModeLevelStyle = STYLE_DOT;

extern bool ShowModeLevels = true;				//    
extern color ModeLevelColor = DarkGreen;		//   
extern color SmoothedModeLevelColor = DimGray;	//     
extern int ModeLevelWidth = 1;					// 
extern int ModeLevelStyle = STYLE_DOT;			// 


extern string c5 = "+++  +++";

extern string TimeLine1Name = "vl1";			//   -   
extern string TimeLine2Name = "vl2";			//   -   
extern string ObjectNamePrefix = "+vl";			//    


//#include <+HG.mqh>
//#include <+Volume.mqh>
#include <+MPVL.mqh>

int start()
{
	//   
	DeleteObjectsByPrefix(ObjectNamePrefix + "_");

	//   
	
	datetime time1, time2;	// time1 < time2
	
	if (RangeMode == 0)
	{
		time1 = GetObjectTime1(TimeLine1Name);
		time2 = GetObjectTime1(TimeLine2Name);

		if (time1 == 0 || time2 == 0)
		{
			//     ,       
			datetime timeLeft = GetTimeByShift(WindowFirstVisibleBar());
			datetime timeRight = GetTimeByShift(WindowFirstVisibleBar() - WindowBarsPerChart());
			double r = timeRight - timeLeft;
			
			time1 = timeLeft + r / 3;
			time2 = timeLeft + r * 2 / 3;

			DrawVLine(TimeLine1Name, time1, RoyalBlue, 1, STYLE_DASH, false);
			DrawVLine(TimeLine2Name, time2, Crimson, 1, STYLE_DASH, false);
		}

		if (time1 > time2)
		{
			datetime dt = time2;
			time2 = time1;
			time1 = dt;
		}
	}
	else if (RangeMode == 2)
	{
		time2 = GetObjectTime1(TimeLine2Name);

		if (time2 == 0)
		{
			//     ,      
			timeLeft = GetTimeByShift(WindowFirstVisibleBar());
			timeRight = GetTimeByShift(WindowFirstVisibleBar() - WindowBarsPerChart());
			r = timeRight - timeLeft;
			
			time2 = GetTimeByShift(MathMax(0, WindowFirstVisibleBar() - WindowBarsPerChart() + 20));//timeLeft + r / 2;
			
		}

		time1 = time2 - RangeMinutes*60;

		DrawVLine(TimeLine1Name, time1, Blue, 1, STYLE_DASH, false);
		DrawVLine(TimeLine2Name, time2, Red, 1, STYLE_DASH, false);
	}
	else if (RangeMode == 1)
	{
		time1 = iTime(Symbol(), PERIOD_M1, RangeMinutes);	// 
		time2 = Time[0];
		
		//DrawVLine(TimeLine1Name, time1, Gray, 1, STYLE_SOLID, true);
		//DrawVLine(TimeLine2Name, time2, Gray, 1, STYLE_SOLID, true);
	}
	else if (RangeMode == 3)
	{
		time2 = GetObjectTime1(TimeLine2Name);

		if (time2 == 0)
		{
			//     ,      
			timeLeft = GetTimeByShift(WindowFirstVisibleBar());
			timeRight = GetTimeByShift(WindowFirstVisibleBar() - WindowBarsPerChart());
			r = timeRight - timeLeft;
			
			time2 = timeLeft + r / 2;
			
		}
		
		
		//  
		int i2 = iBarShift(Symbol(), Period(), time2);
		
		int i1 = i2 + 1;
		for (int i = i2 + 2; i < 777; i++)
		{
			bool max = IsMax(i);
			bool min = IsMin(i);
			if ((max && !min) || (min && !max))
			{
				i1 = i;
				break;
			}
			
		}
		time1 = iTime(Symbol(), Period(), i1);

		DrawVLine(TimeLine1Name, time1, Blue, 1, STYLE_DASH, false);
		DrawVLine(TimeLine2Name, time2, Red, 1, STYLE_DASH, false);
	}
	else
	{
		return(0);
	}

	if (GetShiftByTime(time2) < 0)
		time2 = iTime(Symbol(), PERIOD_M1, 0);
	if (GetShiftByTime(time1) < 0)
		time1 = iTime(Symbol(), PERIOD_M1, 0);

	ObjectSetText(TimeLine1Name, TimeToStr(time1), 0);
	ObjectSetText(TimeLine2Name, TimeToStr(time2), 0);

	int range = RangeMinutes;
	if (RangeMode == 0)
	{
		int bar1 = GetShiftByTime(time1);
		int bar2 = GetShiftByTime(time2);
		
		range = (bar1 - bar2)*Period(); // (time2-time1) / 60
	}
	
	//  
	double vh[], svh[], low;

	//int count = _obs_GetVolumeHistogram(time1, time2, VolumePeriod, vh, low, TickMethod);
	int count = GetVolumeHG(time1, time2, TickMethod, vh, low);
	//Print("vh count: " + count);

	//Comment(TimeToStr(time1) + "\n" + TimeToStr(time2) + "\n" + DoubleToStr(low, Digits) + "\n" + range);
	//Comment(low);

	if (count == 0)
	{
		Print("Error: count = 0");
		return(0);
	}
	
	// 
	int smooth = Smooth;
	ArrayResize(svh, count);
	if (MaxModeCount == 0)
	{
		ArrayCopy(svh, vh);
		SmoothHistogram(svh, Smooth);
	}
	else
	{
		for (int s = 0; s < MaxSmooth; s++)
		{
			smooth = s;		
			ArrayCopy(svh, vh);
			SmoothHistogram(svh, smooth);

			//  		
			int modes[], modeCount;
			modeCount = GetModesIndexes(vh, svh, smooth, modes, false);

			if (modeCount <= MaxModeCount)
				break;
		}
//		Print(smooth);
	}

	int rp;
	datetime time0;

	double windowTimeRange = WindowBarsPerChart()*Period()*60;
	rp = windowTimeRange*0.1;	//     

	double zoom = Zoom;
	if (zoom == 0)
		zoom = rp / vh[ArrayMaximum(vh)];
	
	
	if (HistogramPosition == 0)	// left
	{
		time0 = GetTimeByShift(WindowFirstVisibleBar());
	}
	else if (HistogramPosition == 1)	// window right
	{
		time0 = GetTimeByShift(WindowFirstVisibleBar() - WindowBarsPerChart());
		zoom = -zoom;	//  
	}
	else if (HistogramPosition == 2)	// left side
	{
		time0 = time1;
		zoom = -zoom;	//  
	}
	else // right side
	{
		time0 = time2;
	}


	// 	
	if (DrawSmoothed)
		DrawHistogram(ObjectNamePrefix + "_hist_", svh, low, time0, HistogramColor, zoom, DrawType, 1, HistogramLineWidth);
	else
		DrawHistogram(ObjectNamePrefix + "_hist_", vh, low, time0, HistogramColor, zoom, DrawType, 1, HistogramLineWidth);
	
	//    
	if (ShowSmoothedModes)
		drawModes(ObjectNamePrefix + "_", vh, svh, low, time0, zoom, smooth, true);

	if (ShowModes)
		drawModes(ObjectNamePrefix + "_", vh, svh, low, time0, zoom, smooth, false);

	if (ShowMaxMode)
	{
		int pmax[];
		int pmaxCount = GetPmax(vh, pmax);
		for (int j = 0; j < pmaxCount; j++)
		{
			double price = low + pmax[j]*Point;
			double v = zoom * vh[pmax[j]];

			DrawTrend(ObjectNamePrefix + "_pmax_" + TimeToStr(time1) + "_" + j, time0, price, time0 + v, price, MaxModeColor, MaxModeWidth, MaxModeStyle, false, false);

			if (ShowMaxModeLevel)
				DrawHLine(ObjectNamePrefix + "_pmax_level", price, MaxModeLevelColor, MaxModeLevelWidth, MaxModeLevelStyle, true);
		}
	}

	
	//Print(low);
	
	return(0);
}

int init()
{
	return(0);
}

int deinit()
{
	DeleteObjectsByPrefix(ObjectNamePrefix + "_");
//	DeleteObjectsByPrefix(TimeLine1Name);
//	DeleteObjectsByPrefix(TimeLine2Name);
	return(0);
}


void drawModes(string prefix, double& vh[], double& svh[], double low, datetime time1, double zoom, int smooth, bool smoothed)
{
	int modes[], modeCount;
	double price;

	modeCount = GetModesIndexes(vh, svh, smooth, modes, smoothed);
	string sm = "";
	int style = ModeStyle;
	color cl = ModeColor;
	if (smoothed)
	{
		sm = "_sm";
		style = SmoothedModeStyle;
		cl = SmoothedModeColor;
	}
	
	//Print(modeCount);
	for (int j = 0; j < modeCount; j++)
	{
		price = low + modes[j]*Point;

		double v = zoom*vh[modes[j]];
		if (smoothed)
			v = zoom*svh[modes[j]];

		//    ,  -    
		//if (MathAbs(v) > Period()*60)
		{
			string name = prefix + "mode" + sm + "_" + TimeToStr(time1) + "_" + j;
		
			DrawTrend(name, time1, price, time1 + v, price, cl, ModeWidth, style, smoothed, false);
		
			if (ShowModeLevels)
			{
				if (smoothed)
					DrawHLine(name + "_level", price, SmoothedModeLevelColor, ModeLevelWidth, ModeLevelStyle, true);
				else
					DrawHLine(name + "_level", price, ModeLevelColor, ModeLevelWidth, ModeLevelStyle, true);
			}
		}
	}
}

int GetPmax(double& vh[], int& pmax[]) //, int& maxModeIndex
{
	int count = 0;
	
	int k = ArrayMaximum(vh);
	
	for (int i = 0; i < ArraySize(vh); i++)
	{
		if (vh[i] == vh[k])
		{
			count++;
			ArrayResize(pmax, count);
			pmax[count-1] = i;
		}
	}
	
	return(count);
}


