#property copyright "Market Profile v16.  2009 +"
#property link      "http://www.fxcoder.ru"

#property indicator_chart_window


extern string c1 = "+++   +++";

extern int RangePeriod = PERIOD_D1;				//  ,     
extern int RangeCount = 20;						//  /

extern int Smooth = 100;						//   ,   2   + 1
int TickMethod = 9;								//   . 0 - Low >> High, 1 - Open > Low(High) > High(Low) > Close, 2 - OHLC
												// +4 -   , +8 -      

extern string c2 = "+++  +++";

extern bool ShowHistogram = true;				//  
extern bool ShowLast = true;					//     (  )

extern color HistogramColor = C'32,32,32';		//  
extern int HistogramLineWidth = 1;				//   


extern double Zoom = 0;							//  , 0 - 
extern int DrawType = 0;						// 0 -  (,  ), 1 -  (,  )
extern bool DrawSmoothed = false;				//  


extern string c3 = "+++  +++";

extern bool ShowModes = true;					//  

extern color ModeColor = C'96,0,0';				//  
extern int ModeWidth = 1;						//  
extern int ModeStyle = STYLE_SOLID;				//  

extern bool ShowSmoothedModes = false;			//    
extern color SmoothedModeColor = C'64,64,64';	//    
extern int SmoothedModeStyle = STYLE_SOLID;		//    

extern bool ShowMaxMode = true;
extern color MaxModeColor = Red;
extern int MaxModeWidth = 1;
extern int MaxModeStyle = STYLE_SOLID;


extern string c4 = "+++  +++";

extern string ObjectNamePrefix = "+mp_";			//   
extern int WaitSeconds = 15;						// ,  ,  


//#include <+HG.mqh>
//#include <+Volume.mqh>
#include <+MPVL.mqh>

datetime lastTime, lt;
datetime drawHistory[];

int init()
{
	ArrayResize(drawHistory, 0);
}

int start()
{
	datetime tc = TimeCurrent();
	
	int countedRanges = ArraySize(drawHistory);
	if (Volume[0] > 1)// && countedRanges == RangeCount - 1
	{
		//   ,    15 ,   
		if (tc - lt < WaitSeconds)
		{
			//Print(WindowExpertName() + ": waiting..." + (countedRanges));
			return(0);
		}
	}

	if (tc < Time[0])
	{
		Print("  " + PeriodToStr(Period()) + "...");
		return(0);
	}
	
	//if (iTime(Symbol(), VolumePeriod, 0) < Time[0])
	//{
	//	Print("  " + PeriodToStr(VolumePeriod) + "...");
	//	return(0);
	//}
	//Print(" .");
	
	//Print("working..." + (countedRanges));
	lt = tc;

	datetime time1, time2;
	double vh[], low;
	for (int i = 1 - ShowLast; i < RangeCount; i++)
	{
		time1 = GetStartTime(i, RangePeriod);
		if (i == 0)
			time2 = Time[0];
		else
			time2 = GetEndTime(i, RangePeriod);
			
		string ndon = ObjectNamePrefix + "no_data_" + TimeToStr(time1);
		
		
		if (!checkDrawHistory(time1) || i == 0)
		{
			int count = GetVolumeHG(time1, time2, TickMethod, vh, low);
			if (count > 0)
			{
				DeleteObjectsByPrefix(ndon);
				double svh[];
				ArrayResize(svh, count);
				ArrayCopy(svh, vh);
				SmoothHistogram(svh, Smooth);

				{
					//Print("Drawing..." + i);
					if (i != 0)
						addDrawHistory(time1);

					//  
					double zoom = Zoom;
					if (Zoom <= 0)
					{
						double maxVolume = vh[ArrayMaximum(vh)];
						zoom = ((time2-time1)*1) / maxVolume;
					}
					//Print(vh[ArrayMaximum(vh)]);

					// 
					if (ShowHistogram)
					{
						if (DrawSmoothed)
							DrawHistogram(ObjectNamePrefix + RangePeriod + "_" + "histsm_" + TimeToStr(time1) + "_", svh, low, time1, HistogramColor, zoom, DrawType, 1, HistogramLineWidth);
						else
							DrawHistogram(ObjectNamePrefix + RangePeriod + "_" + "histsm_" + TimeToStr(time1) + "_", vh, low, time1, HistogramColor, zoom, DrawType, 1, HistogramLineWidth);
					}

					//  
					if (ShowSmoothedModes)
						drawModes(vh, svh, low, time1, time2, zoom, true);

					if (ShowModes)
						drawModes(vh, svh, low, time1, time2, zoom, false);
				
					// Pmax
					DeleteObjectsByPrefix(ObjectNamePrefix + RangePeriod + "_" + "pmax_" + TimeToStr(time1) + "_");
					if (ShowMaxMode)
					{
						int pmax[];
						int pmaxCount = GetPmax(vh, pmax);
						for (int j = 0; j < pmaxCount; j++)
						{
							double price = low + pmax[j]*Point;
							DrawTrend(ObjectNamePrefix + RangePeriod + "_" + "pmax_" + TimeToStr(time1) + "_" + j, time1, price, time2, price, MaxModeColor, MaxModeWidth, MaxModeStyle, false, false);
						}
					}
			}
			}
			else
			{
				string s = " ";
				int sh = iBarShift(Symbol(), RangePeriod, time1);
				price = (iLow(Symbol(), RangePeriod, sh) + iHigh(Symbol(), RangePeriod, sh)) / 2;
				DrawText(ndon, s, time1 + 23*RangePeriod, price, "Arial", 14, Gray, true, 45);
				//Print("   " + TimeToStr(time1) + ".   " + PeriodToStr(VolumePeriod) + " .");// + (low)); //TimeToStr			
			}
		}
	}
	//Print(ArraySize(drawHistory));

	return(0);
}

int deinit()
{
	DeleteObjectsByPrefix(ObjectNamePrefix);
	return(0);
}

// ,      
bool checkDrawHistory(datetime time)
{
	int count = ArraySize(drawHistory);
	bool r = false;
	for (int i = 0; i < count; i++)
	{
		if (drawHistory[i] == time)
		{
			r = true;
			break;
		}
	}
	return(r);
}

void addDrawHistory(datetime time)
{
	if (!checkDrawHistory(time))
	{
		int count = ArraySize(drawHistory);
		ArrayResize(drawHistory, count + 1);
		drawHistory[count] = time;
	}
}

int GetPmax(double& vh[], int& pmax[]) //, int& maxModeIndex
{
	int count = 0;
	
	int k = ArrayMaximum(vh);
	
	for (int i = 0; i < ArraySize(vh); i++)
	{
		if (vh[i] == vh[k])
		{
			count++;
			ArrayResize(pmax, count);
			pmax[count-1] = i;
		}
	}
	
	return(count);
}

void drawModes(double& vh[], double& svh[], double low, datetime time1, datetime time2, double zoom, bool smoothed)
{
	int modes[], modeCount, j;
	double price;

	// 
	modeCount = GetModesIndexes(vh, svh, Smooth, modes, smoothed);
	string sm = "";
	int style = ModeStyle;
	color cl = ModeColor;
	if (smoothed)
	{
		sm = "sm";
		style = SmoothedModeStyle;
		cl = SmoothedModeColor;
	}
	
	
	// 
	for (j = 0; j < modeCount; j++)
	{
		price = low + modes[j]*Point;
		//if (ShowHistogram)
		{
			double v = zoom*vh[modes[j]];
			if (smoothed)
				v = zoom*svh[modes[j]];

			DrawTrend(ObjectNamePrefix + RangePeriod + "_" + "mode" + sm + "_" + TimeToStr(time1) + "_" + j, time1, price, time1 + v, price, cl, ModeWidth, style, smoothed, false);
		}
		//else
		{
		//	DrawTrend(ObjectNamePrefix + RangePeriod + "_" + "mode" + sm + "_" + TimeToStr(time1) + "_" + j, time1, price, time2, price, cl, ModeLineWidth, ModeLineStyle, smoothed, false);
		}
	}
}


