library vlib;

uses
  Math,
  vlTickUtils in 'vlTickUtils.pas',
  vlClasses in 'vlClasses.pas',
  vlUtils in 'vlUtils.pas';

const
    EMPTY_VALUE: Integer = $7FFFFFFF;

{$R *.res}

//     ().  -  . 
function vlib_GetVolumeHistogram(const iopen: TSeries; const ihigh: TSeries; const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries;
  iCount: Integer; tickMethod: Integer; point: Double; hLow: Double; hCount: Integer; const vh: TSeries): Integer; stdcall; export;

var
  i, pri, oi, hi, li, ci, hLowI, hgi: Integer;
  price, o, h, l, c, v, vhl: Double;

begin
    // 1.   
    hLowI := Round(hLow / point);

    for i := 0 to iCount - 1 do
    begin
        o := iopen[i];
        oi := Round(o/point);

        h := ihigh[i];
        hi := Round(h/point);

        l := ilow[i];
        li := Round(l/point);

        c := iclose[i];
        ci := Round(c/point);

        v := ivolume[i];

        vhl := v / (h - l + 1);

        if tickMethod = 0 then				//     
        begin
            for pri := li to hi do
            begin
                hgi := pri - hLowI;
                vh[hgi] := vh[hgi] + vhl;
            end;
        end
        else if tickMethod = 1 then			//  
        begin
        	if c >= o then					//  
            begin
                // open --> low
                for pri := oi downto li do
                    vh[pri - hLowI] := vh[pri - hLowI] + v;

                // low+1 ++> high
                for pri := li + 1 to hi do
                    vh[pri - hLowI] := vh[pri - hLowI] + v;

                // high-1 --> close
                for pri := hi - 1 downto ci do
                    vh[pri - hLowI] := vh[pri - hLowI] + v;
            end
            else   							//  
        	begin
                // open ++> high
                for pri := oi to hi do
                    vh[pri - hLowI] := vh[pri - hLowI] + v;

                // high-1 --> low
                for pri := hi - 1 downto li do
                    vh[pri - hLowI] := vh[pri - hLowI] + v;

                // low+1 ++> close
                for pri := li + 1 to ci do
                    vh[pri - hLowI] := vh[pri - hLowI] + v;
            end;
        end
        else if tickMethod = 2 then		//   
        begin
			vh[oi - hLowI] := vh[oi - hLowI] + v;
			vh[hi - hLowI] := vh[hi - hLowI] + v;
			vh[li - hLowI] := vh[li - hLowI] + v;
			vh[ci - hLowI] := vh[ci - hLowI] + v;
        end
        else if tickMethod = 4 then		//
        begin
            for pri := li to hi do
            begin
                hgi := pri - hLowI;
                vh[hgi] := vh[hgi] + 1;
            end;
        end
        else if tickMethod = 5 then			//  
        begin
        	if c >= o then					//  
            begin
                // open --> low
                for pri := oi downto li do
                    vh[pri - hLowI] := vh[pri - hLowI] + 1;

                // low+1 ++> high
                for pri := li + 1 to hi do
                    vh[pri - hLowI] := vh[pri - hLowI] + 1;

                // high-1 --> close
                for pri := hi - 1 downto ci do
                    vh[pri - hLowI] := vh[pri - hLowI] + 1;
            end
            else   							//  
        	begin
                // open ++> high
                for pri := oi to hi do
                    vh[pri - hLowI] := vh[pri - hLowI] + 1;

                // high-1 --> low
                for pri := hi - 1 downto li do
                    vh[pri - hLowI] := vh[pri - hLowI] + 1;

                // low+1 ++> close
                for pri := li + 1 to ci do
                    vh[pri - hLowI] := vh[pri - hLowI] + 1;
            end;
        end
        else if tickMethod = 6 then		//   
        begin
			vh[oi - hLowI] := vh[oi - hLowI] + 1;
			vh[hi - hLowI] := vh[hi - hLowI] + 1;
			vh[li - hLowI] := vh[li - hLowI] + 1;
			vh[ci - hLowI] := vh[ci - hLowI] + 1;
        end
        else if tickMethod = 8 then		//
        begin
            for pri := li to hi do
            begin
                hgi := pri - hLowI;
                vh[hgi] := vh[hgi] + vhl;
            end;
        end
        else if tickMethod = 9 then			//  
        begin
        	if c >= o then					//  
            begin
                // open --> low
                for pri := oi downto li do
                    vh[pri - hLowI] := vh[pri - hLowI] + vhl;

                // low+1 ++> high
                for pri := li + 1 to hi do
                    vh[pri - hLowI] := vh[pri - hLowI] + vhl;

                // high-1 --> close
                for pri := hi - 1 downto ci do
                    vh[pri - hLowI] := vh[pri - hLowI] + vhl;
            end
            else   							//  
        	begin
                // open ++> high
                for pri := oi to hi do
                    vh[pri - hLowI] := vh[pri - hLowI] + vhl;

                // high-1 --> low
                for pri := hi - 1 downto li do
                    vh[pri - hLowI] := vh[pri - hLowI] + vhl;

                // low+1 ++> close
                for pri := li + 1 to ci do
                    vh[pri - hLowI] := vh[pri - hLowI] + vhl;
            end;
        end
        else if tickMethod = 10 then		//   
        begin
			vh[oi - hLowI] := vh[oi - hLowI] + vhl;
			vh[hi - hLowI] := vh[hi - hLowI] + vhl;
			vh[li - hLowI] := vh[li - hLowI] + vhl;
			vh[ci - hLowI] := vh[ci - hLowI] + vhl;
        end
        ;
    end;

    Result := hCount;
end;

//      . .
function vlib_SmoothHistogram(const vh: TSeries; hCount: Integer; smooth: Integer): Integer; stdcall; export;
var
  avc, sum, price: Double;
  a: TSeries;
  i, j: Integer;
begin
    if (smooth > 0) then
    begin
        avc := smooth * 2 + 1;
    
        SetLength(a, hCount);

    for i := 0 to hCount - 1 do
      a[i] := vh[i];  //TODO:            

    for i := 0 to hCount - 1 do
    begin
        sum := 0;
        for j := i - smooth to i + smooth do
        begin
            price := 0;

            if ((j >= 0) and (j < hCount)) then
                price := a[j];

               sum := sum + price;
        end;

        vh[i] := sum / avc;
    end;
    
  end;
  
  Result := 0;
end;

//     ().  -  . .
function vlib_GetVolumeLevels(

	// 
	const iopen: TSeries; const ihigh: TSeries; const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries; icount: Integer;

    point: Double;				// 

    // 
    const vMA: TSeries;			// 
    const vHigh: TSeries;		//  
    const vLow: TSeries;		//  
    const vMax: TSeries;		//  
    oCount: Integer				//   
    
    ): Integer; stdcall; export;
    
var
  hLow, bp, e, downSum, upSum, err, avc, sum, price: Double;
  vh: TSeries;
  hCount, rCount, i, j, k, bi: Integer;
  modes: TIntSeries;
  mi, mCount: Integer;
  
begin
  rCount := iCount - oCount + 1;

  for i := 0 to oCount - 1 do
  begin
    //     i..i+rCount-1
    hCount := GetVolumeHistogram(iopen, ihigh, ilow, iclose, ivolume, i, rCount, point, vh, hLow);

    bi := 0;
    err := -1;
    for j := 1 to hCount - 2 do
    begin
        downSum := 0;
        upSum := 0;

        for k := 0 to j - 1 do
            downSum := downSum + vh[k];

        for k := j + 1 to hCount - 1 do
            upSum := upSum + vh[k];

        e := Abs(upSum - downSum);

        if (err <> -1) then
        begin
            if (e > err) then
            begin
                bi := j - 1;
                break;
            end
            else
            begin
                err := e;
            end;
        end
        else
        begin
            err := e;
        end;

    end;

    if (bi <> 0) then
        vMA[i] := hLow + bi*point
    else
        vMA[i] := 0;

    //  
    mCount := GetModes(vh, modes);
    if mCount > 0 then
    begin
        vlow[i] := hLow + modes[0]*point;
        vhigh[i] := hLow + modes[mCount - 1]*point;
    end
    else
    begin
        vhigh[i] := 0;
        vlow[i] := 0;
    end;

    mi := -1;
    //  
    for k := 0 to hCount - 1 do
    begin
        if (mi = -1) or (vh[k] > vh[mi]) then
            mi := k;
    end;

    if mi <> -1 then
        vmax[i] := hLow + mi*point
    else
        vmax[i] := 0;

  end;

  Result := 0;
end;

//      ().  -  . .
//TODO:  , ..    ,   .
function vlib_GetStatValues(const iopen: TSeries; const ihigh: TSeries;
  const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries;
  icount: Integer; point: Double; const median: TSeries; oCount: Integer): Integer; stdcall; export;
var
  r, h, a, g, hLow, bp, e, downSum, upSum, err, avc, sum, price: Double;
  vh: TSeries;
  hCount, rCount, i, j, k, bi: Integer;
  modes: TIntSeries;
  mi, mCount: Integer;
  badH: boolean;
begin
  rCount := iCount - oCount + 1; //      

  for i := 0 to oCount - 1 do
  begin
    //     i..i+rCount-1
    hCount := GetVolumeHistogram(iopen, ihigh, ilow, iclose, ivolume, i, rCount, point, vh, hLow);

    // 
    bi := 0;
    err := -1;
    for j := 1 to hCount - 2 do
    begin
        downSum := 0;
        upSum := 0;

        for k := 0 to j - 1 do
            downSum := downSum + vh[k];

        for k := j + 1 to hCount - 1 do
            upSum := upSum + vh[k];

        e := Abs(upSum - downSum);

        if (err <> -1) then
        begin
            if (e > err) then
            begin
                bi := j - 1;
                break;
            end
            else
            begin
                err := e;
            end;
        end
        else
        begin
            err := e;
        end;

    end;

    if (bi <> 0) then
        median[i] := hLow + bi*point
    else
        median[i] := 0;

    //  ,  ,  
    a := 0;
    g := 1;
    h := 0;
    r := 0;
    badH := false;
    for j := 0 to hCount - 1 do
    begin
        a := a + vh[j];

        if ((vh[j] <> 0) and not badH) then
        begin
	        h := h + 1/ vh[j];
        end
        else
    	begin
            badH := true;
        end;

        g := g * Power(vh[j], 1/hCount);

        r := r + vh[j]*vh[j];
    end;
    a := a / hCount;
    if badH then
    	h := EMPTY_VALUE
    else
	    h := h / hCount;
        
    r := r / hCount;

    //median[i] := r;



    //  
    

  end;

  Result := 0;
end;

//      ().  -  . 
//TODO:
//******************************
function vlib_GetVolumeModes(const iopen: TSeries; const ihigh: TSeries; const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries;
  iCount: Integer; tickMethod: Integer; point: Double; hLow: Double; hCount: Integer; const vh: TSeries): Integer; stdcall; export;

var
  i, pri, li, hi, hLowI, hgi: Integer;
  price, h, l, v: Double;

begin
	// 1.  .
    //TODO:....


    hLowI := Round(hLow / point);

    for i := 0 to iCount - 1 do
    begin
        h := ihigh[i];
        hi := Round(h/point);

        l := ilow[i];
        li := Round(l/point);

        v := ivolume[i];

        // tickMethod = 0 //TODO:  
        for pri := li to hi do
        begin
        	hgi := pri - hLowI;
            vh[hgi] := vh[hgi] + v;
        end;
    end;

    Result := hCount;
end;


exports
  vlib_GetVolumeHistogram,
  vlib_SmoothHistogram,
  vlib_GetVolumeLevels,
  vlib_GetStatValues,
  vlib_GetVolumeModes;

begin
end.
