unit vlUtils;

interface

uses
	vlClasses;

//    
function GetModes(const vh: TSeries; var modes: TIntSeries): Integer;

//     ().  -  .
function GetVolumeHistogram(const iopen: TSeries; const ihigh: TSeries;
  const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries;
  start: Integer; rCount: Integer; point: Double; var vh: TSeries; var hLow: Double): Integer;


implementation

//    
function GetModes(const vh: TSeries; var modes: TIntSeries): Integer;
var
    i, j, k, hCount, modeCount, mCount: Integer;
    m: TIntSeries;
    d: Boolean;
begin
    mCount := 0;

    SetLength(m, 0);

    hCount := Length(vh);

    //    
    for i := 1 to hCount - 2 do
    begin
        if ((vh[i] >= vh[i+1]) and (vh[i] >= vh[i-1])) then
        begin
            Inc(mCount);
            SetLength(m, mCount);
            m[mCount-1] := i;
        end;
    end;

    SetLength(modes, 0);
    modeCount := 0;

    //  
    for i := 0 to mCount - 1 do
    begin
        d := False;

        for j := 0 to modeCount - 1 do
        begin
            if (m[i] = modes[j]) then
            begin
                d := True;
                break;
            end;
        end;

        if (not d) then
        begin
            Inc(modeCount);
            SetLength(modes, modeCount);
            modes[modeCount-1] := m[i];
        end;
    end;


    Result := modeCount;
end;

//     ().  -  .
function GetVolumeHistogram(const iopen: TSeries; const ihigh: TSeries;
  const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries;
  start: Integer; rCount: Integer; point: Double; var vh: TSeries; var hLow: Double): Integer;
var
  pc, i, j, hCount, pri, li, hi, hLowI: Integer;
  price, min, max, h, l, v: Double;
begin
	//TODO:   -    ,    

    // 1.   
    min := 0;
    max := 0;
    for i := start to start + rCount - 1 do
    begin
        if (max = 0) or (ihigh[i] > max) then
            max := ihigh[i];

        if (min = 0) or (ilow[i] < min) then
            min := ilow[i];
    end;

    hLow := min;
    hLowI := Round(hLow / point);

    hCount := Round((max - min)/point) + 1;

    SetLength(vh, hCount);
    for i := 0 to hCount - 1 do
        vh[i] := 0;

    for i := start to start + rCount - 1 do
    begin
        h := ihigh[i];
        hi := Round(h/point);

        l := ilow[i];
        li := Round(l/point);

        v := ivolume[i];

        for pri := li to hi do
        begin
            price := l + pri*point;

            vh[pri - hLowI] := vh[pri - hLowI] + v;
        end;
    end;

    Result := hCount;
end;




end.
