unit vlTickUtils;

interface

uses
	vlClasses, Math;

function getTicks(const iopen: TSeries; const ihigh: TSeries; const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries;
  iCount: Integer; start: Integer; imin: Double; imax: Double; tickMethod: Integer; digits: Integer; var ticks: TSeries; var vh: TSeries): Integer;

implementation

function getTicks(const iopen: TSeries; const ihigh: TSeries; const ilow: TSeries; const iclose: TSeries; const ivolume: TSeries;
  iCount: Integer; start: Integer; imin: Double; imax: Double; tickMethod: Integer; digits: Integer; var ticks: TSeries; var vh: TSeries): Integer;

var
  c, tc, iminI, imaxI, k, j, hCount, tCount, i, pri, li, hi, hgi: Integer;
  t, hLow, hHigh, price, h, l, v: Double;
  pp: Integer;
begin
	pp := Round(Power(10, digits));
    iminI := Round(imin * pp);
    imaxI := Round(imax * pp);

    //  
    hCount := imaxI - iminI + 1;
    SetLength(vh, hCount);
    for i := 0 to hCount - 1 do
        vh[i] := 0;

    //  
    tCount := iCount*4; //  
    SetLength(ticks, tCount);
    k := 0;	//  

    for i := start to start + iCount - 1 do
    begin
        h := ihigh[i];
        hi := Round(h * pp);

        l := ilow[i];
        li := Round(l * pp);

        v := ivolume[i];

        c := (hi - li + 1);	//    

        if (tCount - k < c * 100) then
        begin
            tCount := tCount + c*100;
            SetLength(ticks, tCount);
        end;
        
        // tickMetod = 0	//TODO:  
        for pri := li to hi do
        begin
        	// 
            hgi := pri - iminI;
        	vh[hgi] := vh[hgi] + v;

            // 
            t := pri / pp;
            ticks[k] := t;
            Inc(k);
        end;
    end;
    tCount := k;
    SetLength(ticks, tCount);

    Result := tCount;
end;

end.
