//+------------------------------------------------------------------+
//|                                                     mtvoice.mq4   |
//|      Copyright  2010, Zaitsev Vadim, TradingForge Software Team. |
//|                                       http://www.tradingforge.com |
//+------------------------------------------------------------------+

#property copyright "Copyright  2011, Zaitsev Vadim, TradingForge Software Team."
#property link      "http://www.tradingforge.com"
#property indicator_chart_window

extern string opened_buy_msg   = "[side] [type] [lots] lots [symbol] is opened";

extern string opened_sell_msg  = "[side] [type] [lots] lots [symbol] is opened";  

extern string closed_buy_msg   = "[side] [type] [symbol] is closed. the [profitloss] is [gain] dollars [cgain] cents"; 

extern string closed_sell_msg  = "[side] [type] [symbol] is closed. the [profitloss] is [gain] dollars [cgain] cents";

extern string opened_pending_msg   = "[side] [type] [lots] lots [symbol] is opened"; 

extern string closed_pending_msg   = "[side] [type] [lots] lots [symbol] is deleted";  
 
int Pre_PosOrdersArray[];
int Pre_PosOrdersTotal = 0;

int Pre_PendOrdersArray[];
int Pre_PendOrdersTotal = 0;

string made = "MT Voice 1.0 @ www.tradingforge.com"; 
string icon = "MT Voice 1.0 @ www.tradingforge.com ";

datetime inittime;
int multiplier;

#import "mtvoice.dll"
   int    InitDll (string symbol,int timeframe);
   
   int    DeinitDll (string symbol, int timeframe, int reason);
  
   string Speak (int event_type, string format_msg, int type, double price, double qty, string symbol, double pl, double tp, double sl, string comments, int period, double balance, double equity, double margin, double freemargin, int digits, double point); 
#import

//+------------------------------------------------------------------+
//| Custom indicator initialization functions                         |
//+------------------------------------------------------------------+
int init()
{
   multiplier = 0.0001 / Point;  
   
   inittime = TimeCurrent();
   
   InitDll(Symbol(), Period());
   
   SavePositions();
   
   CreateLabel(made, "MT Voice 1.0", 8, "Arial", White, 18, 4, 3, 0);
   
   CreateLabel(icon, CharToStr(40), 10, "WingDings", White, 2, 4, 3, 0);
  
   return(0);
}

int deinit()
{
   DeinitDll(Symbol(), Period(), UninitializeReason()); 
   
   ObjectDelete(made);
   
   ObjectDelete(icon);
   
   return(0);
}

int start()
{   
   CheckPositions();
   
   SavePositions();
   
   return(0);
}

void CreateLabel(string name, string text, int fontsize, string fontname, color colr, int x_distance, int y_distance, int corner, int angle) 
{
   ObjectCreate(name, OBJ_LABEL, 0, 0, 0);
   ObjectSet(name, OBJPROP_XDISTANCE, x_distance);
   ObjectSet(name, OBJPROP_YDISTANCE, y_distance);
   ObjectSet(name, OBJPROP_BACK, FALSE);
   ObjectSet(name, OBJPROP_CORNER, corner);
   ObjectSet(name, OBJPROP_ANGLE, angle);
   ObjectSetText(name, text, fontsize, fontname, colr);
}

void HandleOpenBuyMarket(int ticket)
{
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true)
   {     
      if(StringLen(opened_buy_msg) > 0)
      {
         string msg = Speak(0, opened_buy_msg, OrderType(), OrderOpenPrice(),OrderLots(),OrderSymbol(), OrderProfit(),TakeProfitPoints(ticket),StopLossPoints(ticket),"", Period(), AccountBalance(), AccountEquity(), AccountMargin(), AccountFreeMargin(), Digits, Point);       
     
         Print(msg);
      }
   }
}

void HandleOpenSellMarket(int ticket)
{
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true)
   {     
      if(StringLen(opened_sell_msg) > 0)
      {
          string msg = Speak(0, opened_sell_msg, OrderType(), OrderOpenPrice(),OrderLots(),OrderSymbol(), OrderProfit(),TakeProfitPoints(ticket),StopLossPoints(ticket),"", Period(), AccountBalance(), AccountEquity(), AccountMargin(), AccountFreeMargin(), Digits, Point);       
      
          Print(msg);
      }
   }
}

void HandleCloseBuyMarket(int ticket)
{
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true)
   {	
      if(StringLen(closed_buy_msg) > 0)	
      {	
          string msg = Speak(1, closed_buy_msg,OrderType(), OrderClosePrice(),OrderLots(),OrderSymbol(),OrderProfit(),TakeProfitPoints(ticket),StopLossPoints(ticket),OrderComment(),Period(), AccountBalance(), AccountEquity(), AccountMargin(), AccountFreeMargin(), Digits, Point);          
      
          Print(msg);
      }
   }
}

void HandleCloseSellMarket(int ticket)
{
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true)
   {	
      if(StringLen(closed_sell_msg) > 0)	
      {	
          string msg = Speak(1, closed_sell_msg,OrderType(), OrderClosePrice(),OrderLots(),OrderSymbol(),OrderProfit(),TakeProfitPoints(ticket),StopLossPoints(ticket),OrderComment(),Period(), AccountBalance(), AccountEquity(), AccountMargin(), AccountFreeMargin(), Digits, Point);          
      
          Print(msg);
      }
   }
}


void HandleOpenPending(int ticket)
{
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true)
   {
      if(StringLen(opened_pending_msg) > 0)
      {
          string msg = Speak(2, opened_pending_msg,OrderType(), OrderOpenPrice(),OrderLots(),OrderSymbol(),OrderProfit(),TakeProfitPoints(ticket),StopLossPoints(ticket),"", Period(), AccountBalance(), AccountEquity(), AccountMargin(), AccountFreeMargin(), Digits, Point);             
      
          Print(msg);
      }
   }
}

void HandleClosePending(int ticket)
{
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true)
   {		
      if(StringLen(closed_pending_msg) > 0)
      {
          string msg = Speak(3, closed_pending_msg,OrderType(), OrderOpenPrice(),OrderLots(),OrderSymbol(),OrderProfit(),TakeProfitPoints(ticket),StopLossPoints(ticket),OrderComment(), Period(), AccountBalance(), AccountEquity(), AccountMargin(), AccountFreeMargin(), Digits, Point);    
      
          Print(msg);
      }
   }
}

void CheckPositions ()
{
	int Orders_Total = OrdersTotal();	
	
	bool OrderClosed = true, OrderOpened = true;
	int  ticket = 0;
	int i, pre_cur, cur;
	
   int PosOrdersTotal = 0;
   int PosOrdersArray[];
   ArrayResize( PosOrdersArray, MathMax( Orders_Total, 1 ));
   ArrayInitialize( PosOrdersArray, 0.0 );		
   for (i = Orders_Total - 1; i >= 0; i --)	{
	   if (OrderSelect(i, SELECT_BY_POS) == false)
		   continue;	
	   if (OrderSymbol() != Symbol())
	      continue;
	   if(OrderType() == OP_BUY || OrderType() == OP_SELL) {
		   PosOrdersArray[PosOrdersTotal] = OrderTicket();
		   PosOrdersTotal ++;
	   }
   }
   // open POSITION
   for (cur = 0; cur < PosOrdersTotal; cur ++)	{
	   ticket = PosOrdersArray[cur];
	   OrderOpened = true;
	   for (pre_cur = 0; pre_cur < Pre_PosOrdersTotal; pre_cur ++ )	{
		   if ( ticket == Pre_PosOrdersArray[pre_cur]) {
			   OrderOpened = false;
			   break;
		   }
	   }
	   if (OrderOpened == true && OrderSelect(ticket, SELECT_BY_TICKET) == true) {
	     if(OrderOpenTime() > inittime) {
	        if(OrderType() == OP_BUY) 
	           HandleOpenBuyMarket(ticket); 
	        else if(OrderType() == OP_SELL) 
	           HandleOpenSellMarket(ticket); 
	     }
	   }
   }
   
   // close POSITION
   for (pre_cur = 0; pre_cur < Pre_PosOrdersTotal; pre_cur ++)	{
	   ticket =Pre_PosOrdersArray[pre_cur];
	   OrderClosed = true;
	   for (cur = 0; cur < PosOrdersTotal; cur ++ )	{
		   if ( ticket == PosOrdersArray[cur]) {
			   OrderClosed = false;
			   break;
		   }
	   }
	   if (OrderClosed == true && OrderSelect(ticket, SELECT_BY_TICKET) == true){
	      if(OrderType() == OP_BUY)
	        HandleCloseBuyMarket(ticket); 
	      else if(OrderType() == OP_SELL) 
	        HandleCloseSellMarket(ticket); 
	   }
   }
	
   int PendOrdersTotal = 0;
   int PendOrdersArray[];
   ArrayResize( PendOrdersArray, MathMax( Orders_Total, 1 ));
   ArrayInitialize( PendOrdersArray, 0.0 );		
   for (i = Orders_Total - 1; i >= 0; i --)	{
	   if (OrderSelect(i, SELECT_BY_POS) == false)
		   continue;	
	   if (OrderSymbol() != Symbol())
	      continue;
	   if(OrderType() == OP_BUYLIMIT || OrderType() == OP_SELLLIMIT || OrderType() == OP_BUYSTOP || OrderType() == OP_SELLSTOP){
		   PendOrdersArray[PendOrdersTotal] = OrderTicket();
		   PendOrdersTotal ++;
	   }
   }

   // open PENDING
   for (cur = 0; cur < PendOrdersTotal; cur ++)	{
	   ticket = PendOrdersArray[cur];
	   OrderOpened = true;
	   for (pre_cur = 0; pre_cur < Pre_PendOrdersTotal; pre_cur ++ )	{
		   if ( ticket == Pre_PendOrdersArray[pre_cur]) {
			   OrderOpened = false;
			   break;
		   }
	   }
	   if (OrderOpened == true && OrderSelect(ticket, SELECT_BY_TICKET) == true){
	     if(OrderOpenTime() > inittime){
	        HandleOpenPending(ticket); 
	     }
	   }
   }
   
   // close PENDING
   for (pre_cur = 0; pre_cur < Pre_PendOrdersTotal; pre_cur ++)	{
	   ticket =Pre_PendOrdersArray[pre_cur];
	   OrderClosed = true;
	   for (cur = 0; cur < PendOrdersTotal; cur ++ )	{
		   if ( ticket == PendOrdersArray[cur]) {
			   OrderClosed = false;
			   break;
		   }
	   }
	   
	   if (OrderClosed == true && OrderSelect(ticket, SELECT_BY_TICKET) == true){
	      if(OrderType() == OP_BUYLIMIT || OrderType() == OP_SELLLIMIT || OrderType() == OP_BUYSTOP || OrderType() == OP_SELLSTOP) {
	         HandleClosePending(ticket);
	      }
	   }
   }
}

void SavePositions()
{
   int Orders_Total = OrdersTotal();	
   int i, cur;
   
   int PosOrdersTotal = 0;
   int PosOrdersArray[];	
   ArrayResize( PosOrdersArray, MathMax( Orders_Total, 1 ) );
   ArrayInitialize( PosOrdersArray, 0.0 );	
   for (i = Orders_Total - 1; i >= 0; i --)	{
	   if (OrderSelect(i, SELECT_BY_POS) == false)
		   continue;	
	   if (OrderSymbol() != Symbol())	
	      continue;	     
	   if(OrderType() == OP_BUY || OrderType() == OP_SELL)  {
	      PosOrdersArray[PosOrdersTotal] = OrderTicket(); 
	      PosOrdersTotal ++;
	   }
   }

   ArrayResize (Pre_PosOrdersArray, MathMax (PosOrdersTotal, 1));	
   for (cur = 0; cur < PosOrdersTotal; cur ++ )	{
	   Pre_PosOrdersArray[cur] = PosOrdersArray[cur];
   }
   Pre_PosOrdersTotal = PosOrdersTotal;
   
	
   int PendOrdersTotal = 0;
   int PendOrdersArray[];	
   ArrayResize( PendOrdersArray, MathMax( Orders_Total, 1 ) );
   ArrayInitialize( PendOrdersArray, 0.0 );	
   for (i = Orders_Total - 1; i >= 0; i --)	{
	   if (OrderSelect(i, SELECT_BY_POS) == false)
		     continue;	
	  	   if (OrderSymbol() != Symbol())	
	        continue;
	      if(OrderType() == OP_BUYLIMIT || OrderType() == OP_SELLLIMIT || OrderType() == OP_BUYSTOP || OrderType() == OP_SELLSTOP) {
		      PendOrdersArray[PendOrdersTotal] = OrderTicket(); 
		      PendOrdersTotal ++;
		   }
   }
  	
   ArrayResize (Pre_PendOrdersArray, MathMax (PendOrdersTotal, 1));	
   for (cur = 0; cur < PendOrdersTotal; cur ++ )	{
	   Pre_PendOrdersArray[cur] = PendOrdersArray[cur];
   }
   Pre_PendOrdersTotal = PendOrdersTotal;
}

double TakeProfitPoints(int ticket)
{
   double tp = 0;
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true) {
      if(OrderTakeProfit() > 0.0)
      {
         tp = MathAbs(NormalizeDouble((OrderTakeProfit() - OrderOpenPrice())/(Point * multiplier), 1));
      }
   }
   return (tp);

}

double StopLossPoints(int ticket)
{
   double sl = 0;
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true) {
      if(OrderStopLoss() > 0.0)
      {
         sl = MathAbs(NormalizeDouble((OrderStopLoss() - OrderOpenPrice())/(Point * multiplier), 1));
      }
   }
   return (sl);
}

