//+------------------------------------------------------------------+
//|                                                      Starter.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//#include <Tracert.mqh>
extern double  Lots              = 0.1;
extern double  MaximumRisk       = 0.03;
extern double  DecreaseFactor    = 3;
extern int     Stop              = 10;
//extern int     SL                = 0;     // ""   StopLoss
//extern double Lots = 4;
// Laguerre
extern double  GammaP            = 0.7;   // ""   "Laguerre"
extern double  StopL             = 0.1;   //"" "Laguerre"   
extern int     ShftL             = 0;     //,    "Laguerre"
// CCI
extern int     CCIperiod         = 14;    //  CCI
extern int     TypeCCI           = 0;     //" "   CCI 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-WEIGHTED
extern int     DAlpha            = 0;     // CCI - "   CCI"  
extern int     CCILevel          = 100;   // - ,    CCI,   .  +/-100, 0,   starter' +/-5.  , ......
extern int     ShftA1            = 0;     //   "" CCI
extern int     ShftA2            = 1;     //   "" CCI
// MA
extern double  MAPeriod          = 120;   //  MA
extern int     TypeMA            = 0;     //" "   MA 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-WEIGHTED
extern int     ShftMA            = 0;     //   "" MA (  "" MA = ShftMA+1 (   CCI))
extern double  DeltaMA           = 0.1;   // MA (""  "" )  "" :)
//     
extern double  PowerPeriod       = 13;  
//MagicNubber
extern int     MagicNumber       = 20051016; //   ,   , ,        :)
extern int    Patr = 9;
extern int    Prange = 5;
extern double Kstop = 0.5;
extern double kts = 2.0;
extern double Vts = 2.0;
extern int    Dist = 10; //   ,      
                        // (   1-5 )
int prevBars;
double SL, TS, spread, d;
int handle;
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//---- 
   handle = FileOpen("StarterDebug.csv",  FILE_CSV | FILE_WRITE);
   FileWrite(handle, "Time[0]", "TradeType", "Laguerre", "MA", "MA1", "DMA", "Alpha1", "Alpha2", "DAlpha");
   spread = Point*MarketInfo(Symbol(),MODE_SPREAD);
   d = Dist*Point;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   FileClose(handle);  
//----
   return(0);
  }
 
//+------------------------------------------------------------------+
//| Calculate optimal lot size                                       |
//+------------------------------------------------------------------+
double LotsOptimized()
  {
   double lot=Lots;
   int    orders=HistoryTotal();     // history orders total
   int    losses=0;                  // number of losses orders without a break
//---- select lot size
   lot=NormalizeDouble(AccountFreeMargin()*MaximumRisk/500,1);
//---- calcuulate number of losses orders without a break
   if(DecreaseFactor>0)
     {
      for(int i=orders-1;i>=0;i--)
        {
         if(OrderSelect(i,SELECT_BY_POS,MODE_HISTORY)==false) { Print("Error in history!"); break; }
         if(OrderSymbol()!=Symbol() || OrderType()>OP_SELL) continue;
         //----
         if(OrderProfit()>0) break;
         if(OrderProfit()<0) losses++;
        }
      if(losses>1) lot=NormalizeDouble(lot-lot*losses/DecreaseFactor,1);
     }
//---- return lot size
   if(lot<1) lot=1;
   if(lot>1000) lot=1000;
   return(lot);
  }  
  
double LaGuerre(double gamma, int shift)
{
	double RSI;
	double L0[100];
	double L1[100];
	double L2[100];
	double L3[100];
	double CU, CD;

	for (int i=shift+99; i>=shift; i--)
	{
		L0[i] = (1.0 - gamma)*Close[i] + gamma*L0[i+1];
		L1[i] = -gamma*L0[i] + L0[i+1] + gamma*L1[i+1];
		L2[i] = -gamma*L1[i] + L1[i+1] + gamma*L2[i+1];
		L3[i] = -gamma*L2[i] + L2[i+1] + gamma*L3[i+1];

		CU = 0;
		CD = 0;
		if (L0[i] >= L1[i])  CU = L0[i] - L1[i];
		else 		 		CD = L1[i] - L0[i];
		
		if (L1[i] >= L2[i])  CU = CU + L1[i] - L2[i];
		else 		 		CD = CD + L2[i] - L1[i];
		if (L2[i] >= L3[i])  CU = CU + L2[i] - L3[i];
		else 		 		CD = CD + L3[i] - L2[i];

		if (CU + CD != 0)		RSI = CU / (CU + CD);
	}
   return(RSI);
}  

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
   
   int cnt, total;

   total=OrdersTotal();
   if ( Vts < 1 || Vts > 2) return(0);

   if( prevBars != Bars)
     {
      SL_Calculating();
      prevBars = Bars;
     } 


     
//------------------------------------------------------- 
   for (cnt=0; cnt<total; cnt++) 
     {
      OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);

//First Stop--------------------------------- 
      if (OrderType() == OP_BUY && OrderSymbol() == Symbol() && OrderStopLoss() == 0) 
           {
            SL_Calculating();
            RefreshRates();
            bool tick = OrderModify(OrderTicket(),OrderOpenPrice(),MathMin(Bid-d,Low[0]+spread-SL),OrderTakeProfit(),0,Aqua);   
            if (tick == false)
              {
               int err = GetLastError();
               Print("Error(",err,") modifying order ",OrderTicket()); 
              }
            Sleep(10000);
            return(0); 
           }

      if (OrderType() == OP_SELL && OrderSymbol() == Symbol() && OrderStopLoss() == 0) 
           {
            SL_Calculating();
            RefreshRates();
            tick = OrderModify(OrderTicket(),OrderOpenPrice(),MathMax(Ask+d,High[0]+SL),OrderTakeProfit(),0,Magenta);   
            if (tick == false)
              {
               err = GetLastError();
               Print("Error(",err,") modifying order ",OrderTicket()); 
              }
            Sleep(10000);
            return(0); 
           }

//Main Trailing------------------------------- 
      if (OrderType() == OP_BUY && OrderSymbol() == Symbol() 
          && High[0]+spread-OrderOpenPrice() > TS 
          && (OrderStopLoss() < MathMin(High[0]+spread-TS,Bid-d)))
           {
            RefreshRates();
            tick = OrderModify(OrderTicket(),OrderOpenPrice(),MathMin(High[0]+spread-TS,Bid-d),OrderTakeProfit(),0,Aqua);   
            if (tick == false)
              {
               err = GetLastError();
               Print("Error(",err,") modifying order ",OrderTicket()); 
              }
            Sleep(10000);
            return(0); 
           }

      if (OrderType() == OP_SELL && OrderSymbol() == Symbol()  
          && OrderOpenPrice()-Low[0] > TS 
          && (OrderStopLoss() > MathMax(Ask+d,Low[0]+TS)))
           {
            RefreshRates();
            tick = OrderModify(OrderTicket(),OrderOpenPrice(),MathMax(Ask+d,Low[0]+TS),OrderTakeProfit(),0,Magenta);   
            if (tick == false)
              {
               err = GetLastError();
               Print("Error(",err,") modifying order ",OrderTicket()); 
              }
            Sleep(10000);
            return(0); 
           }
     }
   
   
   
   
   
   
   double Laguerre;
  
   double Alpha1, Alpha2;
   double MA, MA1;
   double Bear,Bear_1;   
   double Bull,Bull_1;
   int  ticket, RealTotal;
  

  Laguerre=LaGuerre(GammaP, 0);
  Alpha1=iCCI(NULL, 0, CCIperiod, TypeCCI, ShftA1);
  Alpha2=iCCI(NULL, 0, CCIperiod, TypeCCI, ShftA2);
  MA=iMA(NULL,0,MAPeriod,0,MODE_EMA,TypeMA,ShftMA);
  MA1=iMA(NULL,0,MAPeriod,0,MODE_EMA,TypeMA,ShftMA+1);
  Bear=iBearsPower(NULL, 0, PowerPeriod,PRICE_CLOSE,1);
  Bear_1=iBearsPower(NULL, 0, PowerPeriod,PRICE_CLOSE,2);
  Bull=iBullsPower(NULL, 0, PowerPeriod,PRICE_CLOSE,1);
  Bull_1=iBullsPower(NULL, 0, PowerPeriod,PRICE_CLOSE,2);

  
//+--  Juice=iCustom(NULL,0,"Juice",0,0);
  
  total=OrdersTotal();
  //       MagicNumber    (      )
  for (cnt = 0; cnt < total; cnt++)
  {
   OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
   if (OrderMagicNumber() == MagicNumber && OrderSymbol() == Symbol())
    RealTotal = RealTotal + 1;
  }
 
   if(RealTotal<1) 
     {
      // no opened orders identified
      if(AccountFreeMargin()<(1000*Lots))
        {
         Print("We have no money. Free Margin = ", AccountFreeMargin());
         return(0);  
        }
      // check for long position (BUY) possibility
      if(
         // ""
      //   (Laguerre==0) 
      Bull>Bull_1 && Bull<0 && Bull_1<0 && Bear>Bear_1
      && //   MA,     
         (MA-MA1 > DeltaMA * Point) 
    //  && // CCI
      //   (Alpha2 < Alpha1) 
    //  && //   +/-100, 0 "-"
     //    (Alpha1 > -1 * CCILevel && Alpha2 < -1 * CCILevel)
//      && //  (  -  .     ( "" ) 0, ,    ,   ....
//         (Alpha1 < -5)
    //  && // CCI  %  
     //    (MathAbs(Alpha1 - Alpha2)/MathMax(MathAbs(Alpha1),MathAbs(Alpha2))*100 > DAlpha)
        ) //+-- && Juice>JuiceLevel)
        {
         FileWrite(handle, "Buy", Time[0], Laguerre, MA, MA1, MA-MA1, Alpha1, Alpha2, MathAbs(Alpha1 - Alpha2)/MathMax(MathAbs(Alpha1),MathAbs(Alpha2))*100 );
         FileFlush(handle);
         // "" StopLoss
   /*      if (SL == 0)
          SLstop = 0;
         else
          SLstop = Ask - SL * Point;*/
         ticket=OrderSend(Symbol(),OP_BUY,LotsOptimized(),Ask,3,0,0,"starter",MagicNumber,0,Green);
        }
      // check for short position (SELL) possibility
      if(
         // ""
        // (Laguerre==1) 
         Bear<Bear_1 && Bear>0 && Bear_1>0 && Bull<Bull_1 
        
      && //   MA,     
         (MA-MA1 < -1 * DeltaMA * Point) 
    //  && // CCI
     //    (Alpha2 > Alpha1) 
     // && //   +/-100, 0 "-"
      //   (Alpha1 < CCILevel && Alpha2 > CCILevel)
//      && //  (  -  .     ( "" ) 0, ,    ,   ....
//         (Alpha1 > 5)
    //  && // CCI  %  
     //    (MathAbs(Alpha1 - Alpha2)/MathMax(MathAbs(Alpha1),MathAbs(Alpha2))*100 > DAlpha)
        ) //+-- && Juice>JuiceLevel)
        {
         FileWrite(handle, "Sell", Time[0], Laguerre, MA, MA1, MA-MA1, Alpha1, Alpha2, MathAbs(Alpha1 - Alpha2)/MathMax(MathAbs(Alpha1),MathAbs(Alpha2))*100 );
         FileFlush(handle);
         // "" StopLoss
    /*     if (SL == 0)
          SLstop = 0;
         else
          SLstop = Bid + SL * Point;*/
         ticket=OrderSend(Symbol(),OP_SELL,LotsOptimized(),Bid,3,0,0,"starter",MagicNumber,0,Red);
        } 
     }



// 
   for(cnt=0;cnt<total;cnt++)
     {
      OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
      if(OrderType()<=OP_SELL &&   // check for opened position 
         OrderSymbol()==Symbol() &&  // check for symbol
         OrderMagicNumber() == MagicNumber)  // check for MagicNumber (      )
        {
         if(OrderType()==OP_BUY)   // long position is opened
           {
            // should it be closed?
            if(Laguerre>1-StopL)
                {
                 OrderClose(OrderTicket(),OrderLots(),Bid,3,Violet); // close position
                 return(0); // exit
                }
            // check for stop
            if(Stop>0)  
              {                 
               if(Bid-OrderOpenPrice()>Point*Stop)
                 {
                   OrderClose(OrderTicket(),OrderLots(),Bid,3,Violet); // close position
                   return(0);
                 }
              }
           }
         else // go to short position
           {
            // should it be closed?
            if(Laguerre<StopL)
              {
               OrderClose(OrderTicket(),OrderLots(),Ask,3,Violet); // close position
               return(0); // exit
              }
            // check for stop
            if(Stop>0)  
              {                 
               if(OrderOpenPrice()-Ask>Point*Stop)
                 {
                   OrderClose(OrderTicket(),OrderLots(),Ask,3,Violet); // close position
                   return(0);
                 }
              }
           }
        }
     }
     
   return(0);
  }
// the end.
int SL_Calculating()
  {
   int I;
   double ValATR, hi, lo;
   ValATR = 0;
   for (I=0;I<Patr;I++)
     {
      if (I <= Patr) ValATR += High[I]-Low[I]; 
     }
       
   ValATR = NormalizeDouble(ValATR / Patr, 4); 

   hi=High[Highest(NULL,0,MODE_HIGH,Prange,Prange)]; 
   lo=Low[Lowest(NULL,0,MODE_LOW,Prange,Prange)]; 

   if (Vts == 1) TS = kts*ValATR; 
   SL = Kstop*ValATR; 
   if (Vts == 2) TS=(hi-lo); 
   SL = Kstop*(hi-lo);    
   
   return(0);
  }
// --- the end ---