//+------------------------------------------------------------------+
//|                                                  e-TLE_v.1.6.mq4 |
//|                                             . aka KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//| 20.09.2005    (Three Level Exit).     |
//|               .                    |
//|                 .                   |
//| 22.09.2005 v.1.0            |
//|             .                                    |
//| 22.09.2005 v.1.1               |
//| 22.09.2005 v.1.2                |
//| 22.09.2005 v.1.3            |
//| 22.09.2005 v.1.4              |
//| 23.09.2005 v.1.5             |
//| 14.10.2005 v.1.6                           |
//+------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"

//-------    --------------------------------
extern bool   UseOneAccount = True;         //     
extern int    NumberAccount = 82946;        //   
extern bool   AllPositions  = False;        //   
extern int    LevelProfit1  = 20;           //   
extern int    LevelMoving1  = 1;            //   
extern int    LevelProfit2  = 35;           //   
extern int    LevelMoving2  = 20;           //   
extern int    LevelProfit3  = 55;           //   
extern int    LevelMoving3  = 30;           //   
extern int    TrailingStop  = 40;           //  
extern int    TrailingStep  = 5;            //  
extern bool   ShowComment   = True;         //  
extern bool   UseSound      = True;         //   
extern string NameFileSound = "expert.wav"; //   

//-------    ----------------------------

//+------------------------------------------------------------------+
//| Custor expert deinitialization function                          |
//+------------------------------------------------------------------+
void deinit() {
  Comment("");
}

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
void start() {
  double pp;
  int    nd;
  string comm="";

  if (UseOneAccount && AccountNumber()!=NumberAccount) {
    Comment("  : "+AccountNumber()+" !");
    return;
  }
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (AllPositions || OrderSymbol()==Symbol()) {
        ThreeLevelSystemOfOutput();
        nd=MarketInfo(OrderSymbol(), MODE_DIGITS);
        pp=MarketInfo(OrderSymbol(), MODE_POINT);
        comm=comm+OrderSymbol()+"  : "+DoubleToStr(OrderOpenPrice(),nd)+
             "  SL = " + DoubleToStr(OrderStopLoss(),nd)+
             " ("+StopLossInPoint()+")\n";
      }
    }
  }
  if (ShowComment) Comment(comm);
}

//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void ThreeLevelSystemOfOutput() {
  int pr=ProfitPosition(), sl=StopLossInPoint();
  int sp=MarketInfo(OrderSymbol(), MODE_SPREAD);

  if (pr>LevelProfit1 && pr<=LevelProfit2 && sl<LevelMoving1) ModifyStopLossInPoint(LevelMoving1);
  if (pr>LevelProfit2 && pr<=LevelProfit3 && sl<LevelMoving2) ModifyStopLossInPoint(LevelMoving2);
  if (pr>LevelProfit3 && sl<LevelMoving3) ModifyStopLossInPoint(LevelMoving3);
  if (pr>LevelMoving3+TrailingStop+TrailingStep) {
    TrailingPositions();
  }
}

//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void TrailingPositions() {
  double pBid, pAsk, pp=MarketInfo(OrderSymbol(), MODE_POINT);

  if (OrderType()==OP_BUY) {
    pBid=MarketInfo(OrderSymbol(), MODE_BID);
    if (pBid-OrderOpenPrice()>TrailingStop*pp) {
      if (OrderStopLoss()<pBid-(TrailingStop+TrailingStep-1)*pp) {
        ModifyStopLoss(pBid-TrailingStop*pp);
        return;
      }
    }
  }
  if (OrderType()==OP_SELL) {
    pAsk=MarketInfo(OrderSymbol(), MODE_ASK);
    if (OrderOpenPrice()-pAsk>TrailingStop*pp) {
      if (OrderStopLoss()>pAsk+(TrailingStop+TrailingStep-1)*pp || OrderStopLoss()==0) {
        ModifyStopLoss(pAsk+TrailingStop*pp);
        return;
      }
    }
  }
}

//+------------------------------------------------------------------+
//|   StopLoss                                          |
//| :                                                       |
//|   ldStopLoss -  StopLoss                                  |
//+------------------------------------------------------------------+
void ModifyStopLoss(double ldStopLoss) {
  bool fm;         //   

  fm=OrderModify(OrderTicket(),OrderOpenPrice(),ldStopLoss,OrderTakeProfit(),0,CLR_NONE);
  if (fm && UseSound) PlaySound(NameFileSound);
}

//+------------------------------------------------------------------+
//|   StopLoss                                          |
//| :                                                       |
//|   ldStopLoss -  StopLoss                                  |
//+------------------------------------------------------------------+
void ModifyStopLossInPoint(int pp) {
  bool   fm;         //   
  double ldSL=0, mp=MarketInfo(OrderSymbol(), MODE_POINT);

  if (OrderType()==OP_BUY)  ldSL=OrderOpenPrice()+pp*mp;
  if (OrderType()==OP_SELL) ldSL=OrderOpenPrice()-pp*mp;
  fm=OrderModify(OrderTicket(),OrderOpenPrice(),ldSL,OrderTakeProfit(),0,CLR_NONE);
  if (fm && UseSound) PlaySound(NameFileSound);
}

//+------------------------------------------------------------------+
//|                                   |
//+------------------------------------------------------------------+
int ProfitPosition() {
  double pBid, pAsk, pp=MarketInfo(OrderSymbol(), MODE_POINT);
  double pr=0;

  if (OrderType()==OP_BUY) {
    pBid=MarketInfo(OrderSymbol(), MODE_BID);
    pr=(pBid-OrderOpenPrice())/pp;
  }
  if (OrderType()==OP_SELL) {
    pAsk=MarketInfo(OrderSymbol(), MODE_ASK);
    pr=(OrderOpenPrice()-pAsk)/pp;
  }
  return(MathRound(pr));
}

//+------------------------------------------------------------------+
//|  StopLoss                               |
//+------------------------------------------------------------------+
int StopLossInPoint() {
  double pp=MarketInfo(OrderSymbol(), MODE_POINT);
  double sp=0;

  if (OrderType()==OP_BUY) {
    sp=(OrderStopLoss()-OrderOpenPrice())/pp;
  }
  if (OrderType()==OP_SELL) {
    sp=(OrderOpenPrice()-OrderStopLoss())/pp;
  }
  if (OrderStopLoss()==0) sp=-OrderOpenPrice()/pp;
  return(MathRound(sp));
}
//+------------------------------------------------------------------+

