//+------------------------------------------------------------------+
//|                                                  Executer_AO.mq4 |
//|                           Copyright  2006, Alex Sidd (Executer) |
//|                                           mailto:work_st@mail.ru |
//+------------------------------------------------------------------+
//|  ""  (-, ,   |
//|     .                      |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Alex Sidd (Executer)"
#property link      "mailto:work_st@mail.ru"
//----
#define MAGIC 612457
//----
extern double lStopLoss = 70;
extern double sStopLoss = 60;
extern double lTakeProfit = 60;
extern double sTakeProfit = 60;
extern double lTrailingStop = 40;
extern double sTrailingStop = 40;
extern double Lots = 0.10;
extern int a = 3;
extern double DecreaseFactor = 100;
extern double MaximumRisk    = 0.025;
extern double MaximumLots    = 100;
//----
int IsLastBuy = 0;
color clOpenBuy = Blue;
color clCloseBuy = Aqua;
color clOpenSell = Red;
color clCloseSell = Violet;
color clModiBuy = Blue;
color clModiSell = Red;
string Name_Expert = "Executer_AO";
int Slippage = 0;
bool UseSound = True;
string NameFileSound = "alert.wav";
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double GetSizeLot()
  {
   double Lot = Lots;
   int cycle;
   int prof = 0;
   int orders = HistoryTotal(); // history orders total
   int losses = 0;              // number of losses orders without a break
   int vinn = 0;
   int i = orders;
//---- select lot size
   Lot = NormalizeDouble(AccountFreeMargin()*MaximumRisk / 100, 1);
   if(AccountFreeMargin() <= 10000 && AccountFreeMargin() > 5000) 
       DecreaseFactor = NormalizeDouble(AccountFreeMargin() / 100, 1);
   if(AccountFreeMargin() <= 5000 && AccountFreeMargin() > 3000) 
       DecreaseFactor = NormalizeDouble(AccountFreeMargin() / 200, 1);
   if(AccountFreeMargin() <= 14) 
       DecreaseFactor = 14;
   if(AccountFreeMargin() > 10000) 
       DecreaseFactor = 60;
   if(DecreaseFactor > 0 && orders > DecreaseFactor)
     {
       for(cycle = 1; cycle < DecreaseFactor; cycle++)
         {
           i--;
           if(OrderSelect(i, SELECT_BY_TICKET, MODE_HISTORY) == false) 
             { 
               Print("Error in history!"); 
               break; 
             }   
           if(OrderCloseTime()>0)
             {
               prof = prof + OrderProfit(); 
               if(OrderProfit() <= 0 ) 
                   losses++;
               else 
                   vinn++;
             }
         }  
      if(prof <= 0 ) 
          Lot = 0.1; // Lot - (0.1*losses); //Lot = 0.1;//
//     if(prof <=0 && vinn>losses) Lot = Lot - (0.1*losses);
      if(prof > 0 && losses > vinn) 
        {
          Lot = Lot + (0.1*NormalizeDouble(vinn / 4, 0.1));
        }
      if(prof > 0 && losses <= vinn )
        {
          Lot = Lot + (0.1*NormalizeDouble(vinn / 2, 0.1));
        }
     } 
   if(AccountFreeMargin() < 300 || Lot < 0.1) 
       Lot = 0.1;
   if(Lot*1275 >= AccountFreeMargin()) 
       Lot = NormalizeDouble(AccountFreeMargin()*MaximumRisk / 100, 1);
   if(MaximumLots != 0 && Lot > MaximumLots) 
       Lot = MaximumLots;
   if(DecreaseFactor > orders) 
       Lot = Lots;
   Lot = Lots;
   return(Lot);
  }  
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+  
void deinit() 
  {
   Comment("");
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   if(Bars < 100)
     {
       Print("bars less than 100");
       return(0);
     }
   if(lStopLoss < 3)
     {
       Print("StopLoss less than 3");
       return(0);
     }
   if(lTakeProfit<3)
     {
       Print("TakeProfit less than 3");
       return(0);
     }
   if(sStopLoss<3)
     {
       Print("StopLoss less than 3");
       return(0);
     }
   if(sTakeProfit<3)
     {
       Print("TakeProfit less than 3");
       return(0);
     }
   if(AccountFreeMargin() < (1000*Lots))
     {
       Print("We have no money. Free Margin = ", AccountFreeMargin());
       return(0);
     }
   double AO_1, AO_2, AO_3;
   AO_1 = iAO(NULL, 0, 1);
   AO_2 = iAO(NULL, 0, 2);
   AO_3 = iAO(NULL, 0, 3);
   if(!ExistPositions())
     {
       if(AO_1 > AO_2 && AO_2 < AO_3 && AO_1 < -0.008000)
         { 
           //Volume[1]>Volume[2]&&Volume[1]-Volume[2]>400&&
           OpenBuy();
           IsLastBuy = 1;
           return(0);
         }
       if(AO_1 < AO_2 && AO_2 > AO_3 && AO_1 > 0.008000)
         { 
           //Volume[1]>Volume[2]&&Volume[1]-Volume[2]>200&&
           OpenSell();
           IsLastBuy = 2;
           return(0);
         }
     }
   if(ExistPositions())
     {
       if(OrderType() == OP_BUY)
         {
           if(AO_1 > 0)
             {
               CloseBuy();
               return(0);
             }
         }
       if(OrderType() == OP_SELL)
         {
           if(AO_1 < 0)
             {
               CloseSell();
               return(0);
             }
         }
     }
   TrailingPositionsBuy(lTrailingStop);
   TrailingPositionsSell(sTrailingStop);
   return (0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool ExistPositions() 
  {
	  for(int i = 0; i < OrdersTotal(); i++) 
	    {
		     if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) 
		       {
			        if(OrderSymbol() == Symbol() && OrderMagicNumber() == MAGIC) 
			          {
				           return(True);
			          }
		       } 
	    } 
	  return(false);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void TrailingPositionsBuy(int trailingStop) 
  { 
   for(int i = 0; i < OrdersTotal(); i++) 
     { 
       if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) 
         { 
           if(OrderSymbol() == Symbol() && OrderMagicNumber() == MAGIC) 
             { 
               if(OrderType() == OP_BUY) 
                 { 
                   if(Bid - OrderOpenPrice() > trailingStop*Point) 
                     { 
                       if(OrderStopLoss() < Bid - trailingStop*Point) 
                           ModifyStopLoss(Bid - trailingStop*Point); 
                     } 
                 } 
             } 
         } 
     } 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void TrailingPositionsSell(int trailingStop) 
  { 
   for(int i = 0; i < OrdersTotal(); i++) 
     { 
       if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) 
         { 
           if(OrderSymbol() == Symbol() && OrderMagicNumber() == MAGIC) 
             { 
               if(OrderType() == OP_SELL) 
                 { 
                   if(OrderOpenPrice() - Ask > trailingStop*Point) 
                     { 
                       if(OrderStopLoss() > Ask + trailingStop*Point || OrderStopLoss() == 0)  
                           ModifyStopLoss(Ask + trailingStop*Point); 
                     } 
                 } 
             } 
         } 
     } 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ModifyStopLoss(double ldStopLoss) 
  { 
   bool fm;
   fm = OrderModify(OrderTicket(), OrderOpenPrice(), ldStopLoss, OrderTakeProfit(), 
                    0, CLR_NONE); 
   if(fm && UseSound) 
       PlaySound(NameFileSound); 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CloseBuy() 
  { 
   bool fc; 
   fc = OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, clCloseBuy); 
   if(fc && UseSound) 
       PlaySound(NameFileSound); 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CloseSell() 
  { 
   bool fc; 
   fc = OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, clCloseSell); 
   if(fc && UseSound) 
       PlaySound(NameFileSound); 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OpenBuy() 
  { 
   double ldLot, ldStop, ldTake; 
   string lsComm; 
   ldLot = GetSizeLot(); 
   ldStop = GetStopLossBuy(); 
   ldTake = GetTakeProfitBuy(); 
   lsComm = GetCommentForOrder(); 
   OrderSend(Symbol(), OP_BUY, ldLot, Ask, Slippage, ldStop, ldTake, lsComm, MAGIC, 
             0, clOpenBuy); 
   if(UseSound) 
       PlaySound(NameFileSound); 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OpenSell() 
  { 
   double ldLot, ldStop, ldTake; 
   string lsComm; 
   ldLot = GetSizeLot(); 
   ldStop = GetStopLossSell(); 
   ldTake = GetTakeProfitSell(); 
   lsComm = GetCommentForOrder(); 
   OrderSend(Symbol(), OP_SELL, ldLot, Bid, Slippage, ldStop, ldTake, lsComm, MAGIC, 
             0, clOpenSell); 
   if(UseSound) 
       PlaySound(NameFileSound); 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string GetCommentForOrder() 
  { 	
    return(Name_Expert); 
  } 
//double GetSizeLot() { 	return(Lots); } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double GetStopLossBuy() 
  { 	
    return(Bid - lStopLoss*Point);
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double GetStopLossSell() 
  { 	
    return(Ask + sStopLoss*Point); 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double GetTakeProfitBuy() 
  { 	
    return(Ask + lTakeProfit*Point); 
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double GetTakeProfitSell() 
  { 	
    return(Bid - sTakeProfit*Point); 
  } 
//----
return(0);
//+------------------------------------------------------------------+


