
#define MAGIC_NUMB 3512797

extern string s1="//====Position settings====//";
extern double Lots=0.1;
extern int DefaultStopLoss=12;
extern int TrailingStop = 20;
extern string s2="//====OpenGraphics settings====//";
extern int BUY_Area =20;
extern int BUY_Target_1 =40;
extern int SELL_Area = 20;
extern int SELL_Target_1 =40;

int curr_day=-1;

bool bs=false,ss=false;

void CloseAllPositions()
{
   string symbol=Symbol();
   for(int i=OrdersTotal()-1;i>=0;i--)
   {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)&&OrderSymbol()==symbol&&OrderMagicNumber()==MAGIC_NUMB)
      {
         if(OrderType()==OP_BUY)
         {
           if(!OrderClose(OrderTicket(),OrderLots(),Bid,3,Yellow))
               Print("Error close BUY order : ",GetLastError());
         }
         if(OrderType()==OP_SELL)
         {
            if(!OrderClose(OrderTicket(),OrderLots(),Ask,3,Red))
               Print("Error close SELL order : ",GetLastError());
         }
      }
   }
}
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
   iCustom(Symbol(),NULL,"Open Graphics4Exp",BUY_Area,BUY_Target_1,SELL_Area,SELL_Target_1,0,0);
   int ticket;
   double pivot=GlobalVariableGet("OGPivot");
   double stoploss;
   
   
   int orders_count=OrdersTotal(),order_type,i;
   string symbol=Symbol();
   
   for(i=0;i<orders_count;i++)
   {
        if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES)&&OrderMagicNumber()==MAGIC_NUMB
           &&OrderSymbol()==symbol)
        {
            order_type=OrderType();
            if(order_type==OP_BUY)
            {
                    if(Bid-OrderOpenPrice()>(TrailingStop*Point))
                    {
                        if(OrderStopLoss()<(Bid-TrailingStop*Point))
                        {
                            OrderModify(OrderTicket(),OrderOpenPrice(),Bid-TrailingStop*Point,OrderTakeProfit(),0,Yellow);
                        }
                    }
            }
            if(order_type==OP_SELL)
            {
                    if(OrderOpenPrice()-Ask>(TrailingStop*Point))
                    {
                        if(OrderStopLoss()>(Ask+TrailingStop*Point)||(OrderStopLoss()==0))
                        {
                            OrderModify(OrderTicket(),OrderOpenPrice(),Ask+TrailingStop*Point,OrderTakeProfit(),0,Red);
                        }
                    }
            }
        }
        
   }
   
   if(DayOfYear()!=curr_day)
   {
      curr_day=DayOfYear();
      bs=false;
      ss=false;   
   }
   
   if(!bs)
   {
      double buy_stop=GlobalVariableGet("OGBuyStop");
      double buy_stop_tp=GlobalVariableGet("OGBuyStopTarget");
      if(Ask-pivot<=MarketInfo(Symbol(),MODE_STOPLEVEL)*Point)
         stoploss=Ask-DefaultStopLoss*Point;
      else
        stoploss=pivot;
         
      ticket=OrderSend(Symbol(),OP_BUYSTOP,Lots,buy_stop,3,stoploss,buy_stop_tp,0,MAGIC_NUMB,StrToTime("23:59"),Lime);
      if(ticket<=0)
         Print("Error opening BUYSTOP order : ",GetLastError());
      else
         bs=true;
   }
   if(!ss)
   {
      double sell_stop=GlobalVariableGet("OGSellStop");
      double sell_stop_tp=GlobalVariableGet("OGSellStopTarget");
      if(pivot-Bid<=MarketInfo(Symbol(),MODE_STOPLEVEL)*Point)
         stoploss=Bid+DefaultStopLoss*Point;
      else
         stoploss=pivot;
      
      ticket=OrderSend(Symbol(),OP_SELLSTOP,Lots,sell_stop,3,stoploss,sell_stop_tp,0,MAGIC_NUMB,StrToTime("23:59"),Red);
      if(ticket<=0)
         Print("Error opening SELLSTOP order : ",GetLastError());
      else
         ss=true;
   }
   if(Hour()>=23&&Minute()>=50)
      CloseAllPositions();
   return(0);
  }
//+------------------------------------------------------------------+