//+------------------------------------------------------------------+
//|                                                           GO.mq4 |
//|                             Copyright  2006, Victor Chebotariov |
//|                                      http://www.chebotariov.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Victor Chebotariov"
#property link      "http://www.chebotariov.com/"

#define MAGICMA 30072006

int    PERIOD = 174;
int    MODE = 0;
extern double RISK = 30.0;
extern int    MAXORDERS = 5;

//+------------------------------------------------------------------+
//|                                      |
//+------------------------------------------------------------------+
double LotsOptimized()
  {
//----
   double Lots=NormalizeDouble(AccountBalance()*RISK/100000.0,1);
   if(AccountFreeMargin()<(1000*Lots)){Lots=NormalizeDouble(AccountFreeMargin()*RISK/100000.0,1);}
   if(Lots>MarketInfo(Symbol(),MODE_MAXLOT)){Lots=MarketInfo(Symbol(),MODE_MAXLOT);}
   if(Lots<MarketInfo(Symbol(),MODE_MINLOT)){Lots=MarketInfo(Symbol(),MODE_MINLOT);}
//----
   return(Lots);
  }

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----

//+------------------------------------------------------------------+
//if(!IsDemo()){return(0);} //          |
//+------------------------------------------------------------------+

   int cnt,ticket,MODEMA;
   int total=OrdersTotal();

   if(MODE==0){MODEMA=MODE_SMA;}
   if(MODE==1){MODEMA=MODE_EMA;}
   if(MODE==2){MODEMA=MODE_SMMA;}
   if(MODE==3){MODEMA=MODE_LWMA;}
   
   HideTestIndicators(true);
   double high =iMA(NULL,0,PERIOD,0,MODEMA,PRICE_HIGH,0);
   double low  =iMA(NULL,0,PERIOD,0,MODEMA,PRICE_LOW,0);
   double open =iMA(NULL,0,PERIOD,0,MODEMA,PRICE_OPEN,0);
   double close=iMA(NULL,0,PERIOD,0,MODEMA,PRICE_CLOSE,0);
   double GO=((close-open)+(high-open)+(low-open)+(close-low)+(close-high))*Volume[0];
   HideTestIndicators(false);

   if(GO<0)
     {
      for(cnt=total-1;cnt>=0;cnt--)
        {
         OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
         if(OrderType()==OP_BUY && OrderSymbol()==Symbol() && OrderMagicNumber()==MAGICMA)
         {OrderClose(OrderTicket(),OrderLots(),Bid,3,Violet);return(0);}
        }
     }

   if(GO>0)
     {
      for(cnt=total-1;cnt>=0;cnt--)
        {
         OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
         if(OrderType()==OP_SELL && OrderSymbol()==Symbol() && OrderMagicNumber()==MAGICMA)
         {OrderClose(OrderTicket(),OrderLots(),Ask,3,Violet);return(0);}
        }
     }

   if((GO>0 || GO<0) && (!GlobalVariableCheck("Symbol()"+"MAGICMA"+"TimeBuySell") || GlobalVariableGet("Symbol()"+"MAGICMA"+"TimeBuySell")!=Time[0] && total<MAXORDERS))
     {
      if(AccountFreeMargin()<(1000*LotsOptimized()))
      {Print("   .   = ", AccountFreeMargin());return(0);}
      if(GO>0)
        {
         ticket=OrderSend(Symbol(),OP_BUY,LotsOptimized(),Ask,3,0,0,"MoneyPlus",MAGICMA,0,Green);
         if(ticket>0)
           {
            if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("BUY order opened : ",OrderOpenPrice());
            GlobalVariableSet("Symbol()"+"MAGICMA"+"TimeBuySell",Time[0]);
           }
         else Print("Error opening BUY order : ",GetLastError());return(0); 
        }
      if(GO<0)
        {
         ticket=OrderSend(Symbol(),OP_SELL,LotsOptimized(),Bid,3,0,0,"MoneyPlus",MAGICMA,0,Red);
         if(ticket>0)
           {
            if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("SELL order opened : ",OrderOpenPrice());
            GlobalVariableSet("Symbol()"+"MAGICMA"+"TimeBuySell",Time[0]);
           }
         else Print("Error opening SELL order : ",GetLastError());return(0);
        }
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+