//+------------------------------------------------------------------+
//|                                                force_index  .mq4 |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Ivan Kuvshinov aka Dagnar"
#property link      ""

//---- input parameters
extern int       Profit=300;
extern int       Loss=200;
extern double    ForceLevel=0.4;
extern int       indPeriod=15;
extern int       FirstBar=1;
extern double       Lots=1;
extern int Trailing=50;
extern bool  Autolot=false;

int Magic=191511;
int tp,sl;
bool isOrder,buy,sell;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   if (Loss==0) sl=0; else sl=1;
   if (Profit==0) tp=0; else tp=1;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----

     
     int i,cnt=0;
    if (IsTradeAllowed()) isOrder=true;
     for(i=0; i<=OrdersTotal();i++) {
      OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
      if (OrderMagicNumber()==Magic && OrderSymbol()==Symbol() ) cnt++;
     }
     if (cnt>0 || AccountFreeMargin()<GetLots()*1500) isOrder=false;
     
     
     double f1=iForce(NULL,0,indPeriod,MODE_SMA,PRICE_MEDIAN,FirstBar);
     double f2=iForce(NULL,0,indPeriod,MODE_SMA,PRICE_MEDIAN,FirstBar+1);
     buy=false; sell=false;
     if (f2<ForceLevel && f1>ForceLevel) buy=true;
     if (f2>-ForceLevel && f1<-ForceLevel) sell=true;   
     
     if (isOrder && buy) OrderSend(Symbol(),OP_BUY,GetLots(),Ask,3,(Bid-(Loss)*Point)*sl,(Ask+(Profit)*Point)*tp,"",Magic,0,FireBrick);
     if (isOrder && sell) OrderSend(Symbol(),OP_SELL,GetLots(),Bid,3,(Ask+(Loss)*Point)*sl,(Bid-(Profit)*Point)*tp,"",Magic,0,DarkViolet);
 
     if (Trailing>0) for(i=0; i<=OrdersTotal();i++) {
     OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
     if (OrderMagicNumber()==Magic && OrderSymbol()==Symbol()) {
       if (OrderType()==OP_BUY && Bid-OrderOpenPrice()>Trailing*Point && Bid-OrderStopLoss()>Trailing*Point ) OrderModify(OrderTicket(),OrderOpenPrice(),Bid-Trailing*Point,OrderTakeProfit(),0,CLR_NONE);
       if (OrderType()==OP_SELL && OrderOpenPrice()-Ask>Trailing*Point && OrderStopLoss()-Ask>Trailing*Point ) OrderModify(OrderTicket(),OrderOpenPrice(),Ask+Trailing*Point,OrderTakeProfit(),0,CLR_NONE);
       }
     }      
            
//----
   return(0);
  }
//+------------------------------------------------------------------+
double GetLots()
{
 double res;
 if (Autolot) {
  res=NormalizeDouble(AccountFreeMargin()/5000,1);
  if (res<Lots) res=Lots;
  if (res>100) res=100;
  return(res);
 } else return(Lots);
}