//+------------------------------------------------------------------+
//|                                                  EMA_CROSS_2.mq4 |
//|                                                      Coders Guru |
//|                                         http://www.forex-tsd.com |
//+------------------------------------------------------------------+
// ultima versiune cu micro lots! H1 si D1

#property copyright "Coders Guru"
#property link      "http://www.forex-tsd.com"

//---- Trades limits
extern double
                  TakeProfit        = 10,
                  TrailingStop      = 20,
                  StopLoss          = 20;
extern bool      
                  UseStopLoss       = false;

//---- EMAs paris
extern int 
                  ShortEma          = 1,
                  LongEma           = 5;

//---- Crossing options
extern bool 
                  immediate_trade   = true, //Open trades immediately or wait for cross.
                  reversal          = false, //Use the originally reversal crossing method or not
                  ConfirmedOnEntry  = false;

//---- Money Management
extern double 
                  Lots              = 1,
                  HedgePercent      = 1;  // Used to calcualte the what percent of the lots the user wants to be 
                                          // used in the hedged position
                         
extern bool 
                  MM                = true, //Use Money Management or not
                  AccountIsMicro    = true; //Use Micro-Account or not
extern int
                  StartHour         = 0,   //Indicates when the user wants the EA to start trading
                  StopHour          = 23;  //Indicates when the user wants the EA to stop trading
extern int
                  Risk              = 10; //10%

extern int
                  MAGICMA           = 20060301;
extern bool 
                  Show_Settings     = true;

//---- Global varaibles
static int
                  TimeFrame         = 0;
datetime
                  CheckValueTime;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
{
   if(Show_Settings) Print_Details();
   else Comment("");
   return(0);
  }

//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
{
   TimeFrame=Period(); //Prevent counting the cross while the user changing the timeframe
   return(0);
}
  
bool isNewSumbol(string current_symbol)
{
   //loop through all the opened order and compare the symbols
   int total  = OrdersTotal();
   for(int cnt = 0 ; cnt < total ; cnt++)
   {
      OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
      string selected_symbol = OrderSymbol();
      if (current_symbol == selected_symbol)
      return (False);
    }
    return (True);
}

int Crossed (double line1 , double line2)
{
      static int last_direction = 0;
      static int current_direction = 0;
      
      if(TimeFrame!=Period())
      {
         TimeFrame=Period();
         return (0);
      }
      
      if(line1>line2)current_direction = 1; //up
      if(line1<line2)current_direction = 2; //down
      
      if(immediate_trade==false)
      {
         if(last_direction == 0) //first use
         {
               last_direction = current_direction;
               return(0);
         }
      }

      if(current_direction != last_direction) //changed 
      {
            last_direction = current_direction;
            return (last_direction);
      }
      else
      {
            return (0); //not changed
      }
}

//--- Bassed on Alex idea! More ideas are coming
double LotSize()
{
     double lotMM = MathCeil(AccountFreeMargin() *  Risk / 1000) / 100;
	  
	  if(AccountIsMicro==false) //normal account
	  {
	     if (lotMM < 0.1) lotMM = Lots;
	     if ((lotMM > 0.5) && (lotMM < 1)) lotMM=0.5;
	     if (lotMM > 1.0) lotMM = MathCeil(lotMM);
	     if  (lotMM > 100) lotMM = 100;
	  }
	  else //micro account
	  {
	     if (lotMM < 0.01) lotMM = Lots;
	     if (lotMM > 1.0) lotMM = MathCeil(lotMM);
	     if  (lotMM > 100) lotMM = 100;
	  }
	  
	  return (lotMM);
}

string BoolToStr ( bool value)
{
   if(value) return ("True");
   else return ("False");
}
void Print_Details()
{
   string sComment = "";
   string sp = "----------------------------------------\n";
   string NL = "\n";

   sComment = sp;
   sComment = sComment + "TakeProfit=" + DoubleToStr(TakeProfit,0) + " | ";
   sComment = sComment + "TrailingStop=" + DoubleToStr(TrailingStop,0) + " | ";
   sComment = sComment + "StopLoss=" + DoubleToStr(StopLoss,0) + " | "; 
   sComment = sComment + "UseStopLoss=" + BoolToStr(UseStopLoss) + NL;
   sComment = sComment + sp;
   sComment = sComment + "immediate_trade=" + BoolToStr(immediate_trade) + " | ";
   sComment = sComment + "reversal=" + BoolToStr(reversal) + NL;
   sComment = sComment + sp;
   sComment = sComment + "Lots=" + DoubleToStr(Lots,0) + " | ";
   sComment = sComment + "MM=" + BoolToStr(MM) + " | ";
   sComment = sComment + "Risk=" + DoubleToStr(Risk,0) + "%" + NL;
   sComment = sComment + sp;
  
   Comment(sComment);
}

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{
 if(Hour() >= StartHour && Hour() <= StopHour){  //Nothing will happen unless the time is within the trading time
   int cnt, ticket, total;
   double SEma, LEma, SEmaLAST, LEmaLAST;
   
   string comment = "";
   if(reversal==true)  comment = "EMA_CROSS_Counter-Trend";
   if(reversal==false) comment = "EMA_CROSS_Trend-Following";

   if(Bars<100)
     {
      Print("bars less than 100");
      return(0);  
     }
   if(TakeProfit<1)
     {
      Print("TakeProfit less than 1");
      return(0);  // check TakeProfit
     }
     
   static int isCrossed = 0;

   if(ConfirmedOnEntry)
   {
      if(CheckValueTime==iTime(NULL,TimeFrame,0)) return(0); else CheckValueTime = iTime(NULL,TimeFrame,0);

      SEma     = iMA(NULL,0,ShortEma,0,MODE_EMA,PRICE_CLOSE,1);
      LEma     = iMA(NULL,0,LongEma ,0,MODE_EMA,PRICE_CLOSE,1);
      SEmaLAST = iMA(NULL,0,ShortEma,0,MODE_EMA,PRICE_CLOSE,2);
      LEmaLAST = iMA(NULL,0,LongEma ,0,MODE_EMA,PRICE_CLOSE,2);
      
      if(SEmaLAST<LEmaLAST && SEma>LEma) isCrossed = 1;
      if(SEmaLAST>LEmaLAST && SEma<LEma) isCrossed = 2;
   }
   else
   {
      SEma     = iMA(NULL,0,ShortEma,0,MODE_EMA,PRICE_CLOSE,0);
      LEma     = iMA(NULL,0,LongEma ,0,MODE_EMA,PRICE_CLOSE,0);

      isCrossed = Crossed (LEma,SEma);
   }
   
   if(reversal==false)
   {
           if(isCrossed==1) isCrossed = 2;
      else if(isCrossed==2) isCrossed = 1;
   }
   
   if(MM==true) Lots = LotSize(); //Adjust the lot size
  
   total  = OrdersTotal();

// TRAILING STOP
   for(cnt=0;cnt<total;cnt++)
     {
      OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);

      if(OrderType()<=OP_SELL && OrderSymbol()==Symbol())
        {
         if(OrderType()==OP_BUY)   // long position is opened
           {
            // check for trailing stop
            if(TrailingStop>0)  
              {                 
               if(Bid-OrderOpenPrice()>Point*TrailingStop)
                 {
                  if(OrderStopLoss()<Bid-Point*TrailingStop)
                    {
                     OrderModify(OrderTicket(),OrderOpenPrice(),Bid-Point*TrailingStop,OrderTakeProfit(),0,Green);
                     return(0);
                    }
                 }
              }
           }
         else // go to short position
           {
            // check for trailing stop
            if(TrailingStop>0)  
              {                 
               if((OrderOpenPrice()-Ask)>(Point*TrailingStop))
                 {
                  if((OrderStopLoss()>(Ask+Point*TrailingStop)) || (OrderStopLoss()==0))
                    {
                     OrderModify(OrderTicket(),OrderOpenPrice(),Ask+Point*TrailingStop,OrderTakeProfit(),0,Red);
                     return(0);
                    }
                 }
              }
           }
        }
     }

// ENTRY
  
    if(total < 2 || isNewSumbol(Symbol())) //I have modified the if condition too: it was total<1 (orBanAway aka cucurucu)
     {
       double HedgeLots = (HedgePercent/100)*Lots; //calculates the Lots for the hedged position
       if(isCrossed == 1)
         {
            if(UseStopLoss)
               ticket=OrderSend(Symbol(),OP_BUY,Lots,Ask,3,Ask-StopLoss*Point,Ask+TakeProfit*Point,comment,MAGICMA,0,Green);
            else
               ticket=OrderSend(Symbol(),OP_BUY,Lots,Ask,3,0,Ask+TakeProfit*Point,comment,MAGICMA,0,Green);
            
            if(ticket>0)
              {
               if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("BUY order opened : ",OrderOpenPrice());
              }
            else Print("Error opening BUY order : ",GetLastError()); 
//######################################################################   the added code starts here         
            if(UseStopLoss)
               ticket=OrderSend(Symbol(),OP_SELL,HedgeLots,Bid,3,Bid+StopLoss*Point,Bid-TakeProfit*Point,comment,MAGICMA,0,Red);
            else
               ticket=OrderSend(Symbol(),OP_SELL,HedgeLots,Bid,3,0,Bid-TakeProfit*Point,comment,MAGICMA,0,Red);
            
            if(ticket>0)
              {
               if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("SELL order opened : ",OrderOpenPrice());
              }
            else Print("Error opening SELL order : ",GetLastError());             
//######################################################################   ends here          
            return(0);
         }
         if(isCrossed == 2)
         {
            if(UseStopLoss)
               ticket=OrderSend(Symbol(),OP_SELL,Lots,Bid,3,Bid+StopLoss*Point,Bid-TakeProfit*Point,comment,MAGICMA,0,Red);
            else
               ticket=OrderSend(Symbol(),OP_SELL,Lots,Bid,3,0,Bid-TakeProfit*Point,comment,MAGICMA,0,Red);
            
            if(ticket>0)
              {
               if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("SELL order opened : ",OrderOpenPrice());
              }
            else Print("Error opening SELL order : ",GetLastError()); 
//###################################################################### the added code starts here  
            if(UseStopLoss)
               ticket=OrderSend(Symbol(),OP_BUY,HedgeLots,Ask,3,Ask-StopLoss*Point,Ask+TakeProfit*Point,comment,MAGICMA,0,Green);
            else
               ticket=OrderSend(Symbol(),OP_BUY,HedgeLots,Ask,3,0,Ask+TakeProfit*Point,comment,MAGICMA,0,Green);
            
            if(ticket>0)
              {
               if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("BUY order opened : ",OrderOpenPrice());
              }
            else Print("Error opening BUY order : ",GetLastError()); 
//######################################################################  ends here   
            return(0);
         }
         return(0);
      }
     return(0);
     }
     
   return(0);
  }
//+------------------------------------------------------------------+