//+------------------------------------------------------------------+
//|                                                      AdaptTS.mq4 |
//|                                 Copyright  2006, Andrew Suvorov |
//|                                                    trade@sibp.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Andrew Suvorov"
#property link      "trade@sibp.ru"

extern int     Lots=1;
extern int     Timer=600; //inteval between the modifications
extern int     PerTS=10;  //period ATR for calculation TS/SL
extern double	Kts=7.5;   //ATR for calculating the level TS/SL	
extern int     risk=13;   //% risk from available capital
extern int     MiniForex=1;
extern int     Slippage=5;

int PrBuy=0;

datetime LastTradeTime=0;
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
  int i,DolPunkt;
  double HD,LD,lotsi,StopLos;
//----

if(OrdersTotal()>0) OrderSelect(0,SELECT_BY_POS,MODE_TRADES);
if(OrdersTotal()>0 && OrderType()==OP_BUY)  PrBuy=1;
if(OrdersTotal()>0 && OrderType()==OP_SELL) PrBuy=0;

HD=0;	LD=0; 
 for(i=1;i<=PerTS;i++) //StopLoss & TralingStop
 {
   HD+=High[i-1];
	LD+=Low[i-1];
 }
 
StopLos=Kts*MathSqrt((HD-LD)/PerTS/Point)*Point;

if(Symbol()=="EURUSD") DolPunkt = 10;
else if(Symbol()=="GBPUSD") DolPunkt = 7;
     else return(0);

if(CurTime()>LastTradeTime+10)
{
  if(OrdersTotal()<1)
  {   
 
	if(risk!=0) lotsi=NormalizeDouble(AccountBalance()*risk/100/DolPunkt/StopLos*Point,1);
 	else lotsi=Lots;
           
 	if(lotsi > 10) lotsi=MathFloor(lotsi);
 	if(lotsi < 0.1 && MiniForex!=0) lotsi=0.1;
 	if(lotsi < 1 && MiniForex==0) lotsi=1;
 	Comment("lotsi - ",lotsi,"\n","\n","lotsi - ",lotsi,"\n","\n","Buy - ",PrBuy);
   
  	if(PrBuy==0)
	 { //SetOrder(OP_BUY,lotsi,bid,Slippage,bid-StopLos,0,Lime);
      OrderSend(Symbol(),OP_BUY,lotsi,Bid,Slippage,Bid-StopLos,0,"",16384,0,Lime);
      LastTradeTime=CurTime();
		 					
 	 }
 	 if(PrBuy==1)
	 { //SetOrder(OP_SELL,lotsi,ask,Slippage,ask+StopLos,0,Blue);
      OrderSend(Symbol(),OP_SELL,lotsi,Ask,Slippage,Ask+StopLos,0,"",16384,0,Blue);      
      LastTradeTime=CurTime();
      return(0);		
 	 }
  }	 
}

 	
if(OrdersTotal()<1 || (CurTime()-LastTradeTime)<Timer) return(0);
   OrderSelect(0,SELECT_BY_POS,MODE_TRADES);   
   if(OrderType()==OP_BUY && OrderSymbol()==Symbol())
     {  		
         if(OrderStopLoss()<Bid-StopLos-10*Point)
           {
               // ModifyOrder(Ord(1,VAL_TICKET),Ord(1,VAL_OPENPRICE),Bid-STOPLOS,0,LightGreen);
               OrderModify(OrderTicket(),OrderOpenPrice(),Bid-StopLos,0,LightGreen);

               return(0);  
           }
     }
   
   if(OrderType()==OP_SELL && OrderSymbol()==Symbol())
  	{      
        if(OrderStopLoss()>Ask+StopLos+10*Point || OrderStopLoss()==0)
        {
           // ModifyOrder(Ord(1,VAL_TICKET),Ord(1,VAL_OPENPRICE),Ask+STOPLOS,0,Yellow);
           OrderModify(OrderTicket(),OrderOpenPrice(),Ask+StopLos,0,Yellow);
           return(0);             
        }
  	}


   
//----
   return(0);
  }
//+------------------------------------------------------------------+