//+------------------------------------------------------------------+
//|                                                  Urdala_Trol.mq4 |
//|                                         (urdala)  |
//|                                                   urdala@mail.ru |
//+------------------------------------------------------------------+
#property copyright " (urdala) "
#property link      "http://urdala-forex.at.ua"

extern string S0="   .";
extern double TP = 5;
extern string S1="(0-  ).";
extern double Lots = 0;
extern string S2="  %  (0-  ).";
extern double LotsProc=1;
extern string S3="   .";
extern int Step=40;
extern string S4=" .";
extern int TS=30;
extern string S5="  (0-    ).";
extern double Kef = 0;
extern string S6=" .";
extern int Magic=777;
extern string S7="  .(Slippage)";
extern int Slippage=3;

int D=1;
//--------------------------------------------------------------------
int start()
  {
   int OB,OS,TB,TS;
   double ProfitBuy,ProfitSell,Lot;
   double LotBuy,LotSell;
   int PipBuy,PipSell;
   if (Lots!=0) Lot=NormalizeDouble(Lots,2);
   if (LotsProc!=0) Lot=NormalizeDouble(AccountBalance()/100000*LotsProc,2);
   if (Lot<MarketInfo(Symbol(),MODE_MINLOT))Lot=MarketInfo(Symbol(),MODE_MINLOT);
   if (Digits==5 || Digits==3)D=10;
//--------------------------------------------------------------------
   for ( int i=0; i<OrdersTotal(); i++)
       {
        OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
        if (OrderSymbol()==Symbol()  && OrderType()==0 && OrderMagicNumber()==Magic)
           {
            OB++;
            ProfitBuy+=OrderProfit();
            TB=OrderTicket();
            LotBuy=OrderLots();
            PipBuy=(Bid-OrderOpenPrice())/Point/D;
           }
        if (OrderSymbol()==Symbol() &&  OrderType()==1 && OrderMagicNumber()==Magic) 
           {
            OS++;
            ProfitSell+=OrderProfit();
            TS=OrderTicket();
            LotSell=OrderLots();
            PipSell=(OrderOpenPrice()-Ask)/Point/D;
           }
        }

//--------------------------------------------------------------------
  if (OS>1)ModSell();
  if (OB>1)ModBuy();
     
//--------------------------------------------------------------------
  if (OB==0 && OS==0)
     {
      OpenOrder(Symbol(),0,Lot,NormalizeDouble(Ask,Digits),0,0,"",Magic);
      OpenOrder(Symbol(),1,Lot,NormalizeDouble(Bid,Digits),0,0,"",Magic);
      return(0);
     }
//--------------------------------------------------------------------
  if (OB==1)Tral(TB);
  if (OS==1)Tral(TS); 
//--------------------------------------------------------------------
  if (OB==0 && OS>0)
     {
      RefreshRates();
      OpenOrder(Symbol(),0,Lot,NormalizeDouble(Ask,Digits),0,0,"",Magic);
      RefreshRates();
      if (MathAbs(PipSell)>=Step && Kef==0)OpenOrder(Symbol(),1,LotSell+Lot,NormalizeDouble(Bid,Digits),0,0,"",Magic);
      if (MathAbs(PipSell)>=Step && Kef>0)OpenOrder(Symbol(),1,LotSell*Kef,NormalizeDouble(Bid,Digits),0,0,"",Magic);

     }
  if (OB>0 && OS==0)
     {
      RefreshRates();
      OpenOrder(Symbol(),1,Lot,NormalizeDouble(Bid,Digits),0,0,"",Magic);
      RefreshRates();
      if (MathAbs(PipBuy)>=Step && Kef==0)OpenOrder(Symbol(),0,LotBuy+Lot,NormalizeDouble(Ask,Digits),0,0,"",Magic);
      if (MathAbs(PipBuy)>=Step && Kef>0)OpenOrder(Symbol(),0,LotBuy*Kef,NormalizeDouble(Ask,Digits),0,0,"",Magic);

     }
//-------------------------------------------------------------------- 
   return(0);
  }
//--------------------------------------------------------------------
int ModBuy()
   { 
    double Lots,Summ,BU,Profit;
    for (int i=0; i<OrdersTotal(); i++)
        {
         OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
         if (OrderSymbol()==Symbol() && OrderType()==0  && OrderMagicNumber()==Magic){Lots=Lots+OrderLots();Summ=Summ+OrderLots()*OrderOpenPrice();}
        }
    BU=Summ/Lots;
    
    Profit=NormalizeDouble(BU+TP*D*Point,Digits);
    
    
    for (i=0; i<OrdersTotal(); i++)
       {
        OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
        if (OrderSymbol()==Symbol() && OrderType()==0  && OrderMagicNumber()==Magic)
           {
            if (NormalizeDouble(OrderTakeProfit(),Digits)!=Profit)
               {
                OrderModify(OrderTicket(),OrderOpenPrice(),0,Profit,0,CLR_NONE);
               }
           }
         }
    }
//----------------------------------------------------------------------
int ModSell()
   { 
    double Lots,Summ,BU,Profit;
    for (int i=0; i<OrdersTotal(); i++)
        {
         OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
         if (OrderSymbol()==Symbol() && OrderType()==1  && OrderMagicNumber()==Magic){Lots=Lots-OrderLots();Summ=Summ-OrderLots()*OrderOpenPrice();}
        }
    BU=Summ/Lots;
    
    Profit=NormalizeDouble(BU-TP*D*Point,Digits);
    
    
    for (i=0; i<OrdersTotal(); i++)
       {
        OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
        if (OrderSymbol()==Symbol() && OrderType()==1  && OrderMagicNumber()==Magic)
           {
            if (NormalizeDouble(OrderTakeProfit(),Digits)!=Profit)
               {
                OrderModify(OrderTicket(),OrderOpenPrice(),0,Profit,0,CLR_NONE);
               }
           }
         }
    }
//---------------------------------------------------------------
int Tral( int Ticket)
    {double TralPrice,Punkt;
    OrderSelect(Ticket,SELECT_BY_TICKET,MODE_TRADES );
    if (OrderType()==0){Punkt=(Bid-OrderOpenPrice())/Point;TralPrice=NormalizeDouble((Bid-TS*D*Point),Digits);}
    if (OrderType()==1){Punkt=(OrderOpenPrice()-Ask)/Point;TralPrice=NormalizeDouble((Ask+TS*D*Point),Digits);}
    if (Punkt<MarketInfo(Symbol(),MODE_STOPLEVEL))return(0);
    if (Punkt<TS*D)return(0);
    
    if (OrderType()==0 && TralPrice<=NormalizeDouble(OrderStopLoss(),Digits)) return(0);
    if (OrderType()==1 && TralPrice>=NormalizeDouble(OrderStopLoss(),Digits) && OrderStopLoss()!=0)return(0);
    
    ModifyOrder(OrderTicket(),OrderOpenPrice(),TralPrice,OrderTakeProfit());
    return(0);
    }
//----------------------------------------------------------------------------
int OpenOrder(string symbol,int cmd,double volume,double price,double stoploss,double takeprofit,string comment,int magic)
             {
              RefreshRates();
              int err,i,ticket;
              while(i<10)
                   {
                    if (cmd>1)ticket=OrderSend(symbol,cmd,NormalizeDouble(volume,2),NormalizeDouble(price,Digits),Slippage,0,0,comment,magic);
                    if (cmd==1)ticket=OrderSend(symbol,cmd,NormalizeDouble(volume,2),NormalizeDouble(Bid,Digits),Slippage,0,0,comment,magic);
                    if (cmd==0)ticket=OrderSend(symbol,cmd,NormalizeDouble(volume,2),NormalizeDouble(Ask,Digits),Slippage,0,0,comment,magic);
     
                    err = GetLastError();
                    if (err == 0) break;
                    Alert(Symbol(),Error(err),"    ");
                    Sleep(1000);
                    i++;
                   }
              return(ticket);
             }

//----------------------------------------------------------------------------
int ModifyOrder(int ticket,double price,double stoploss,double takeprofit)
               {
                int err,i;
                RefreshRates();
                while(i<10)
                   {
                    OrderModify(ticket,NormalizeDouble(price,Digits),NormalizeDouble(stoploss,Digits),NormalizeDouble(takeprofit,Digits),0,CLR_NONE);
                    err = GetLastError();
                    if (err == 0) break;
                    Alert(Symbol(),Error(err),"    ");
                    Sleep(1000);
                    i++;
                   }
                return(0);
               }
//----------------------------------------------------------------------------
string Error(int error_code)
  {
   string error_string;
   switch(error_code)
     {
      case 0:   error_string=" ";                                                     break;
      case 1:   error_string=" ,   ";                            break;
      case 2:   error_string=" ";                                                   break;
      case 3:   error_string=" ";                                         break;
      case 4:   error_string="  ";                                          break;
      case 5:   error_string="   ";                            break;
      case 6:   error_string="    ";                                  break;
      case 7:   error_string=" ";                                              break;
      case 8:   error_string="  ";                                         break;
      case 9:   error_string="    ";      break;
      case 64:  error_string=" ";                                              break;
      case 65:  error_string="  ";                                       break;
      case 128: error_string="    ";                          break;
      case 129: error_string=" ";                                              break;
      case 130: error_string=" ";                                             break;
      case 131: error_string=" ";                                             break;
      case 132: error_string=" ";                                                   break;
      case 133: error_string=" ";                                             break;  
      case 134: error_string="    ";                     break;
      case 135: error_string=" ";                                                break;
      case 136: error_string=" ";                                                        break;
      case 137: error_string=" ";                                                   break;
      case 138: error_string=" ";                                                     break;
      case 139: error_string="    ";                        break;
      case 140: error_string="  ";                                       break;
      case 141: error_string="  ";                                         break;
      case 145: error_string=" ,       ";    break;
      case 146: error_string="  ";                                     break;
      case 147: error_string="     ";         break;
      case 148: error_string="      ,  .";break;
      case 4000: error_string=" ";                                                      break;
      case 4001: error_string="  ";                                  break;
      case 4002: error_string="  -  ";                                  break;
      case 4003: error_string="    ";                                    break;
      case 4004: error_string="    ";                    break;
      case 4005: error_string="      ";                     break;
      case 4006: error_string="    ";                             break;
      case 4007: error_string="    ";                                 break;
      case 4008: error_string=" ";                                     break;
      case 4009: error_string="   ";                           break;
      case 4010: error_string="    ";                               break;
      case 4011: error_string="  ";                                          break;
      case 4012: error_string="    ";                                      break;
      case 4013: error_string="  ";                                                 break;
      case 4014: error_string=" ";                                             break;
      case 4015: error_string=" ";                                            break;
      case 4016: error_string=" ";                                     break;
      case 4017: error_string=" DLL  ";                                         break;
      case 4018: error_string="  ";                                 break;
      case 4019: error_string="  ";                                      break;
      case 4020: error_string="     ";                break;
      case 4021: error_string="   ,   ";         break;
      case 4022: error_string=" ";                                                  break;
      case 4050: error_string="   ";                      break;
      case 4051: error_string="   ";                         break;
      case 4052: error_string="   ";                             break;
      case 4053: error_string=" ";                                                  break;
      case 4054: error_string="  -";                    break;
      case 4055: error_string="  ";                             break;
      case 4056: error_string=" ";                                            break;
      case 4057: error_string="   ";                         break;
      case 4058: error_string="   ";                             break;
      case 4059: error_string="     ";                          break;
      case 4060: error_string="  ";                                            break;
      case 4061: error_string="  ";                                           break;
      case 4062: error_string="   string";                                  break;
      case 4063: error_string="   integer";                                 break;
      case 4064: error_string="   double";                                  break;
      case 4065: error_string="    ";                           break;
      case 4066: error_string="     ";          break;
      case 4067: error_string="    ";                         break;
      case 4099: error_string=" ";                                                     break;
      case 4100: error_string="    ";                                      break;
      case 4101: error_string="  ";                                          break;
      case 4102: error_string="   ";                                   break;
      case 4103: error_string="  ";                                         break;
      case 4104: error_string="    ";                             break;
      case 4105: error_string="    ";                                         break;
      case 4106: error_string=" ";                                              break;
      case 4107: error_string="     ";                 break;
      case 4108: error_string="  ";                                           break;
      case 4109: error_string="  .         .";            break;
      case 4110: error_string="   .    .";           break;
      case 4111: error_string="   .    .";          break;
      case 4200: error_string="  ";                                           break;
      case 4201: error_string="   ";                          break;
      case 4202: error_string="  ";                                            break;
      case 4203: error_string="  ";                                         break;
      case 4204: error_string="  ";                                               break;
      case 4205: error_string="  ";                                        break;
      case 4206: error_string="   ";                                    break;
      default:   error_string="    ";
     }
   return(error_string);
  }  







