//+------------------------------------------------------------------+
//|                                             SHI_Channel_true.mq4 |
//|                                 Copyright  2004, Shurka & Kevin |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, Shurka & Kevin"
#property link      ""
//----
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Red
#property indicator_color2 Red
#property indicator_color3 Red
#property indicator_color4 Red
#property indicator_color5 Red
#property indicator_color6 Red
#property indicator_color7 Red
#property indicator_color8 Red

#define NAME_UP_LINE "UP_LINE_"
#define NAME_DOWN_LINE "DOWN_LINE_"
#define NAME_MIDDLE_LINE "MIDDLE_"

double ExtMapBuffer1[];

//---- input parameters
extern int     AllBars           = 240;
extern int     BarsForFract      = 0;
extern color   lineColor         = Lime;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexArrow(0, 164);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexEmptyValue(0, 0.0);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   if (UninitializeReason() != REASON_CHARTCHANGE )
      DeleteObjects();
      
   return(0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DeleteObjects()
{
   if (ObjectFind(NAME_UP_LINE) == 0)
      ObjectDelete(NAME_UP_LINE);
	if (ObjectFind(NAME_DOWN_LINE) == 0)
      ObjectDelete(NAME_DOWN_LINE);
	if (ObjectFind(NAME_MIDDLE_LINE) == 0)
      ObjectDelete(NAME_MIDDLE_LINE);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   ShowSHIChannel(Period(), ExtMapBuffer1);
   
   return(0);
}
//+------------------------------------------------------------------+
//|  SHI Channel                                |
//+------------------------------------------------------------------+
void ShowSHIChannel(int timeFrame, double& mapBuffer[])
{
   int CurrentBar = 0;
   double Step = 0;
   int B1 = -1, B2 = -1;
   int UpDown = 0;
   double P1 = 0, P2 = 0, PP = 0;
   int i = 0, AB = 300, BFF = 0;
   int ishift = 0;
   double iprice = 0;
   datetime T1, T2;

//---- 
   if(AllBars == 0 || Bars < AllBars) 
      AB = Bars; 
   else 
      AB = AllBars; //AB-  
      
   if(BarsForFract > 0) 
        BFF = BarsForFract; 
   else
      switch (timeFrame)
      {
         case     1: BFF = 12; break;
         case     5: BFF = 48; break;
         case    15: BFF = 24; break;
         case    30: BFF = 24; break;
         case    60: BFF = 12; break;
         case   240: BFF = 15; break;
         case  1440: BFF = 10; break;
         case 10080: BFF = 6;  break;
         default: DeleteObjects(); return(-1); break;
      }

   CurrentBar = 2; //   ,   "
   B1 = -1; 
   B2 = -1; 
   UpDown = 0;
   while (((B1 == -1) || (B2==-1)) && (CurrentBar<AB))
   {
      //UpDown = 1     , UpDown = -1   
      // , UpDown = 0     .
      //1  2 -    ,     .
      //1  2 -       
      if ((UpDown < 1) && (CurrentBar == iLowest(NULL, timeFrame, MODE_LOW, BFF*2 + 1, CurrentBar - BFF))) 
      {
         if(UpDown == 0) 
         { 
            UpDown = -1; 
            B1 = CurrentBar; 
            P1 = Low[B1]; 
           }
         else 
         { 
            B2 = CurrentBar; 
            P2 = Low[B2];
         }
      }
      if ((UpDown > -1) && (CurrentBar == iHighest(NULL, timeFrame, MODE_HIGH, BFF*2 + 1, CurrentBar - BFF))) 
      {
         if(UpDown == 0) 
         { 
            UpDown = 1; 
            B1 = CurrentBar; 
            P1 = High[B1];
         }
         else 
         { 
            B2 = CurrentBar; 
            P2 = High[B2];
         }
      }
      CurrentBar++;
   }
   
   if((B1 == -1) || (B2 == -1)) 
   {
      DeleteObjects(); 
      return;
   } //      300  8-)

   Step = (P2 - P1) / (B2 - B1); // ,   ,   
   P1 = P1 - B1*Step; 
   B1 = 0; //      
//      .
   ishift = 0; 
   iprice = 0;
   if (UpDown == 1)
   { 
      PP = Low[2] - 2*Step;
      for (i = 3; i <= B2; i++) 
         if (Low[i] < PP + Step*i) 
            PP = Low[i] - i*Step; 
      if(Low[0] < PP) 
      {
         ishift = 0; 
         iprice = PP;
      }
      if(Low[1] < PP + Step) 
      {
         ishift = 1; 
         iprice = PP + Step;
      }
      if(High[0] > P1) 
      {
         ishift = 0; 
         iprice = P1;
      }
      if(High[1] > P1 + Step) 
      {
         ishift = 1; 
         iprice = P1 + Step;
      }
   } 
   else
   { 
      PP = High[2] - 2*Step;
      for(i = 3; i <= B2; i++) 
         if (High[i] > PP + Step*i) 
            PP = High[i] - i*Step;
      if(Low[0] < P1) 
      {
         ishift = 0; 
         iprice = P1;
      }
      if(Low[1] < P1 + Step) 
      {
         ishift = 1; 
         iprice = P1 + Step;
      }
      if(High[0] > PP) 
      {
         ishift = 0; 
         iprice = PP;
      }
      if(High[1] > PP + Step) 
      {
         ishift = 1; 
         iprice = PP + Step;
      }
   }
//       ,     
   P2 = P1 + AB*Step;
   T1 = Time[B1]; 
   T2 = Time[AB];
//    ,  0,   .
   if(iprice != 0) 
      mapBuffer[ishift] = iprice;

   string nameFirst = NAME_UP_LINE;
   string nameSecond = NAME_DOWN_LINE;
   if (PP + Step*AB < P2)
   {
      nameFirst = NAME_DOWN_LINE;
      nameSecond = NAME_UP_LINE;
   }
   ShowLine(nameFirst, T2, PP + Step*AB, T1, PP, lineColor, STYLE_SOLID, 2);
   ShowLine(nameSecond, T2, P2, T1, P1, lineColor, STYLE_SOLID, 2);
   ShowLine(NAME_MIDDLE_LINE, T2, (P2 + PP + Step*AB) / 2, T1, (P1 + PP) / 2, lineColor, STYLE_DOT, 0);
}  
//+------------------------------------------------------------------+
//|   " "                               |
//+------------------------------------------------------------------+
void ShowLine(string name, datetime time1, double price1, datetime time2, double price2, color clr, int style, int width)
{
   if (ObjectFind(name) < 0)
   {
      ObjectCreate(name, OBJ_TREND, 0, time1, price1, time2, price2); 
      ObjectSet(name, OBJPROP_COLOR, clr); 
      ObjectSet(name, OBJPROP_WIDTH, width); 
      ObjectSet(name, OBJPROP_STYLE, style); 
      return;
   }
   
   if (time1 > 0 && time2 > 0 && price1 > 0 && price2 > 0)
   {
      ObjectMove(name, 0, time1, price1);
      ObjectMove(name, 1, time2, price2);
   }
   
}
//+------------------------------------------------------------------+