#ifndef __SOVETNIKOV_EDIT_21312423dfdsf
#define __SOVETNIKOV_EDIT_21312423dfdsf

#include "..\sovetnikovGUI\defines.mqh"
#include <Controls\Edit.mqh>


class SNEdit: public CEdit
  {
protected:
   int               m_width;
   int               m_height;
   int               m_x;
   int               m_y;

public:
                     SNEdit():m_width(CONTROLS_BUTTON_WIDTH),m_height(CONTROLS_SPIN_MIN_HEIGHT){};

   void SetSize(int w=0,int h=0){if(w!=0) m_width=w; else m_width=CONTROLS_BUTTON_WIDTH; if(h!=0) m_height=h; else m_height=CONTROLS_SPIN_MIN_HEIGHT;}

   int Width(){return m_width;}
   int Height(){return m_height;}
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   bool Create(long chart,string name,int subwin,int x1,int y1)
     {

      bool bCreate=Create(chart,name,subwin,x1,y1,x1+m_width,y1+m_height);

      Move(x1,y1);

      return bCreate;

     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   virtual void DrawUpdate()
     {

     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   double GetDouble()
     {
      double ddata=0;

      string stext=Text();
      StringReplace(stext,",",".");
      ddata=StringToDouble(stext);

      return ddata;

     }
     
  string GetTime()
     {
      
      string stext=Text();
      StringReplace(stext,".",":");
      StringReplace(stext,"-",":");
      return stext;
     }   
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   int GetInteger()
     {
      int ddata=0;

      string stext=Text();
      StringReplace(stext,",",".");
      ddata=(int)StringToInteger(stext);

      return ddata;

     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   void SetDouble(double ddata,int idigits=2)
     {      
      
      Text(DoubleToString(ddata,idigits));

     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   void SetInteger(int ddata)
     {
      Text(IntegerToString(ddata));
     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   virtual bool      OnObjectEndEdit(void)
     {
      //Print(__FUNCTION__," ",Text());

      return CEdit::OnObjectEndEdit();
     }

  };
  
#endif  