
#property copyright " 2012 BJF Trading Group"
#property link      "www.iticsoftware.com"

#define vers   "1.0"


extern string _tmp1_ = " --- Trade params ---";
extern bool QuotesExtraDigit = true;
extern bool SupportECN = false;
extern int  Slippage = 3;
extern int  Magic = 20120620;

extern double Lots = 0.1;
extern int PriceOffset = 10;
extern int StopLoss = 100;
extern int TakeProfit = 50;


extern string _tmp5_ = " --- Chart ---";
extern color clBuy = DodgerBlue;
extern color clSell = Red;
extern color clModify = Silver;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include <stdlib.mqh>
#include <stderror.mqh>

int RepeatN = 5;

int BuyCnt, SellCnt;
int BuyStopCnt, SellStopCnt;
int BuyLimitCnt, SellLimitCnt;

double PrevBid = 0.0;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void init() 
{
}

void deinit() 
{
}

void start() 
{
  //-----
  
  if (IsTradeContextBusy())
  {
    Print("TradeContext is busy.");
    return;
  }
  
  //-----
  
  if (PrevBid == 0.0) PrevBid = Bid;
  
  main();
  
  PrevBid = Bid;
}

void main()
{
  //-----

  for (int i=0; i < Bars; i++)
  {  
    double UFr = iFractals(NULL, 0, MODE_UPPER, i);
    if (UFr > 0) break;
  }

  for (i=0; i < Bars; i++)
  {  
    double LFr = iFractals(NULL, 0, MODE_LOWER, i);
    if (LFr > 0) break;
  }
  
  UFr += PriceOffset*PointEx();
  LFr -= PriceOffset*PointEx();
  
  bool BuySig = (Bid < LFr && PrevBid >= LFr);
  bool SellSig = (Bid > UFr && PrevBid <= UFr);
  
  //-----
  
  RecountOrders();  
  if (BuyCnt+SellCnt > 0) return;
  
  if (OrdersCountBar0(0) > 0) return;
     
  //-----
     
  double lot;
  int ticket;
  string comment;

  if (BuySig)
  {
    //-----
    
    lot = GetLots();
    comment = "";
    
    ticket = BuyEx(Symbol(), lot, 0, StopLoss, 0, TakeProfit, Magic, comment);

    return;
  }

  if (SellSig)
  {
    //-----
  
    lot = GetLots();
    comment = "";
    
    ticket = SellEx(Symbol(), lot, 0, StopLoss, 0, TakeProfit, Magic, comment);

    return;
  } 
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

double If(bool cond, double if_true, double if_false)
{
  if (cond) return (if_true);
  return (if_false);
}

int fpc()
{
  if (QuotesExtraDigit) return (10);
  return (1); 
}

double PointEx()
{
  return (Point*fpc()); 
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

double GetLots() 
{
  return (Lots);
}

void RecountOrders()
{
  BuyCnt = 0;
  SellCnt = 0;
  BuyStopCnt = 0;
  SellStopCnt = 0;
  BuyLimitCnt = 0;
  SellLimitCnt = 0;

  int cnt = OrdersTotal();
  for (int i=0; i < cnt; i++) 
  {
    if (!OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) continue;
    if (OrderSymbol() != Symbol()) continue;
    if (OrderMagicNumber() != Magic) continue;
    
    int type = OrderType();
    if (type == OP_BUY) BuyCnt++;
    if (type == OP_SELL) SellCnt++;
    if (type == OP_BUYSTOP) BuyStopCnt++;
    if (type == OP_SELLSTOP) SellStopCnt++;
    if (type == OP_BUYLIMIT) BuyLimitCnt++;
    if (type == OP_SELLLIMIT) SellLimitCnt++;
  }
}

int OrdersCountBar0(int TF)
{
  int orders = 0;

  int cnt = OrdersTotal();
  for (int i=0; i<cnt; i++) 
  {
    if (!OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) continue;
    if (OrderSymbol() != Symbol()) continue;
    if (OrderMagicNumber() != Magic) continue;

    if (OrderOpenTime() >= iTime(NULL, TF, 0)) orders++;
  }

  int counter = 0;
  
  cnt = OrdersHistoryTotal();
  for (i=cnt-1; i >= 0; i--)
  {
    if (!OrderSelect(i, SELECT_BY_POS, MODE_HISTORY)) continue;
    if (OrderSymbol() != Symbol()) continue;
    if (OrderMagicNumber() != Magic) continue;

    if (OrderOpenTime() >= iTime(NULL, TF, 0)) orders++;
    
    counter++;
    if (counter > 10) break;
  }
 
  return (orders);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

int SleepOk = 500;
int SleepErr = 2000;

int Buy(string symbol, double lot, double price, double sl, double tp, int magic, string comment="") 
{
  int dig = MarketInfo(symbol, MODE_DIGITS);

  price = NormalizeDouble(price, dig);
  sl = NormalizeDouble(sl, dig);
  tp = NormalizeDouble(tp, dig);
    
  string _lot = DoubleToStr(lot, 2);
  string _price = DoubleToStr(price, dig);
  string _sl = DoubleToStr(sl, dig);
  string _tp = DoubleToStr(tp, dig);

  Print("Buy \"", symbol, "\", ", _lot, ", ", _price, ", ", Slippage*fpc(), ", ", _sl, ", ", _tp, ", ", magic, ", \"", comment, "\"");

  int res = OrderSend(symbol, OP_BUY, lot, price, Slippage*fpc(), sl, tp, comment, magic, 0, clBuy);
  if (res >= 0) {
    Sleep(SleepOk);
    return (res);
  } 	
   	
  int code = GetLastError();
  Print("Error opening BUY order: ", ErrorDescription(code), " (", code, ")");
  Sleep(SleepErr);
	
  return (-1);
}

int Sell(string symbol, double lot, double price, double sl, double tp, int magic, string comment="") 
{
  int dig = MarketInfo(symbol, MODE_DIGITS);

  price = NormalizeDouble(price, dig);
  sl = NormalizeDouble(sl, dig);
  tp = NormalizeDouble(tp, dig);
  
  string _lot = DoubleToStr(lot, 2);
  string _price = DoubleToStr(price, dig);
  string _sl = DoubleToStr(sl, dig);
  string _tp = DoubleToStr(tp, dig);

  Print("Sell \"", symbol, "\", ", _lot, ", ", _price, ", ", Slippage*fpc(), ", ", _sl, ", ", _tp, ", ", magic, ", \"", comment, "\"");
  
  int res = OrderSend(symbol, OP_SELL, lot, price, Slippage*fpc(), sl, tp, comment, magic, 0, clSell);
  if (res >= 0) {
    Sleep(SleepOk);
    return (res);
  } 	
   	
  int code = GetLastError();
  Print("Error opening SELL order: ", ErrorDescription(code), " (", code, ")");
  Sleep(SleepErr);
	
  return (-1);
}

int BuyEx(string symbol, double lot, double sl, int sl.pips, double tp, int tp.pips, int magic, string comment="")
{
  int ticket;
  double price;
  bool res;
  
  if (SupportECN)
  {
    for (int i=0; i<RepeatN; i++)
    {
      RefreshRates();
      price = Ask;
      
      ticket = Buy(symbol, lot, price, 0, 0, magic, comment);
      if (ticket > 0) break;
    }

    if (ticket > 0)
    {
      OrderSelect(ticket, SELECT_BY_TICKET);
      price = OrderOpenPrice();

      if (sl == 0.0) sl = If(sl.pips > 0, price - sl.pips*PointEx(), 0);
      if (tp == 0.0) tp = If(tp.pips > 0, price + tp.pips*PointEx(), 0);
    
      if (sl > 0 || tp > 0)
      {
        for (i=0; i<3*RepeatN; i++)
        {
          res = OrderModify(ticket, OrderOpenPrice(), sl, tp, 0);
          if (res) break;
          
          Sleep(SleepErr);
        }
      }
    }
  }
  
  else
  {
    for (i=0; i<RepeatN; i++)
    {
      RefreshRates();
      price = Ask;

      if (sl == 0.0) sl = If(sl.pips > 0, price - sl.pips*PointEx(), 0);
      if (tp == 0.0) tp = If(tp.pips > 0, price + tp.pips*PointEx(), 0);

      ticket = Buy(symbol, lot, price, sl, tp, magic, comment);
      if (ticket > 0) break;
    }
  }
  
  return (ticket);
}

int SellEx(string symbol, double lot, double sl, int sl.pips, double tp, int tp.pips, int magic, string comment="")
{
  int ticket;
  double price;
  bool res;
  
  if (SupportECN)
  {
    for (int i=0; i<RepeatN; i++)
    {
      RefreshRates();
      price = Bid;
      
      ticket = Sell(symbol, lot, price, 0, 0, magic, comment);
      if (ticket > 0) break;
    }

    if (ticket > 0)
    {
      OrderSelect(ticket, SELECT_BY_TICKET);
      price = OrderOpenPrice();

      if (sl == 0.0) sl = If(sl.pips > 0, price + sl.pips*PointEx(), 0);
      if (tp == 0.0) tp = If(tp.pips > 0, price - tp.pips*PointEx(), 0);
    
      if (sl > 0 || tp > 0)
      {
        for (i=0; i<3*RepeatN; i++)
        {
          res = OrderModify(ticket, OrderOpenPrice(), sl, tp, 0);
          if (res) break;
          
          Sleep(SleepErr);
        }
      }
    }
  }
  
  else
  {
    for (i=0; i<RepeatN; i++)
    {
      RefreshRates();
      price = Bid;

      if (sl == 0.0) sl = If(sl.pips > 0, price + sl.pips*PointEx(), 0);
      if (tp == 0.0) tp = If(tp.pips > 0, price - tp.pips*PointEx(), 0);

      ticket = Sell(symbol, lot, price, sl, tp, magic, comment);
      if (ticket > 0) break;
    }
  }
  
  return (ticket);
}