#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color1 C'196,253,196'
#property indicator_width1 12
#property indicator_color2 Thistle
#property indicator_width2 12
#property indicator_color3 Chocolate
#property indicator_width3 1
#property indicator_color4 FireBrick
#property indicator_width4 2
#property indicator_color5 OrangeRed
#property indicator_width5 1
extern int                Fast       = 10;
input ENUM_MA_METHOD      Fast_mode  = 1;
input ENUM_APPLIED_PRICE  Fast_price = 0;
extern int                FastShift  = 0;
extern int                Slow       = 20;
input ENUM_MA_METHOD      Slow_mode   = 1;
input ENUM_APPLIED_PRICE  Slow_price  = 0;
extern int                SlowShift   = 0;
extern int BarsCount = 1000;
extern bool ShowFreeCfndle = false;
extern int FreeArrow = 171;
extern int  = 3;
double FastMA[], SlowMA[], F[], M[];
double FreeCandle[];
datetime key;
//+------------------------------------------------------------------+
int init()  {
   IndicatorDigits(Digits+1);
   SetIndexStyle(0,DRAW_HISTOGRAM);  SetIndexBuffer(0,F);          SetIndexDrawBegin(0,10);  SetIndexLabel(0, "Up");
   SetIndexStyle(1,DRAW_HISTOGRAM);  SetIndexBuffer(1,M);          SetIndexDrawBegin(1,10);  SetIndexLabel(1, "Dn");
   SetIndexStyle(2,DRAW_LINE);       SetIndexBuffer(2,FastMA);     SetIndexLabel(2, "Fast");
   SetIndexStyle(3,DRAW_LINE);       SetIndexBuffer(3,SlowMA);     SetIndexLabel(3, "Slow");
   SetIndexStyle(4,DRAW_ARROW);      SetIndexBuffer(4,FreeCandle); SetIndexLabel(4, "Free")     ;SetIndexArrow(4,FreeArrow);
   return(0);
}
//+------------------------------------------------------------------+
int deinit()  {   return(0);  }
//+------------------------------------------------------------------+
int start()  {
   int i,limit,counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   if(BarsCount==0) BarsCount=Bars;
   if(limit > BarsCount) limit = BarsCount;
   double spread=MarketInfo(Symbol(), MODE_SPREAD)*Point;
   for(i=0; i<limit; i++){
      FastMA[i] =NormalizeDouble(iMA(NULL,0,Fast,FastShift,Fast_mode,Fast_price,i), Digits+1);
      SlowMA[i]=NormalizeDouble(iMA(NULL,0,Slow,SlowShift,Slow_mode,Slow_price,i), Digits+1);
      F[i]=FastMA[i];    M[i]=SlowMA[i];
   }
   if(key!=Time[0] && ShowFreeCfndle) {
     for(i=limit; i>=0; i--){
       if(i>0)  {
         if(High[i+1]>FastMA[i+1])  {  if(FastMA[i]>High[i] &&  Close[i]< Low[i+1]) FreeCandle[i]= Low[i]-*Point; }
         if( Low[i+1]<FastMA[i+1])  {  if( Low[i]>FastMA[i] &&  Close[i]>High[i+1]) FreeCandle[i]=High[i]+*Point; }
       }
     }
     if(FreeCandle[1]!=EMPTY_VALUE)  {
       if(FastMA[1]>High[1]) string sig="Sell";
       if(FastMA[1]<Low[1])         sig="Buy";
       Alert(Symbol(), "   ", Period(), "    !   ", sig);
     }
     key=Time[0];
   }
   return(0);
}
//+------------------------------------------------------------------+