//+--------------------------------------------------------------------------------------------+
//|HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH|
//+--------------------------------------------------------------------------------------------+
//|\           \                       JS-Stoh+BB+RSI.mq4                        /           / |
//| )----)------)---------------------------------------------------------------(------(----(  |
//|/           /         js_sergey@list.ru     2009    \           \ |
//+--------------------------------------------------------------------------------------------+
//|HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH|
//+--------------------------------------------------------------------------------------------+

#property copyright " js_sergey@list.ru "
#property link      " http://multiexperts.ru/ "

#property indicator_separate_window
#property indicator_minimum 1
#property indicator_maximum 100
#property indicator_buffers 5
#property indicator_color1 Blue
#property indicator_color2 MediumSpringGreen
#property indicator_color3 Red
#property indicator_color4 Red
#property indicator_color5 Black
#property indicator_level1  20
#property indicator_level2  30
#property indicator_level3  50
#property indicator_level4  70
#property indicator_level5  80

//---- buffers
extern string  in1                =  " Stochastic  ";
extern int     KPeriod            =  28;
extern int     DPeriod            =  3;
extern int     Slowing            =  5;
//---
extern string  in2                =  " Bollinger  ";
extern int     BandsPeriod        =  10;
extern int     BandsShift         =  0;
extern double  BandsDeviations    =  1.0;
//---
extern string  in3                =  " RSI  ";
extern int     RSIPeriod          =  4;
//---

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM, STYLE_SOLID);   
   SetIndexStyle(1,DRAW_HISTOGRAM, STYLE_SOLID);
   SetIndexStyle(2,DRAW_HISTOGRAM, STYLE_SOLID);
   SetIndexStyle(3,DRAW_HISTOGRAM, STYLE_SOLID);
   SetIndexStyle(4,DRAW_HISTOGRAM, STYLE_SOLID);
//----  
   IndicatorBuffers(5);
//---- indicator lines
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1, ExtMapBuffer2);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2, ExtMapBuffer3);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3, ExtMapBuffer4);
   SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(4, ExtMapBuffer5);
//----
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- main loop
   for(int i=0; i<limit; i++){
     ExtMapBuffer1[i]=iStochastic(NULL,0,KPeriod,DPeriod,Slowing,MODE_SMMA,0,0,i);  
     ExtMapBuffer2[i]=iRSI(NULL,0,RSIPeriod,PRICE_CLOSE,i);
   }
   for(int k=0; k<limit; k++){
     ExtMapBuffer3[k]=iBandsOnArray(ExtMapBuffer1,0,BandsPeriod,BandsDeviations,BandsShift,MODE_UPPER,k);
     ExtMapBuffer4[k]=iBandsOnArray(ExtMapBuffer1,0,BandsPeriod,BandsDeviations,BandsShift,MODE_LOWER,k);
   } 
   for(int n=0; n<limit; n++){
     ExtMapBuffer5[n]=iMAOnArray(ExtMapBuffer1,0,BandsPeriod,0,0,n);
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+