//+------------------------------------------------------------------+
//|                                                  e-Pivot-ice.mq4 |
//|                                             . aka KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|   01.12.2005     Pivot.  ice.               |
//+------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"

//-------    --------------------------------
extern string _Parameters_Trade = "-----  ";
extern double Lots          = 0.1;   //   
extern int    HourSetOrders = 10;    //   
extern int    HourDelOrders = 0;     //   
extern int    Slippage      = 3;     //  

extern string _Parameters_Expert = "-----  ";
extern int   MAGIC        = 20051114;
extern color clOpenBuy    = LightBlue;    //   
extern color clOpenSell   = LightCoral;   //   
extern color clModifyBuy  = Aqua;         //   
extern color clModifySell = Tomato;       //   
extern color clCloseBuy   = Blue;         //   
extern color clCloseSell  = Red;          //   

//----    -------------------------------

//-------    ---------------------------------
#include <s-Pivot.mqh>

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
void start() {
  if (Hour()==HourSetOrders && Minute()<1) SetOrders();
  DeleteOppositeOrders();
  CarryingInWL();
  if (Hour()==HourDelOrders) {
    CloseAllPositions();
    DeleteAllOrders();
  }
}

//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
void SetOrders() {
  double ldStop=0, ldTake=0;
  double ms[7]={0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

  GetSignals("", 0, 0, ms);

  //    
  if (!ExistOrder(1)) {
    ldStop=ms[6]; ldTake=ms[1];
    SetOrder(OP_SELLLIMIT, ms[2], ldStop, ldTake, 1);
  }

  //    
  if (!ExistOrder(2)) {
    ldStop=ms[5]; ldTake=ms[2];
    SetOrder(OP_BUYLIMIT, ms[1], ldStop, ldTake, 2);
  }
}

//+------------------------------------------------------------------+
//|               |
//+------------------------------------------------------------------+
bool ExistOrder(int mn) {
  bool Exist=False;
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC+mn) {
        Exist=True; break;
      }
    }
  }
  return(Exist);
}

//+------------------------------------------------------------------+
//|                        |
//+------------------------------------------------------------------+
bool ExistPosition(int mn) {
  bool Exist=False;
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC+mn) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          Exist=True; break;
        }
      }
    }
  }
  return(Exist);
}

//+------------------------------------------------------------------+
//|                                                   |
//| :                                                       |
//|   op     -                                               |
//|   pp     -                                                   |
//|   ldStop -                                            |
//|   ldTake -                                            |
//|   mn     -   MAGIC                                      |
//+------------------------------------------------------------------+
void SetOrder(int op, double pp, double ldStop, double ldTake, int mn) {
  color clOpen;

  if (op==OP_BUYLIMIT || op==OP_BUYSTOP ) clOpen=clOpenBuy; else clOpen=clOpenSell;
  OrderSend(Symbol(),op,Lots,pp,Slippage,ldStop,ldTake,"",MAGIC+mn,0,clOpen);
}

//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void CloseAllPositions() {
  for (int i=OrdersTotal()-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderMagicNumber()>MAGIC && OrderMagicNumber()<=MAGIC+2) {
        if (OrderSymbol()==Symbol()) {
          if (OrderType()==OP_BUY) {
            OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, clCloseBuy);
          }
          if (OrderType()==OP_SELL) {
            OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, clCloseSell);
          }
        }
      }
    }
  }
}

//+------------------------------------------------------------------+
//|                                               |
//+------------------------------------------------------------------+
void DeleteAllOrders() {
  for (int i=OrdersTotal()-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderMagicNumber()>MAGIC && OrderMagicNumber()<=MAGIC+2) {
        if (OrderSymbol()==Symbol()) {
          if (OrderType()==OP_BUYLIMIT || OrderType()==OP_SELLLIMIT
          || OrderType()==OP_BUYSTOP || OrderType()==OP_SELLSTOP) {
            OrderDelete(OrderTicket());
          }
        }
      }
    }
  }
}

//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+
void DeleteOppositeOrders() {
  bool fep1, fep2;

  fep1=ExistPosition(1);
  fep2=ExistPosition(2);

  for (int i=OrdersTotal()-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol()) {
        if ((OrderType()==OP_SELLLIMIT || OrderType()==OP_BUYSTOP)
        && OrderMagicNumber()==MAGIC+1) {
          if (fep2) OrderDelete(OrderTicket());
        }
        if ((OrderType()==OP_BUYLIMIT || OrderType()==OP_SELLSTOP)
        && OrderMagicNumber()==MAGIC+2) {
          if (fep1) OrderDelete(OrderTicket());
        }
      }
    }
  }
}

//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
void CarryingInWL() {
  double ms[7]={0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

  GetSignals("", 0, 0, ms);

  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderMagicNumber()>MAGIC && OrderMagicNumber()<=MAGIC+2) {
        if (OrderSymbol()==Symbol()) {
          if (OrderType()==OP_BUY) {
            if (Bid>ms[0] && OrderStopLoss()!=OrderOpenPrice()) {
              ModifyStopLoss(OrderOpenPrice(), clModifyBuy);
            }
          }
          if (OrderType()==OP_SELL) {
            if (Ask<ms[0] && OrderStopLoss()!=OrderOpenPrice()) {
              ModifyStopLoss(OrderOpenPrice(), clModifySell);
            }
          }
        }
      }
    }
  }
}

//+------------------------------------------------------------------+
//|   StopLoss                                          |
//| :                                                       |
//|   ldStop   -  StopLoss                                    |
//|   clModify -                                      |
//+------------------------------------------------------------------+
void ModifyStopLoss(double ldStop, color clModify) {
  double ldOpen=OrderOpenPrice();
  double ldTake=OrderTakeProfit();

  OrderModify(OrderTicket(), ldOpen, ldStop, ldTake, 0, clModify);
}
//+------------------------------------------------------------------+

