//+------------------------------------------------------------------+
//|                                                    Follow-up.mq4 |
//|                                Copyright  2006, just an advisor |
//|                                               http://www.foo.bar |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, just an advisor"
#property link      "http://www.foo.bar"

//---- input parameters
extern int ticket = 0;
extern int nolossLevel = 15;   //   
extern int plusLevel   = 25;   //    
extern int plusValue   =  5;   //  
extern int trailLevel  = 30;   //   
extern int trailValue  = 25;   //  
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{
   if (   OrderSelect (ticket, SELECT_BY_TICKET) //  
       && 0 == OrderCloseTime()                  //    
       && OrderSymbol () == Symbol ()            //   
       ) {  
      double newStop = OrderStopLoss ();
      switch (OrderType ()) {
         case OP_BUY:
            //  - BUY
            if (Ask >= OrderOpenPrice () + trailLevel * Point) {
               //  trailLevel  - 
               newStop = Ask - trailValue * Point;
            } else if (Ask >= OrderOpenPrice () + plusLevel * Point) {
               //  plusLevel  - +plusValue
               newStop = OrderOpenPrice () + plusValue * Point;
            } else if (Ask >= OrderOpenPrice () + nolossLevel * Point) {
               //  nolossLevel  - 
               newStop = OrderOpenPrice ();
            }
            if (newStop > OrderStopLoss ()) {
               OrderModify(ticket,OrderOpenPrice(),newStop,OrderTakeProfit(),OrderExpiration());
            }
            break;
         case OP_SELL:
            //  - SELL
            if (Bid <= OrderOpenPrice () - trailLevel * Point) {
               //  trailLevel  - 
               newStop = Bid - trailValue * Point;
            } else if (Bid <= OrderOpenPrice () - plusLevel * Point) {
               //  plusLevel  - +plusValue
               newStop = OrderOpenPrice () - plusValue * Point;
            } else if (Bid <= OrderOpenPrice () - nolossLevel * Point) {
               //  nolossLevel  - 
               newStop = OrderOpenPrice ();
            }
            if (newStop < OrderStopLoss ()) {
               OrderModify(ticket,OrderOpenPrice(),newStop,OrderTakeProfit(),OrderExpiration());
            }
            break;
      }
   }
   return(0);
}
//+------------------------------------------------------------------+