//+------------------------------------------------------------------+
//|                                                TradeChannel2.mq4 |
//|                                   Copyright  2005, Yuri Makarov |
//|                                       http://mak.tradersmind.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Yuri Makarov"
#property link      "http://mak.tradersmind.com"

extern double Lots  = 0.1;
extern int Slippage = 5;
extern int TimeOut  = 10000;
extern int Traling  = 0;
extern int Magic    = 0;

double SetLevel(double Level, double NewLevel, string ObjName = "", int Style = 0)
{
   switch (Style)
   {
   case 1:  // Buy Order line
      ObjectSet(ObjName,OBJPROP_COLOR,Blue);
      ObjectSet(ObjName,OBJPROP_STYLE,STYLE_SOLID);
      ObjectSet(ObjName,OBJPROP_WIDTH,1);
      break;
   case 2:  // Sell Order line
      ObjectSet(ObjName,OBJPROP_COLOR,Red);
      ObjectSet(ObjName,OBJPROP_STYLE,STYLE_SOLID);
      ObjectSet(ObjName,OBJPROP_WIDTH,1);
      break;
   case 3:  // Buy Stop line
      ObjectSet(ObjName,OBJPROP_COLOR,Blue);
      ObjectSet(ObjName,OBJPROP_STYLE,STYLE_DASH);
      ObjectSet(ObjName,OBJPROP_WIDTH,1);
      break;
   case 4:  // Sell Stop line
      ObjectSet(ObjName,OBJPROP_COLOR,Red);
      ObjectSet(ObjName,OBJPROP_STYLE,STYLE_DASH);
      ObjectSet(ObjName,OBJPROP_WIDTH,1);
      break;
   case 5:  // Buy Take line
      ObjectSet(ObjName,OBJPROP_COLOR,Blue);
      ObjectSet(ObjName,OBJPROP_STYLE,STYLE_DOT);
      ObjectSet(ObjName,OBJPROP_WIDTH,1);
      break;
   case 6:  // Sell Take line
      ObjectSet(ObjName,OBJPROP_COLOR,Red);
      ObjectSet(ObjName,OBJPROP_STYLE,STYLE_DOT);
      ObjectSet(ObjName,OBJPROP_WIDTH,1);
      break;
   }
   
   if (MathAbs(NewLevel - Close[0]) < MathAbs(Level - Close[0])) return (NewLevel);
   else return (Level);
}

int start()
{
  /* if (!IsDemo()) 
      {
      Alert("   !!!");
      return(-1);      
      }*/
   int    NumObj = ObjectsTotal();
   double Spread = Ask - Bid;
   
   double pBuy  = 0;
   double pSell = 0;
   double pBuyStop = 0;
   double pBuyTake = 0;
   double pSellStop = 0;
   double pSellTake = 0;

   for (int i = 0; i < NumObj; i++)
   {
      string ObjName = ObjectName(i);
      string ObjDesc = ObjectDescription(ObjName);
      double Price = 0;

      switch (ObjectType(ObjName))
      {
      case OBJ_HLINE:
         Price = ObjectGet(ObjName,OBJPROP_PRICE1); 
         break;
      case OBJ_TREND:
         Price = ObjectGetValueByShift(ObjName,0); 
         break;
      }

      if (Price > 0)
      {
         if (ObjDesc == "Buy")  
         {
            pBuy      = SetLevel(pBuy,  Price, ObjName, 1); 
            pSellTake = SetLevel(pSellTake,  Price); 
         } else
         if (ObjDesc == "Sell") 
         {
            pSell    = SetLevel(pSell, Price, ObjName, 2); 
            pBuyTake = SetLevel(pBuyTake, Price); 
         } else
         if (ObjDesc == "Stop") 
         {
            if (Price < Close[0]) 
            {
               pBuyStop = SetLevel(pBuyStop, Price, ObjName, 3);
               pSellTake = SetLevel(pSellTake,  Price); 
            } else 
            {
               pSellStop = SetLevel(pSellStop, Price, ObjName, 4); 
               pBuyTake = SetLevel(pBuyTake, Price); 
            }
         } else
         if (ObjDesc == "Take") 
         {
            if (Price > Close[0]) 
            {
               pBuyTake = SetLevel(pBuyTake, Price, ObjName, 5);
               pSellStop = SetLevel(pSellStop,  Price); 
            } else 
            {
               pSellTake = SetLevel(pSellTake, Price, ObjName, 6);
               pBuyStop = SetLevel(pBuyStop, Price); 
            }
         }
      }
   }
   
   int NumOrders = OrdersTotal();
   int NumPos = 0;

   for (i = 0; i < NumOrders; i++)
   {
      if (!OrderSelect(i, SELECT_BY_POS)) continue;
      if (OrderSymbol() != Symbol()) continue;
      if (Magic > 0 && Magic != OrderMagicNumber()) continue;
      
      NumPos++;

      double tp = OrderTakeProfit();
      double sl = OrderStopLoss();
      double ts = 0;

      if (OrderType() == OP_BUY)
      {
         if (Bid > pSell && pSell > 0)
         {
            OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, Red);
            Sleep(TimeOut);
            return(0);
         }

         ts = pBuyStop;
         if (Traling > 10) ts = MathMax(pBuyStop, Bid - Traling*Point);
         
         if (MathAbs(tp - pBuyTake) > Spread || MathAbs(sl - ts) > Spread) 
         {
            OrderModify(OrderTicket(), Ask, ts, pBuyTake, 0);
            Sleep(TimeOut);
            return(0);
         }
      }

      if (OrderType() == OP_SELL)
      {
         if (Ask < pBuy)
         {
            OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, Red);
            Sleep(TimeOut);
            return(0);
         }

         ts = pSellStop;
         if (Traling > 10)
         if (pSellStop > 0) ts = MathMin(pSellStop, Ask + Traling*Point);
         else               ts = Ask + Traling*Point;
         
         if (MathAbs(tp - pSellTake) > Spread || MathAbs(sl - ts) > Spread) 
         {
            OrderModify(OrderTicket(), Bid, ts, pSellTake, 0);
            Sleep(TimeOut);
            return(0);
         }
      }
   }
   
   if (NumPos > 0) return(0);
   if (pSell > 0 && (pSell - pBuy) < Spread*2) return(0);
      
   if (Bid > pSell && pSell > pBuyStop)
   {
      OrderSend(Symbol(), OP_SELL, Lots, Bid, Slippage, pSellStop, pSellTake,
         "Magic: "+Magic+" ", Magic);
      Sleep(TimeOut);
      return(0);
   }

   if (Ask < pBuy && (pBuy < pSellStop || pSellStop == 0))
   {
      OrderSend(Symbol(), OP_BUY, Lots, Ask, Slippage, pBuyStop, pBuyTake,
         "Magic: "+Magic+" ", Magic);
      Sleep(TimeOut);
      return(0);
   }
}

int init()   {}
int deinit() {}