//+------------------------------------------------------------------+
//|                                                       et4_3MA_v1 |
//|                                               goldenlion@ukr.net |
//|                                      http://GlobeInvestFund.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2005,            http://GlobeInvestFund.com/       goldenlion@ukr.net"
#property link      "http://GlobeInvestFund.com/"

#include <stdlib.mqh>

#define MAGICNUMBER 778

extern double MA1 = 20, MA2 = 24, MA3 = 20; 

extern double TakeProfit = 500;
extern double Lots = 0.1;
extern double StopLoss = 500;

extern double Slippage = 3;

extern double LogOn = 0;

///////////////////////////////////////////
int newCandel = 0;


int prev_candel_time = 0;

int err;

int ticket;

int LastTradeTime, OrderMode;

double MAS1, MAS2, MAL1, MAL2;

double Stop, Take;

//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+
int Log( string str, color Col = Gold )
  {
  double tmp;
 
  if( LogOn == 1 || LogOn == 2 )
     Print(str);

  if( LogOn == 1 || LogOn == 3 )
     { 
     tmp = MathRand();
     ObjectCreate("text"+tmp, OBJ_TEXT, 0, Time[0], Close[0]);
     ObjectSetText("text"+tmp, str  ,10, "Arial", Col );
     }
 
  return (0);
  }

//+------------------------------------------------------------------+
//|  ,                      |
//+------------------------------------------------------------------+
bool MOrderDelete( int ticket )
  {
  int Res;

  LastTradeTime = CurTime();

  Res = OrderDelete( ticket );
  err=GetLastError();

  if( Res == -1 )
    Log("OrderDelete failed with error #"+err+" : "+ErrorDescription(err));
     
  return ( Res );
  }

bool MOrderClose( int ticket, double lots, double price, int slippage, color Color=CLR_NONE)
  {
  int Res;

  LastTradeTime = CurTime();
  price = MathRound(price*10000)/10000;
 
  Res = OrderClose( ticket, lots, price, slippage, Color);
  err=GetLastError();
 
  if( Res == -1 )
    Log("OrderClose failed with error #"+err+" : "+ErrorDescription(err));
 
  return ( Res );
  }

bool MOrderModify( int ticket, double price, double stoploss, double takeprofit, datetime expiration, color arrow_color=CLR_NONE)
  {
  LastTradeTime = CurTime();
  price = MathRound(price*10000)/10000;
  return ( OrderModify( ticket, price, stoploss, takeprofit, expiration, arrow_color) );
  }

int MOrderSend( string symbol, int cmd, double volume, double price, int slippage, double stoploss, double takeprofit, string comment="", int magic=0, datetime expiration=0, color arrow_color=CLR_NONE)
  {
  int Res;
  LastTradeTime = CurTime();
  price = MathRound(price*10000)/10000;
 
  Res = OrderSend( symbol, cmd, volume, price, slippage, stoploss, takeprofit, comment, magic, expiration, arrow_color );
  err = GetLastError();
 
  if( Res == -1 )
    Log("OrderSend failed with error #" + err + " : " + ErrorDescription(err));
 
  return ( Res ); //   -1
  }


//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+
double LotsCalc()
  {
  double Lots2 = Lots;
 
  if( Lots2 < 0 ) Lots2 = ( MathFloor( ( AccountBalance() /1000*(-Lots2))/10 )/10 );
   
  if ( Lots2 < 0.1 ) return (0.1);
 
  return (Lots2);
  }


//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
int CheckLevels()
  {
  if( prev_candel_time == Time[0] ) newCandel = 0;
  else
     {
     newCandel = 1;
     prev_candel_time = Time[0];
     }

  if( ! newCandel ) return(0); //    

//      

  OrderMode = 0;
 
  MAS1 = iMA(NULL, 0, MA1, 0, MODE_SMA, PRICE_CLOSE, 1);
  MAS2 = iMA(NULL, 0, MA1, 0, MODE_SMA, PRICE_CLOSE, 2);

  MAL1 = iMA(NULL, 0, MA3, 0, MODE_LWMA, PRICE_CLOSE, 1);
  MAL2 = iMA(NULL, 0, MA3, 0, MODE_LWMA, PRICE_CLOSE, 2);
     
  if( MAS1 < MAL1 && MAS2 >= MAL2 ) OrderMode = -1;
  if( MAS1 > MAL1 && MAS2 <= MAL2 ) OrderMode = 1;

  return(0);
  }

//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
int OpenPos()
  {
  if( OrdersTotal() == 0 )
    {
    if( OrderMode == 1 )
      {
      Take = Ask+TakeProfit*Point;
      Stop = Ask-StopLoss*Point;

      ticket=MOrderSend(Symbol(),OP_BUY, LotsCalc(),Ask ,Slippage,Stop,Take,"",MAGICNUMBER,0,Blue);

      return(1);
      }

    if( OrderMode == -1 )
      {
      Take = Bid-TakeProfit*Point;
      Stop = Bid+StopLoss*Point;

      ticket=MOrderSend(Symbol(),OP_SELL, LotsCalc(),Bid ,Slippage,Stop,Take,"",MAGICNUMBER,0,Red);

      return(1);
      }
    }

  return(0);
  }

//+------------------------------------------------------------------+
//|                                                      |
//+------------------------------------------------------------------+
int MovePos()
  {
  // 

  return(0);
  }

//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
int ClosePos()
  {
  int cnt;

     for(cnt=0;cnt<OrdersTotal();cnt++)
       {
       if(OrderSelect(cnt,SELECT_BY_POS)==false) continue;
       if( OrderSymbol() != Symbol() ) continue;

       if( OrderType() == OP_BUY && OrderMode == -1 ) //   
         {
         MOrderClose(OrderTicket(),OrderLots(),Bid,3,Gold);
         return(1);
         }
         
       if( OrderType() == OP_SELL && OrderMode == 1 ) //   
         {
         MOrderClose(OrderTicket(),OrderLots(),Ask,3,Gold);
         return(1);
         }
       }

  return(0);
  }

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
  return(0);
  }


//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
  return(0);
  }


//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
  if( CurTime() - LastTradeTime < 30 ) return (0); //  30    

  CheckLevels();
 
  if ( OpenPos() == 1 ) return(0);
  if ( MovePos() == 1 ) return(0);
  if ( ClosePos() == 1 ) return(0);
 
  return(0);
  }
// the end. 

