//+------------------------------------------------------------------+
//|                                                    e-ADX+SAR.mq4 |
//|                                                  kuk1970 & KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|   02.02.2006      ADX  SAR.                 |
//| http://www.finlist.ru/community/showthread.php?t=1008            |
//+------------------------------------------------------------------+
#property copyright "kuk1970 & KimIV"
#property link      "http://www.kimiv.ru"
#define   MAGIC     20060202

//-------    --------------------------------
extern string _P_Indicators = "----------  ";
extern int ADX_Period = 14;      //  ADX

//----    -------------------------------
double Lots          = 0.1;          //   
int    Slippage      = 5;            //  
bool   UseSound      = True;         //   
string NameFileSound = "expert.wav"; //   
color  clOpenBuy     = LightBlue;    //   
color  clOpenSell    = LightCoral;   //   
color  clModifyBuy   = Aqua;         //   
color  clModifySell  = Tomato;       //   
color  clCloseBuy    = Blue;         //   
color  clCloseSell   = Red;          //   
int    prevTimeBar;

//-------    ---------------------------------
#include <a-TrailingSAR.mqh>
#include <stdlib.mqh>

//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
void deinit() {
  Comment("");
}

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
void start() {
  if (prevTimeBar!=Time[0]) OpenPositions();
  if (UseTrailing) TrailingPositions();
  prevTimeBar=Time[0];
}

//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
void OpenPositions() {
  int bs=GetTradeSignal();

  if (!ExistPosition()) {
    if (bs>0) OpenPosition(OP_BUY, 0, 0);
    if (bs<0) OpenPosition(OP_SELL, 0, 0);
  }
}

//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
int GetTradeSignal() {
  double adx=iADX(NULL, 0, ADX_Period, PRICE_CLOSE, MODE_MAIN, 1);
  double dp1=iADX(NULL, 0, ADX_Period, PRICE_CLOSE, MODE_PLUSDI, 1);
  double dm1=iADX(NULL, 0, ADX_Period, PRICE_CLOSE, MODE_MINUSDI, 1);
  double dp2=iADX(NULL, 0, ADX_Period, PRICE_CLOSE, MODE_PLUSDI, 2);
  double dm2=iADX(NULL, 0, ADX_Period, PRICE_CLOSE, MODE_MINUSDI, 2);
  double sar=iSAR(NULL, 0, StepParabolic, MaxParabolic, 1);
  int    bs=0;

  if (sar>Close[1]) {
    if (dm2<dp2 && dm1>dp1 && (adx>dm1 || adx>dp1)) bs=-1;
  }
  if (sar<Close[1]) {
    if (dm2>dp2 && dm1<dp1 && (adx>dm1 || adx>dp1)) bs=1;
  }

  return(bs);
}

//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+
bool ExistPosition() {
  bool Exist=False;
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC) {
        Exist=True; break;
      }
    }
  }
  return(Exist);
}

//+------------------------------------------------------------------+
//|                                                   |
//| :                                                       |
//|   op     -                                               |
//|   ldStop -                                            |
//|   ldTake -                                            |
//+------------------------------------------------------------------+
void OpenPosition(int op, double ldStop, double ldTake) {
  color  clOpen;
  double pp;

  if (op==OP_BUY) {
    clOpen=clOpenBuy; pp=Ask;
  } else {
    clOpen=clOpenSell; pp=Bid;
  }
  OrderSend(Symbol(),op,Lots,pp,Slippage,ldStop,ldTake,"",MAGIC,0,clOpen);
}
//+------------------------------------------------------------------+

